/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextRuntimeException;
import org.gvsig.fmap.mapcontext.Messages;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerDrawEvent;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.operations.ComposedLayer;
import org.gvsig.fmap.mapcontext.layers.operations.InfoByPoint;
import org.gvsig.fmap.mapcontext.layers.operations.LayerCollection;
import org.gvsig.fmap.mapcontext.layers.operations.LayerNotFoundInCollectionException;
import org.gvsig.fmap.mapcontext.layers.operations.LayersVisitable;
import org.gvsig.fmap.mapcontext.layers.operations.LayersVisitor;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelable;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.impl.MultiDynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayers
extends FLyrDefault
implements LayerCollection,
InfoByPoint,
List<FLayer> {
    protected ArrayList<LayerCollectionListener> layerCollectionListeners = new ArrayList();
    protected List<FLayer> layers = Collections.synchronizedList(new ArrayList());
    protected MapContext fmap;
    private static final Logger LOGGER = LoggerFactory.getLogger(FLayers.class);
    public static final Predicate<FLayer> LAYER_ACTIVE = new Predicate<FLayer>(){

        @Override
        public boolean test(FLayer layer) {
            return layer.isActive();
        }
    };
    public static final Predicate<FLayer> LAYER_AVALAIBLE = new Predicate<FLayer>(){

        @Override
        public boolean test(FLayer layer) {
            return layer.isAvailable();
        }
    };
    public static Predicate<FLayer> LAYER_FLYRVECT = new Predicate<FLayer>(){

        @Override
        public boolean test(FLayer layer) {
            return layer instanceof FLyrVect;
        }
    };
    public static Predicate<FLayer> LAYER_SELECTION_AVAILABLE = new Predicate<FLayer>(){

        @Override
        public boolean test(FLayer layer) {
            if (layer instanceof FLyrVect) {
                try {
                    FeatureStore store = ((FLyrVect)layer).getFeatureStore();
                    if (store.isFeatureSelectionAvailable()) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return false;
        }
    };
    public static Predicate<FLayer> LAYER_SELECTION_EMPTY = new Predicate<FLayer>(){

        @Override
        public boolean test(FLayer layer) {
            if (layer instanceof FLyrVect) {
                try {
                    FeatureStore store = ((FLyrVect)layer).getFeatureStore();
                    return !store.isFeatureSelectionAvailable() || store.isFeatureSelectionEmpty();
                }
                catch (Exception ex) {
                    return true;
                }
            }
            return true;
        }
    };

    @Override
    public void addLayerCollectionListener(LayerCollectionListener listener) {
        if (!this.layerCollectionListeners.contains(listener)) {
            this.layerCollectionListeners.add(listener);
        }
    }

    @Override
    public void setAllVisibles(boolean visible) {
        for (int i = 0; i < this.layers.size(); ++i) {
            FLayer lyr = this.layers.get(i);
            lyr.setVisible(visible);
            if (!(lyr instanceof LayerCollection)) continue;
            ((LayerCollection)((Object)lyr)).setAllVisibles(visible);
        }
    }

    @Override
    public void removeLayerCollectionListener(LayerCollectionListener listener) {
        this.layerCollectionListeners.remove(listener);
    }

    private void doAddLayer(int pos, FLayer layer) {
        this.layers.add(pos, layer);
        ToolsLocator.getDisposableManager().bind((Disposable)layer);
        layer.setParentLayer(this);
        IProjection layerProj = layer.getProjection();
        if (layerProj != null && this.fmap != null) {
            IProjection mapContextProj = this.fmap.getProjection();
            if (!layerProj.getAbrev().equals(mapContextProj.getAbrev())) {
                ICoordTrans ct = layerProj.getCT(mapContextProj);
                layer.setCoordTrans(ct);
            } else {
                layer.setCoordTrans(null);
            }
        }
        this.updateDrawVersion();
    }

    @Override
    public void addLayer(FLayer layer) {
        MapContext mco = this.getMapContext();
        if (mco != null) {
            int position = mco.getOrderManager().getPosition(this, layer);
            this.addLayer(position, layer);
        } else {
            this.addLayer(this.layers.size(), layer);
        }
    }

    public void addLayer(DataStore store) {
        FLayer layer;
        try {
            layer = MapContextLocator.getMapContextManager().createLayer(store.getName(), store);
        }
        catch (LoadLayerException ex) {
            throw new RuntimeException("Can't create layer from store.", (Throwable)((Object)ex));
        }
        this.addLayer(layer);
    }

    public void addLayer(int pos, FLayer layer) {
        try {
            if (layer instanceof FLayers) {
                FLayers layersToAdd = (FLayers)layer;
                if (this.fmap != null) {
                    this.fmap.addAsCollectionListener(layersToAdd);
                }
            }
            this.callLayerAdding(LayerCollectionEvent.createLayerAddingEvent(layer));
            this.doAddLayer(pos, layer);
            this.callLayerAdded(LayerCollectionEvent.createLayerAddedEvent(layer));
        }
        catch (CancelationException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    @Override
    public void moveTo(int from, int to) throws CancelationException {
        int newfrom = this.layers.size() - from - 1;
        int newto = this.layers.size() - to - 1;
        if (newfrom < 0 || newfrom >= this.layers.size() || newto < 0 || newto >= this.layers.size()) {
            return;
        }
        FLayer aux = this.layers.get(newfrom);
        this.callLayerMoving(LayerPositionEvent.createLayerMovingEvent(aux, newfrom, newto));
        this.layers.remove(newfrom);
        this.layers.add(newto, aux);
        this.updateDrawVersion();
        this.callLayerMoved(LayerPositionEvent.createLayerMovedEvent(aux, newfrom, newto));
    }

    private void doRemoveLayer(FLayer lyr) {
        this.layers.remove(lyr);
        lyr.dispose();
        this.updateDrawVersion();
    }

    @Override
    public void removeLayer(FLayer lyr) throws CancelationException {
        this.callLayerRemoving(LayerCollectionEvent.createLayerRemovingEvent(lyr));
        this.doRemoveLayer(lyr);
        this.callLayerRemoved(LayerCollectionEvent.createLayerRemovedEvent(lyr));
    }

    @Override
    public void removeLayer(int idLayer) {
        FLayer lyr = this.layers.get(idLayer);
        this.callLayerRemoving(LayerCollectionEvent.createLayerRemovingEvent(lyr));
        this.doRemoveLayer(lyr);
        this.callLayerRemoved(LayerCollectionEvent.createLayerRemovedEvent(lyr));
    }

    @Override
    public void removeLayer(String layerName) {
        for (int i = 0; i < this.layers.size(); ++i) {
            FLayer lyr = this.layers.get(i);
            if (lyr.getName().compareToIgnoreCase(layerName) != 0) continue;
            this.removeLayer(i);
            break;
        }
    }

    public void replaceLayer(String layerName, FLayer layer) throws LoadLayerException {
        this.replaceLayer(this.getLayer(layerName), layer);
    }

    public void replaceLayer(FLayer layer, FLayer newLayer) throws LoadLayerException {
        this.replaceLayer(this, layer, newLayer);
    }

    private void replaceLayer(FLayers parentLayer, FLayer layer, FLayer newLayer) throws LoadLayerException {
        for (int i = 0; i < parentLayer.getLayersCount(); ++i) {
            FLayer lyr = parentLayer.getLayer(i);
            if (lyr.equals(layer)) {
                parentLayer.removeLayer(i);
                parentLayer.addLayer(i, newLayer);
                break;
            }
            if (!(lyr instanceof LayerCollection)) continue;
            this.replaceLayer((FLayers)lyr, layer, newLayer);
        }
    }

    @Override
    public FLayer[] getVisibles() {
        ArrayList<FLayer> array = new ArrayList<FLayer>();
        LayersIterator iter = new LayersIterator(this){

            @Override
            public boolean evaluate(FLayer layer) {
                return layer.isVisible();
            }
        };
        while (iter.hasNext()) {
            array.add(iter.nextLayer());
        }
        return array.toArray(new FLayer[0]);
    }

    @Override
    public FLayer getLayer(int index) {
        return this.layers.get(index);
    }

    @Override
    public FLayer getLayer(final String layerName) {
        if (StringUtils.isBlank((CharSequence)layerName)) {
            return null;
        }
        for (FLayer layer : this.layers) {
            if (layer != null && StringUtils.equalsIgnoreCase((CharSequence)layer.getName(), (CharSequence)layerName)) {
                return layer;
            }
            if (!(layer instanceof FLayers)) continue;
            List<FLayer> theLayers = this.getLayers(new Predicate<FLayer>(){

                @Override
                public boolean test(FLayer layer) {
                    return StringUtils.equalsIgnoreCase((CharSequence)layer.getName(), (CharSequence)layerName);
                }
            });
            if (theLayers.isEmpty()) {
                return null;
            }
            return theLayers.get(0);
        }
        return null;
    }

    @Override
    public FLayer getLayer(final DataStore store) {
        List<FLayer> theLayers = this.getLayers(new Predicate<FLayer>(){

            @Override
            public boolean test(FLayer layer) {
                return layer instanceof SingleLayer && store == ((SingleLayer)layer).getDataStore();
            }
        });
        if (theLayers.isEmpty()) {
            return null;
        }
        return theLayers.get(0);
    }

    private List<FLayer> toPlainList(FLayer layer) {
        return this.toPlainList(layer, new ArrayList<FLayer>(), null);
    }

    private List<FLayer> toPlainList(FLayer layer, Predicate<FLayer> filter) {
        return this.toPlainList(layer, new ArrayList<FLayer>(), filter);
    }

    private List<FLayer> toPlainList(FLayer layer, List<FLayer> result, Predicate<FLayer> filter) {
        if (layer instanceof FLayers) {
            FLayers layerGroup = (FLayers)layer;
            if (filter == null || filter.test(layer)) {
                result.add(layer);
            }
            for (int i = 0; i < layerGroup.getLayersCount(); ++i) {
                this.toPlainList(layerGroup.getLayer(i), result, filter);
            }
        } else if (filter == null || filter.test(layer)) {
            result.add(layer);
        }
        return result;
    }

    @Override
    public int getLayersCount() {
        return this.layers.size();
    }

    @Override
    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        throw new RuntimeException("Esto no deberia de llamarse");
    }

    @Override
    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        throw new RuntimeException("No deberia pasar por aqui");
    }

    public void print_old(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        this.print_old(g, viewPort, cancel, scale, properties, null);
    }

    public ComposedLayer print_old(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties, ComposedLayer group) throws ReadException {
        double dpi = 72.0;
        int resolution = properties.getPrintQuality();
        switch (resolution) {
            case 1: {
                dpi = 300.0;
                break;
            }
            case 2: {
                dpi = 600.0;
                break;
            }
            case 0: {
                dpi = 72.0;
                break;
            }
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            FLayer lyr = this.layers.get(i);
            if (!lyr.isVisible() || !lyr.isWithinScale(scale)) continue;
            try {
                ILabelable lLayer;
                if (group != null) {
                    if (lyr instanceof FLayers) {
                        group = ((FLayers)lyr).print_old(g, viewPort, cancel, scale, properties, group);
                        continue;
                    }
                    if (lyr instanceof ILabelable && ((ILabelable)((Object)lyr)).isLabeled() && ((ILabelable)((Object)lyr)).getLabelingStrategy() != null && ((ILabelable)((Object)lyr)).getLabelingStrategy().shouldDrawLabels(scale)) {
                        group.add(lyr);
                        continue;
                    }
                    group.print(g, viewPort, cancel, scale, properties);
                    group = lyr instanceof ILabelable && ((ILabelable)((Object)lyr)).isLabeled() && ((ILabelable)((Object)lyr)).getLabelingStrategy() != null && ((ILabelable)((Object)lyr)).getLabelingStrategy().shouldDrawLabels(scale) ? lyr.newComposedLayer() : null;
                    if (group == null) {
                        if (lyr instanceof FLayers) {
                            group = ((FLayers)lyr).print_old(g, viewPort, cancel, scale, properties, group);
                            continue;
                        }
                        lyr.print(g, viewPort, cancel, scale, properties);
                        if (!(lyr instanceof ILabelable) || !((ILabelable)((Object)lyr)).isLabeled() || ((ILabelable)((Object)lyr)).getLabelingStrategy() == null || !((ILabelable)((Object)lyr)).getLabelingStrategy().shouldDrawLabels(scale)) continue;
                        lLayer = (ILabelable)((Object)lyr);
                        lLayer.drawLabels(null, g, viewPort, cancel, scale, dpi);
                        continue;
                    }
                    group.setMapContext(this.fmap);
                    group.add(lyr);
                    continue;
                }
                group = lyr.newComposedLayer();
                if (group == null) {
                    if (lyr instanceof FLayers) {
                        group = ((FLayers)lyr).print_old(g, viewPort, cancel, scale, properties, group);
                        continue;
                    }
                    lyr.print(g, viewPort, cancel, scale, properties);
                    if (!(lyr instanceof ILabelable) || !((ILabelable)((Object)lyr)).isLabeled()) continue;
                    lLayer = (ILabelable)((Object)lyr);
                    lLayer.drawLabels(null, g, viewPort, cancel, scale, dpi);
                    continue;
                }
                group.setMapContext(this.fmap);
                group.add(lyr);
                continue;
            }
            catch (Exception e) {
                String mesg = Messages.getString("error_printing_layer") + " " + lyr.getName() + ": " + e.getMessage();
                if (this.fmap != null) {
                    this.fmap.addLayerError(mesg);
                }
                LOGGER.error(mesg, (Throwable)e);
            }
        }
        if (group != null && this.getParentLayer() == null) {
            group.print(g, viewPort, cancel, scale, properties);
            group = null;
        }
        return group;
    }

    @Override
    public Envelope getFullEnvelope() {
        Envelope env = GeometryUtils.createEnvelope((int)0);
        for (FLayer capa : this.layers) {
            try {
                env.add(capa.getFullEnvelope());
            }
            catch (Exception e) {
                LOGGER.warn("Can't calculate the envelope of the layer group '" + this.getName() + "'.", (Throwable)e);
            }
        }
        return env;
    }

    protected void callLayerAdding(LayerCollectionEvent event) throws CancelationException {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerAdding(event);
        }
    }

    protected void callLayerRemoving(LayerCollectionEvent event) throws CancelationException {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerRemoving(event);
        }
    }

    protected void callLayerMoving(LayerPositionEvent event) throws CancelationException {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerMoving(event);
        }
    }

    protected void callLayerAdded(LayerCollectionEvent event) {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerAdded(event);
        }
    }

    protected void callLayerRemoved(LayerCollectionEvent event) {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerRemoved(event);
        }
    }

    protected void callLayerMoved(LayerPositionEvent event) {
        ArrayList aux = (ArrayList)this.layerCollectionListeners.clone();
        Iterator iter = aux.iterator();
        while (iter.hasNext()) {
            ((LayerCollectionListener)iter.next()).layerMoved(event);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("mapContext", (Persistent)this.fmap);
        ArrayList<FLayer> layersToSave = new ArrayList<FLayer>();
        for (FLayer layer : this.layers) {
            if (layer.isTemporary()) continue;
            layersToSave.add(layer);
        }
        state.set("layers", layersToSave);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        FLayer item;
        super.loadFromState(state);
        Iterator iter = state.getIterator("layers");
        while (iter.hasNext()) {
            item = (FLayer)iter.next();
            if (item == null) continue;
            if (item instanceof FLayers) {
                FLayers fLayers = (FLayers)item;
            }
            item.setParentLayer(this);
            this.layers.add(item);
        }
        this.setMapContext((MapContext)state.get("mapContext"));
        iter = state.getIterator("layers");
        while (iter.hasNext()) {
            item = (FLayer)iter.next();
            if (item == null || !(item instanceof FLayers)) continue;
            FLayers layersToAdd = (FLayers)item;
            if (this.fmap == null) continue;
            this.fmap.addAsCollectionListener(layersToAdd);
        }
    }

    @Override
    public MapContext getMapContext() {
        return this.fmap;
    }

    @Override
    public void setAllActives(boolean active) {
        for (int i = 0; i < this.layers.size(); ++i) {
            FLayer lyr = this.layers.get(i);
            lyr.setActive(active);
            if (!(lyr instanceof LayerCollection)) continue;
            ((LayerCollection)((Object)lyr)).setAllActives(active);
        }
    }

    @Override
    public List<FLayer> getLayers(Predicate<FLayer> filter) {
        List<FLayer> theLayers = this.toPlainList(this, filter);
        return theLayers;
    }

    @Override
    public FLayer[] getActives() {
        List<FLayer> activeLayers = this.getLayers(new Predicate<FLayer>(){

            @Override
            public boolean test(FLayer layer) {
                return layer.isActive();
            }
        });
        return activeLayers.toArray(new FLayer[activeLayers.size()]);
    }

    @Override
    public double getMinScale() {
        return -1.0;
    }

    @Override
    public double getMaxScale() {
        return -1.0;
    }

    @Override
    public void setMinScale(double minScale) {
        for (FLayer lyr : this.layers) {
            lyr.setMinScale(minScale);
        }
    }

    @Override
    public void setMaxScale(double maxScale) {
        for (FLayer lyr : this.layers) {
            lyr.setMinScale(maxScale);
        }
    }

    @Override
    public void setActive(boolean b) {
        super.setActive(b);
        for (FLayer layer : this.layers) {
            layer.setActive(b);
        }
    }

    public void setActive(boolean active, boolean applySublayers) {
        super.setActive(active);
        if (applySublayers) {
            for (FLayer layer : this.layers) {
                layer.setActive(active);
            }
        }
    }

    @Override
    public boolean addLayerListener(LayerListener o) {
        for (FLayer layer : this.layers) {
            layer.addLayerListener(o);
        }
        return true;
    }

    @Override
    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return this.getInfo(this.getMapContext().getViewPort().convertToMapPoint(p), tolerance);
    }

    @Override
    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        return this.getInfo(this.getMapContext().getViewPort().convertToMapPoint(p), tolerance);
    }

    @Override
    public DynObjectSet getInfo(Point p, double tolerance) throws LoadLayerException, DataException {
        ArrayList<DynObjectSet> res = new ArrayList<DynObjectSet>();
        for (int i = 0; i < this.layers.size(); ++i) {
            FLayer layer = this.layers.get(i);
            if (!(layer instanceof InfoByPoint)) continue;
            InfoByPoint queryable_layer = (InfoByPoint)((Object)layer);
            res.add(queryable_layer.getInfo(p, tolerance));
        }
        DynObjectSet[] innerSets = res.toArray(new DynObjectSet[res.size()]);
        return new MultiDynObjectSet(innerSets);
    }

    @Override
    public String getTocImageIcon() {
        return "layer-icon-group";
    }

    public void setMapContext(MapContext mapContext) {
        this.fmap = mapContext;
        for (FLayer lyr : this.layers) {
            if (!(lyr instanceof FLayers)) continue;
            ((FLayers)lyr).setMapContext(mapContext);
        }
    }

    public void accept(Visitor visitor) throws BaseException {
        for (int i = 0; i < this.getLayersCount(); ++i) {
            FLayer layer = this.getLayer(i);
            if (layer instanceof LayersVisitable) {
                ((LayersVisitable)((Object)layer)).accept(visitor);
                continue;
            }
            visitor.visit((Object)layer);
        }
    }

    @Override
    public void accept(LayersVisitor visitor) throws BaseException {
        for (int i = 0; i < this.getLayersCount(); ++i) {
            FLayer layer = this.getLayer(i);
            if (layer instanceof LayersVisitable) {
                ((LayersVisitable)((Object)layer)).accept(visitor);
                continue;
            }
            visitor.visit(layer);
        }
    }

    public Object getMetadataID() throws MetadataException {
        StringBuilder strb = new StringBuilder();
        strb.append("Layers(");
        strb.append(this.getName());
        strb.append("):{");
        Iterator<FLayer> iter = this.layers.iterator();
        while (iter.hasNext()) {
            strb.append(iter.next().getMetadataID());
            strb.append(",");
        }
        strb.append("}");
        return strb.toString();
    }

    public Set getMetadataChildren() {
        TreeSet<FLayer> ret = new TreeSet<FLayer>();
        Iterator<FLayer> iter = this.layers.iterator();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        return ret;
    }

    @Override
    public String getMetadataName() throws MetadataException {
        StringBuilder strb = new StringBuilder();
        strb.append("Layer Group '");
        strb.append(this.getName());
        strb.append("': {");
        Iterator<FLayer> iter = this.layers.iterator();
        while (iter.hasNext()) {
            strb.append(iter.next().getMetadataName());
            strb.append(",");
        }
        strb.append("}");
        return strb.toString();
    }

    @Override
    public void beginDraw(Graphics2D g, ViewPort viewPort) {
        if (this.fmap == null) {
            return;
        }
        LayerDrawEvent beforeEvent = new LayerDrawEvent(this, g, viewPort, 101);
        this.fmap.fireLayerDrawingEvent(beforeEvent);
    }

    @Override
    public void endDraw(Graphics2D g, ViewPort viewPort) {
        if (this.fmap == null) {
            return;
        }
        LayerDrawEvent afterEvent = new LayerDrawEvent(this, g, viewPort, 102);
        this.fmap.fireLayerDrawingEvent(afterEvent);
    }

    protected void doDispose() throws BaseException {
        if (this.layers != null) {
            for (FLayer layer : this.layers) {
                this.dispose(layer);
            }
        }
    }

    @Override
    public void move(FLayer layer, LayerCollection group, int where, FLayer adjoiningLayer) throws LayerNotFoundInCollectionException {
        this.callLayerRemoving(LayerCollectionEvent.createLayerRemovingEvent(layer));
        group.addLayer(layer, where, adjoiningLayer);
        this.removeLayer(layer);
        this.updateDrawVersion();
        this.callLayerRemoved(LayerCollectionEvent.createLayerRemovedEvent(layer));
    }

    public void join(FLayer layer, LayerCollection group) {
        try {
            this.layers.remove(layer);
            group.addLayer(layer, 1, null);
            this.updateDrawVersion();
        }
        catch (LayerNotFoundInCollectionException e) {
            throw new MapContextRuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public void move(FLayer layer, LayerCollection group) {
        try {
            this.move(layer, group, 1, null);
        }
        catch (LayerNotFoundInCollectionException e) {
            throw new MapContextRuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public void addLayer(FLayer layer, int where, FLayer adjoiningLayer) throws LayerNotFoundInCollectionException {
        block0 : switch (where) {
            case 0: {
                this.addLayer(0, layer);
                break;
            }
            case 2: {
                if (adjoiningLayer != null) {
                    if (this.layers.contains(adjoiningLayer)) {
                        for (int i = 0; i < this.getLayersCount(); ++i) {
                            if (adjoiningLayer != this.getLayer(i)) continue;
                            this.addLayer(i, layer);
                            break block0;
                        }
                        break;
                    }
                    throw new LayerNotFoundInCollectionException(adjoiningLayer, this);
                }
                this.addLayer(0, layer);
                break;
            }
            case 3: {
                if (adjoiningLayer != null) {
                    if (this.layers.contains(adjoiningLayer)) {
                        for (int i = 0; i < this.getLayersCount(); ++i) {
                            if (adjoiningLayer != this.getLayer(i)) continue;
                            this.addLayer(i + 1, layer);
                            break block0;
                        }
                        break;
                    }
                    throw new LayerNotFoundInCollectionException(adjoiningLayer, this);
                }
                this.addLayer(layer);
                break;
            }
            default: {
                this.addLayer(layer);
            }
        }
    }

    public FLayer getFirstActiveLayer() {
        List<FLayer> theLayers = this.getLayers(LAYER_ACTIVE);
        if (theLayers.isEmpty()) {
            return null;
        }
        return theLayers.get(0);
    }

    public FLyrVect getFirstActiveVectorLayer() {
        List<FLayer> theLayers = this.getLayers(LAYER_ACTIVE.and(LAYER_FLYRVECT));
        if (theLayers.isEmpty()) {
            return null;
        }
        return (FLyrVect)theLayers.get(0);
    }

    @Override
    public Iterator<FLayer> iterator() {
        return this.layers.iterator();
    }

    public Iterator<FLayer> deepiterator() {
        List<FLayer> theLayers = this.toPlainList(this);
        return theLayers.iterator();
    }

    public Iterable<FLayer> deepiterable() {
        return () -> this.deepiterator();
    }

    @Override
    public int size() {
        return this.layers.size();
    }

    @Override
    public FLayer get(int index) {
        return this.layers.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.layers.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.layers.toArray();
    }

    @Override
    public Object[] toArray(Object[] ts) {
        return this.layers.toArray(ts);
    }

    @Override
    public boolean add(FLayer e) {
        this.addLayer(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.removeLayer((FLayer)o);
        return true;
    }

    @Override
    public boolean containsAll(Collection clctn) {
        return this.layers.containsAll(clctn);
    }

    @Override
    public void add(int i, FLayer e) {
        this.addLayer(i, e);
    }

    @Override
    public FLayer remove(int i) {
        FLayer o = this.getLayer(i);
        this.removeLayer(i);
        return o;
    }

    @Override
    public int indexOf(Object o) {
        return this.layers.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.layers.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        return this.layers.listIterator();
    }

    @Override
    public ListIterator listIterator(int i) {
        return this.layers.listIterator(i);
    }

    @Override
    public List subList(int i, int i1) {
        return this.layers.subList(i, i1);
    }

    @Override
    public boolean addAll(Collection clctn) {
        Iterator it = clctn.iterator();
        while (it.hasNext()) {
            this.add((FLayer)it.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection clctn) {
        Iterator it = clctn.iterator();
        while (it.hasNext()) {
            this.add(i, (FLayer)it.next());
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection clctn) {
        Iterator it = clctn.iterator();
        while (it.hasNext()) {
            this.remove((FLayer)it.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection clctn) {
        for (FLayer o : this.layers) {
            if (clctn.contains(o)) continue;
            this.remove(o);
        }
        return true;
    }

    @Override
    public FLayer set(int i, FLayer e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FLayers createFLayerGroup(String name) {
        FLayers group = new FLayers();
        group.setMapContext(this.getMapContext());
        group.setParentLayer(this);
        group.setName(name);
        return group;
    }

    @Override
    public FLayers cloneLayer() throws Exception {
        FLayers cloned = new FLayers();
        cloned.fmap = this.fmap;
        for (FLayer layer : this.layers) {
            FLayer l = layer.cloneLayer();
            l.setParentLayer(cloned);
            cloned.add(l);
        }
        for (LayerCollectionListener layerCollectionListener : this.layerCollectionListeners) {
            cloned.addLayerCollectionListener(layerCollectionListener);
        }
        for (LayerListener layerListener : this.layerListeners) {
            cloned.addLayerListener(layerListener);
        }
        cloned.setTransparency(this.getTransparency());
        cloned.setMaxScale(this.getMaxScale());
        cloned.setMinScale(this.getMinScale());
        cloned.setCoordTrans(this.getCoordTrans());
        cloned.setFLayerStatus(this.getFLayerStatus());
        cloned.setTemporary(this.isTemporary());
        cloned.setTocStatusImage(this.getTocStatusImage());
        cloned.metadataContainer = this.metadataContainer;
        cloned.setParentLayer(this.getParentLayer());
        cloned.properties = this.properties;
        return cloned;
    }

    @Override
    public void clear() {
        super.clear();
    }

    public void clearMetadata() {
        super.clear();
    }

    public void clearLayers() {
        this.layers.clear();
        this.updateDrawVersion();
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(FLayers.class, "FLayers", "FLayers Persistence definition", null, null);
            definition.extend("Persistence", "FLyrDefault");
            definition.addDynFieldObject("mapContext").setClassOfValue(MapContext.class).setMandatory(true);
            definition.addDynFieldList("layers").setClassOfItems(FLayer.class).setMandatory(true);
            return Boolean.TRUE;
        }
    }
}

