/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.ReloadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.StartEditionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerInformationBuilder;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.SelectionEvent;
import org.gvsig.fmap.mapcontext.layers.SelectionListener;
import org.gvsig.fmap.mapcontext.layers.SpatialCache;
import org.gvsig.fmap.mapcontext.layers.vectorial.IntersectsTimeEvaluator;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.LegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.events.FeatureDrawnNotification;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLyrVect
extends FLyrDefault
implements VectorLayer,
LegendContentsChangedListener,
Observer {
    public static final String TAG_LAYERVECT_MAXSCALE = "layervect.scale.max";
    public static final String TAG_LAYERVECT_MINSCALE = "layervect.scale.min";
    private static final Logger logger = LoggerFactory.getLogger(FLyrVect.class);
    private final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private IVectorLegend legend;
    private int typeShape = -1;
    private FeatureStore featureStore = null;
    private DataStoreParameters dataStoreParameters;
    private SpatialCache spatialCache = new SpatialCache();
    private IVectorLegend loadLegend = null;
    private boolean isLabeled;
    protected ILabelingStrategy strategy;
    private FeatureQuery baseQuery = null;

    @Override
    public String getTocImageIcon() {
        if (this.featureStore == null && this.dataStoreParameters != null) {
            return MapContextLocator.getMapContextManager().getIconLayer(this.dataStoreParameters.getProviderName());
        }
        return MapContextLocator.getMapContextManager().getIconLayer(this.getDataStore());
    }

    @Override
    public DataStore getDataStore() {
        return this.featureStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.bindToDataStore(dataStore);
    }

    public void setDataStoreParameters(DataStoreParameters parameters) {
        this.dataStoreParameters = parameters;
    }

    @Override
    public void setVisible(boolean visibility) {
        if (visibility && this.featureStore == null && this.dataStoreParameters != null) {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                DataStore dataStore = dataManager.openStore(this.dataStoreParameters.getProviderName(), this.dataStoreParameters);
                this.bindToDataStore(dataStore);
                IProjection projection = (IProjection)dataStore.getDynValue("CRS");
                if (projection != null) {
                    this.setProjection(projection);
                }
                if (projection != null && this.getMapContext() != null) {
                    IProjection mapContextProj = this.getMapContext().getProjection();
                    if (!projection.getAbrev().equals(mapContextProj.getAbrev())) {
                        ICoordTrans ct = projection.getCT(mapContextProj);
                        this.setCoordTrans(ct);
                    } else {
                        this.setCoordTrans(null);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't set visibility to layer", ex);
            }
        }
        super.setVisible(visibility);
    }

    protected void bindToDataStore(DataStore dataStore) throws LoadLayerException {
        MapContextManager mapContextManager;
        IVectorLegend legend;
        if (this.featureStore != null && this.featureStore != dataStore) {
            this.featureStore.deleteObserver((Observer)this);
        }
        this.featureStore = (FeatureStore)dataStore;
        if (this.dataStoreParameters == null) {
            this.dataStoreParameters = this.featureStore.getParameters();
        }
        if ((legend = (IVectorLegend)(mapContextManager = MapContextLocator.getMapContextManager()).getLegend(dataStore)) == null) {
            throw new LegendLayerException(this.getName());
        }
        this.setLegend(legend);
        ILabelingStrategy labeler = mapContextManager.getLabelingStrategy(dataStore);
        if (labeler != null) {
            labeler.setLayer(this);
            this.setLabelingStrategy(labeler);
            this.setIsLabeled(true);
        }
        this.delegate((DynObject)dataStore);
        dataStore.addObserver((Observer)this);
        FeatureType featureType = this.featureStore.getDefaultFeatureTypeQuietly();
        if (featureType != null) {
            Tags tags = featureType.getTags();
            if (tags.has(TAG_LAYERVECT_MAXSCALE)) {
                this.setMaxScale(tags.getInt(TAG_LAYERVECT_MAXSCALE, -1));
            }
            if (tags.has(TAG_LAYERVECT_MINSCALE)) {
                this.setMinScale(tags.getInt(TAG_LAYERVECT_MINSCALE, -1));
            }
        }
        ToolsLocator.getDisposableManager().bind((Disposable)dataStore);
    }

    @Override
    public Envelope getFullEnvelope() throws ReadException {
        Envelope rAux;
        if (this.getFeatureStore() == null) {
            return null;
        }
        try {
            rAux = this.getFeatureStore().getEnvelope();
        }
        catch (BaseException e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
        if (rAux == null || rAux.isEmpty()) {
            return rAux;
        }
        ICoordTrans ct = this.getCoordTrans();
        if (ct != null && ((rAux = rAux.convert(ct)) == null || rAux.isEmpty())) {
            try {
                this.setAvailable(false);
                throw new EnvelopeCantBeInitializedException();
            }
            catch (EnvelopeCantBeInitializedException e) {
                this.addError((Throwable)((Object)e));
            }
        }
        return rAux;
    }

    @Override
    public void setBaseQuery(FeatureQuery baseQuery) {
        this.baseQuery = baseQuery;
    }

    @Override
    public FeatureQuery getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    public void addBaseFilter(Evaluator filter) {
        if (this.baseQuery == null) {
            this.baseQuery = this.getFeatureStore().createFeatureQuery();
        }
        this.baseQuery.addFilter(filter);
    }

    @Override
    public void addBaseFilter(String filter) {
        try {
            this.addBaseFilter(DALLocator.getDataManager().createExpresion(filter));
        }
        catch (InitializeException ex) {
            throw new RuntimeException("Can't create filter with '" + filter + "'", ex);
        }
    }

    @Override
    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        if (this.legend == null) {
            return;
        }
        if (!this.isWithinScale(scale)) {
            return;
        }
        if (cancel.isCanceled()) {
            return;
        }
        if (this.spatialCache.isEnabled()) {
            this.spatialCache.removeAll();
            this.legend.addDrawingObserver(this);
        }
        FeatureQuery featureQuery = this.createFeatureQuery();
        try {
            FeatureAttributeDescriptor featureAttributeDescriptor = this.getFeatureStore().getDefaultFeatureType().getDefaultTimeAttribute();
            if (viewPort.getTime() != null && featureAttributeDescriptor != null) {
                IntersectsTimeEvaluator intersectsTimeEvaluator = new IntersectsTimeEvaluator(viewPort.getTime(), featureAttributeDescriptor.getName());
                featureQuery.addFilter((Evaluator)intersectsTimeEvaluator);
            }
        }
        catch (DataException e1) {
            logger.error("Impossible to get the temporal filter", (Throwable)e1);
        }
        try {
            long tini = System.currentTimeMillis();
            this.legend.draw(image, g, viewPort, cancel, scale, null, this.getCoordTrans(), this.getFeatureStore(), featureQuery);
            logger.debug("Layer " + this.getName() + " drawn in " + (System.currentTimeMillis() - tini) + " ms (" + this.getFeatureStore().getFullName() + ").");
        }
        catch (LegendException e) {
            this.setAvailable(false);
            this.setError((Throwable)((Object)e));
            throw new ReadException(this.getName(), (Throwable)((Object)e));
        }
        finally {
            if (this.spatialCache.isEnabled()) {
                this.legend.deleteDrawingObserver(this);
            }
        }
    }

    @Override
    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        if (!this.isWithinScale(scale)) {
            return;
        }
        if (cancel.isCanceled()) {
            return;
        }
        FeatureQuery featureQuery = this.createFeatureQuery();
        try {
            this.legend.print(g, viewPort, cancel, scale, null, this.getCoordTrans(), this.getFeatureStore(), featureQuery, properties);
        }
        catch (LegendException e) {
            this.setVisible(false);
            this.setActive(false);
            throw new ReadException(this.getName(), (Throwable)((Object)e));
        }
    }

    @Override
    public void setLegend(IVectorLegend legend) throws LegendLayerException {
        if (this.legend == legend) {
            return;
        }
        if (this.legend != null && this.legend.equals(legend)) {
            return;
        }
        IVectorLegend oldLegend = this.legend;
        this.legend = legend;
        if (oldLegend != null) {
            oldLegend.removeLegendListener(this);
            oldLegend.deleteDrawingObserver(this);
        }
        if (legend != null) {
            this.legend.addDrawingObserver(this);
            this.legend.addLegendListener(this);
        }
        LegendChangedEvent e = LegendChangedEvent.createLegendChangedEvent((ILegend)oldLegend, this.legend);
        e.setLayer(this);
        this.updateDrawVersion();
        this.callLegendChanged(e);
    }

    @Override
    public ILegend getLegend() {
        return this.legend;
    }

    @Override
    public int getShapeType() throws ReadException {
        if (this.typeShape == -1) {
            FeatureType featureType = null;
            try {
                if (this.getDataStore() != null) {
                    featureType = ((FeatureStore)this.getDataStore()).getDefaultFeatureType();
                }
            }
            catch (DataException e) {
                throw new ReadException(this.getName(), (Throwable)e);
            }
            if (featureType != null) {
                int indexGeom = featureType.getDefaultGeometryAttributeIndex();
                this.typeShape = featureType.getAttributeDescriptor(indexGeom).getGeometryType();
            }
        }
        return this.typeShape;
    }

    @Override
    public GeometryType getGeometryType() throws ReadException {
        FeatureType featureType = null;
        try {
            if (this.getDataStore() != null) {
                featureType = ((FeatureStore)this.getDataStore()).getDefaultFeatureType();
            }
        }
        catch (DataException e) {
            throw new ReadException(this.getName(), (Throwable)e);
        }
        return featureType == null ? null : featureType.getDefaultGeometryAttribute().getGeomType();
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        FeatureStore featureStore = null;
        if (!this.isAvailable()) {
            logger.info("The '" + this.getName() + "' layer is not available, it will persist not.");
            return;
        }
        try {
            super.saveToState(state);
            if (this.getLegend() != null) {
                state.set("legend", (Persistent)this.getLegend());
            }
            if ((featureStore = this.getFeatureStore()) != null) {
                state.set("featureStore", (Persistent)featureStore);
            }
            if (this.dataStoreParameters != null) {
                state.set("featureStoreParameters", (Persistent)this.dataStoreParameters);
            }
            state.set("isLabeled", this.isLabeled);
            if (this.strategy != null) {
                state.set("labelingStrategy", (Persistent)this.strategy);
            }
            if (this.getLinkProperties() != null) {
                state.set("linkProperties", (Persistent)this.getLinkProperties());
            }
            state.set("typeShape", this.typeShape);
        }
        catch (PersistenceException ex) {
            logger.warn("Can't persist to state the layer '" + this.getName() + "'.", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.warn("Can't persist to state the layer '" + this.getName() + "'.", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        FeatureStore store = null;
        try {
            super.loadFromState(state);
            this.setIsLabeled(false);
            this.setLabelingStrategy(null);
            this.typeShape = state.getInt("typeShape", 0);
            this.dataStoreParameters = (DataStoreParameters)state.get("featureStoreParameters");
            store = (FeatureStore)state.get("featureStore");
            if (store == null) {
                if (this.dataStoreParameters == null) {
                    this.setAvailable(false);
                    this.addError(new RuntimeException("Can't retrieve store information."));
                } else if (this.isVisible()) {
                    try {
                        DataManager dataManager = DALLocator.getDataManager();
                        store = (FeatureStore)dataManager.openStore(this.dataStoreParameters.getProviderName(), this.dataStoreParameters);
                        this.bindToDataStore((DataStore)store);
                    }
                    catch (Exception ex) {
                        this.setAvailable(false);
                        this.addError(ex);
                    }
                }
            } else {
                if (store.isBroken()) {
                    this.setAvailable(false);
                    this.addError(store.getBreakingsCause());
                }
                try {
                    this.bindToDataStore((DataStore)store);
                }
                catch (Exception ex) {
                    this.setAvailable(false);
                    this.addError(ex);
                }
            }
            try {
                IVectorLegend vectorLegend = (IVectorLegend)state.get("legend");
                if (vectorLegend != null) {
                    this.setLegend(vectorLegend);
                }
            }
            catch (Exception ex) {
                this.setAvailable(false);
                this.addError(ex);
            }
            try {
                if (state.getBoolean("isLabeled", false)) {
                    this.setIsLabeled(true);
                    ILabelingStrategy labelingStrategy = (ILabelingStrategy)state.get("labelingStrategy");
                    this.setLabelingStrategy(labelingStrategy);
                }
            }
            catch (Exception ex) {
                this.setAvailable(false);
                this.addError(ex);
            }
            MapContext mc = this.getMapContext();
            if (mc != null) {
                mc.addSelectionListener(this);
            }
        }
        catch (Throwable e) {
            String storeName = store == null ? "unknow" : store.getFullName();
            logger.warn("can't load layer '" + this.getName() + "' (store=" + storeName + ") from persisted state.", e);
            this.setAvailable(false);
            this.addError(e);
        }
    }

    @Override
    public String toString() {
        String ret = super.toString();
        return ret;
    }

    @Override
    public boolean isEditing() {
        FeatureStore fs = this.getFeatureStore();
        if (fs == null) {
            return false;
        }
        return fs.isEditing();
    }

    @Override
    public void setEditing(boolean b) throws StartEditionLayerException {
        try {
            throw new RuntimeException();
        }
        catch (Throwable th) {
            logger.info("This method is deprecated. ", th);
            if (b == super.isEditing()) {
                return;
            }
            super.setEditing(b);
            FeatureStore fs = this.getFeatureStore();
            if (b) {
                try {
                    fs.edit();
                }
                catch (DataException e) {
                    throw new StartEditionLayerException(this.getName(), e);
                }
            }
            this.getSpatialCache().setEnabled("editing", b);
            this.callEditionChanged(LayerEvent.createEditionChangedEvent(this, "edition"));
            return;
        }
    }

    public void clearSpatialCache() {
        this.spatialCache.removeAll();
    }

    public boolean isSpatialCacheEnabled() {
        return this.spatialCache.isEnabled();
    }

    public void setSpatialCacheEnabled(boolean spatialCacheEnabled) {
        this.spatialCache.setEnabled(spatialCacheEnabled);
    }

    public SpatialCache getSpatialCache() {
        return this.spatialCache;
    }

    public void refreshSpatialCache(Envelope envelope) {
        if (this.featureStore == null) {
            return;
        }
        SpatialCache sc = this.getSpatialCache();
        sc.refresh(this.getName(), this.getFeatureStore(), envelope, this.getProjection());
    }

    public void setMaxFeaturesInEditionCache(int maxFeatures) {
        if (maxFeatures > this.spatialCache.getMaxFeatures()) {
            this.spatialCache.setMaxFeatures(maxFeatures);
        }
    }

    public boolean isPropertiesMenuVisible() {
        return true;
    }

    @Override
    public void reload() throws ReloadLayerException {
        super.reload();
        try {
            this.getFeatureStore().refresh();
        }
        catch (Exception e) {
            throw new ReloadLayerException(this.getName(), e);
        }
    }

    protected void setLoadSelection(Object xml) {
    }

    protected void setLoadLegend(IVectorLegend legend) {
        this.loadLegend = legend;
    }

    protected void putLoadSelection() {
    }

    protected void putLoadLegend() throws LegendLayerException {
        if (this.loadLegend == null) {
            return;
        }
        this.setLegend(this.loadLegend);
        this.loadLegend = null;
    }

    protected void cleanLoadOptions() {
        this.loadLegend = null;
    }

    @Override
    public boolean isWritable() {
        return this.getFeatureStore().allowWrite();
    }

    @Override
    public FLayer cloneLayer() throws Exception {
        FLyrVect clonedLayer = new FLyrVect();
        if (this.dataStoreParameters != null) {
            clonedLayer.dataStoreParameters = (DataStoreParameters)this.dataStoreParameters.getCopy();
        }
        if (this.featureStore != null) {
            clonedLayer.featureStore = this.featureStore;
            ToolsLocator.getDisposableManager().bind((Disposable)clonedLayer.featureStore);
            clonedLayer.delegate((DynObject)clonedLayer.featureStore);
            clonedLayer.featureStore.addObserver((Observer)clonedLayer);
        }
        clonedLayer.setVisible(this.isVisible());
        clonedLayer.setName(this.getName());
        clonedLayer.setCoordTrans(this.getCoordTrans());
        if (this.getLegend() != null) {
            clonedLayer.setLegend((IVectorLegend)this.getLegend().cloneLegend());
        }
        clonedLayer.setIsLabeled(this.isLabeled());
        ILabelingStrategy labelingStrategy = this.getLabelingStrategy();
        if (labelingStrategy != null) {
            clonedLayer.setLabelingStrategy(labelingStrategy);
        }
        clonedLayer.setMaxScale(this.getMaxScale());
        clonedLayer.setMinScale(this.getMinScale());
        return clonedLayer;
    }

    @Override
    public boolean isLabeled() {
        return this.isLabeled;
    }

    @Override
    public void setIsLabeled(boolean isLabeled) {
        this.isLabeled = isLabeled;
    }

    @Override
    public ILabelingStrategy getLabelingStrategy() {
        return this.strategy;
    }

    @Override
    public void setLabelingStrategy(ILabelingStrategy strategy) {
        this.strategy = strategy;
        if (strategy == null) {
            return;
        }
        strategy.setLayer(this);
        this.updateDrawVersion();
    }

    @Override
    public void drawLabels(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, double dpi) throws ReadException {
        if (this.strategy != null && this.isWithinScale(scale)) {
            this.strategy.draw(image, g, scale, viewPort, cancel, dpi);
        }
    }

    @Override
    public void printLabels(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes properties) throws ReadException {
        if (this.strategy != null) {
            this.strategy.print(g, scale, viewPort, cancel, properties);
        }
    }

    @Override
    public boolean allowLinks() {
        return false;
    }

    @Override
    public void load() throws LoadLayerException {
        super.load();
    }

    @Override
    public FeatureStore getFeatureStore() {
        return (FeatureStore)this.getDataStore();
    }

    @Override
    public FeatureQuery createFeatureQuery() {
        if (this.baseQuery == null) {
            return this.getFeatureStore().createFeatureQuery();
        }
        try {
            return (FeatureQuery)this.baseQuery.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public FeatureSet queryByPoint(Point2D mapPoint, double tol, FeatureType featureType) throws DataException {
        logger.warn("Deprecated use of queryByPoint.");
        GeometryManager manager = GeometryLocator.getGeometryManager();
        try {
            Point center = (Point)manager.create(1, 0);
            center.setX(mapPoint.getX());
            center.setY(mapPoint.getY());
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints(center, tol);
            return this.queryByGeometry((Geometry)circle, featureType);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new CreateGeometryException(11, 0, (Throwable)e);
        }
    }

    public FeatureSet queryByPoint(Point point, double tol, FeatureType featureType) throws DataException {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        try {
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints(point, tol);
            return this.queryByGeometry((Geometry)circle, featureType);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new CreateGeometryException(11, 0, (Throwable)e);
        }
    }

    public FeatureQuery createQueryByPoint(double x, double y, double tol, FeatureType featureType) throws DataException {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        try {
            Point center = (Point)manager.create(1, 0);
            center.setX(x);
            center.setY(y);
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints(center, tol);
            return this.createQueryByGeometry((Geometry)circle, featureType);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new CreateGeometryException(11, 0, (Throwable)e);
        }
    }

    public FeatureSet queryByGeometry(Geometry geom, FeatureType featureType) throws DataException {
        FeatureQuery featureQuery = this.createFeatureQuery();
        featureQuery.setFeatureType(featureType);
        Geometry query_geo = this.transformToSourceCRS(geom, true);
        IProjection query_proj = this.getMapContext().getProjection();
        if (this.getCoordTrans() != null) {
            query_proj = this.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo, query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        featureQuery.setAttributeNames(null);
        return this.getFeatureStore().getFeatureSet(featureQuery);
    }

    public FeatureQuery createQueryByGeometry(Geometry geom, FeatureType featureType) throws DataException {
        FeatureQuery featureQuery = this.createFeatureQuery();
        featureQuery.setFeatureType(featureType);
        Geometry query_geo = this.transformToSourceCRS(geom, true);
        IProjection query_proj = this.getMapContext().getProjection();
        if (this.getCoordTrans() != null) {
            query_proj = this.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo, query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        featureQuery.setAttributeNames(null);
        return featureQuery;
    }

    public FeatureSet queryByContainedInGeometry(Geometry geom, FeatureType featureType) throws DataException {
        FeatureQuery featureQuery = this.createFeatureQuery();
        featureQuery.setFeatureType(featureType);
        Geometry query_geo = this.transformToSourceCRS(geom, true);
        IProjection query_proj = this.getMapContext().getProjection();
        if (this.getCoordTrans() != null) {
            query_proj = this.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().contains(query_geo, query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        featureQuery.setAttributeNames(null);
        return this.getFeatureStore().getFeatureSet(featureQuery);
    }

    public FeatureSet queryByEnvelope(Envelope envelope, FeatureType featureType) throws DataException {
        return this.queryByEnvelope(envelope, featureType, null);
    }

    public FeatureSet queryByEnvelope(Envelope envelope, FeatureType featureType, String[] names) throws DataException {
        FeatureQuery featureQuery = this.createFeatureQuery();
        if (names == null) {
            featureQuery.setFeatureType(featureType);
        } else {
            featureQuery.setAttributeNames(names);
            featureQuery.setFeatureTypeId(featureType.getId());
        }
        Envelope query_env = FLyrVect.fromViewPortCRSToSourceCRS(this, envelope);
        IProjection query_proj = this.getMapContext().getProjection();
        if (this.getCoordTrans() != null) {
            query_proj = this.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_env.getGeometry(), query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        return this.getFeatureStore().getFeatureSet(featureQuery);
    }

    public FeatureSet queryByContainedInEnvelope(Envelope envelope, FeatureType featureType) throws DataException {
        return this.queryByContainedInEnvelope(envelope, featureType, null);
    }

    public FeatureSet queryByContainedInEnvelope(Envelope envelope, FeatureType featureType, String[] names) throws DataException {
        FeatureQuery featureQuery = this.createFeatureQuery();
        if (names == null) {
            featureQuery.setFeatureType(featureType);
        } else {
            featureQuery.setAttributeNames(names);
            featureQuery.setFeatureTypeId(featureType.getId());
        }
        Envelope query_env = FLyrVect.fromViewPortCRSToSourceCRS(this, envelope);
        IProjection query_proj = this.getMapContext().getProjection();
        if (this.getCoordTrans() != null) {
            query_proj = this.getCoordTrans().getPOrig();
        }
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().contains(query_env.getGeometry(), query_proj, this.featureStore);
        featureQuery.setFilter(iee);
        return this.getFeatureStore().getFeatureSet(featureQuery);
    }

    @Override
    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return this.getInfo(p, tolerance, cancel, true);
    }

    @Override
    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        Point2D.Double infop = new Point2D.Double(p.x, p.y);
        Point2D pReal = this.getMapContext().getViewPort().toMapPoint(infop);
        return this.queryByPoint(pReal, tolerance, this.getFeatureStore().getDefaultFeatureType()).getDynObjectSet(fast);
    }

    @Override
    public DynObjectSet getInfo(Point p, double tolerance) throws LoadLayerException, DataException {
        return this.queryByPoint(p, tolerance, this.getFeatureStore().getDefaultFeatureType()).getDynObjectSet(false);
    }

    @Override
    public void legendCleared(LegendClearEvent event) {
        this.updateDrawVersion();
        LegendChangedEvent e = LegendChangedEvent.createLegendChangedEvent((ILegend)this.legend, event);
        this.callLegendChanged(e);
    }

    @Override
    public boolean symbolChanged(SymbolLegendEvent e) {
        this.updateDrawVersion();
        LegendChangedEvent ev = LegendChangedEvent.createLegendChangedEvent((ILegend)this.legend, e);
        this.callLegendChanged(ev);
        return true;
    }

    public void update(Observable observable, Object notification) {
        if (observable.equals(this.featureStore)) {
            if (notification instanceof FeatureStoreNotification) {
                FeatureStoreNotification event = (FeatureStoreNotification)notification;
                if (event.getType() == "after_Delete_Feature" || event.getType() == "after_Undo_DataStore" || event.getType() == "after_Redo_DataStore" || event.getType() == "after_refresh" || event.getType() == "after_Update_Feature" || event.getType() == "after_Update_Type" || event.getType() == "after_Insert_Feature") {
                    this.updateDrawVersion();
                } else if (event.getType() == "after_CancelEditing_DataStore") {
                    this.getSpatialCache().setEnabled("editing", false);
                    this.callEditionChanged(LayerEvent.createEditionChangedEvent(this, "edition"));
                    this.updateDrawVersion();
                } else if (event.getType() == "after_StartEditing_DataStore") {
                    this.getSpatialCache().setEnabled("editing", true);
                    this.callEditionChanged(LayerEvent.createEditionChangedEvent(this, "edition"));
                } else if (event.getType() == "Transform_Change") {
                    try {
                        this.reload();
                    }
                    catch (ReloadLayerException e) {
                        logger.info("While reloading layer.", (Throwable)((Object)e));
                        this.setAvailable(false);
                    }
                } else if (event.getType() == "resourceChange_DataStore") {
                    this.setAvailable(false);
                } else if (event.getType() == "after_FinishEditing_DataStore") {
                    this.setAvailable(true);
                    this.getSpatialCache().setEnabled("editing", false);
                    this.callEditionChanged(LayerEvent.createEditionChangedEvent(this, "edition"));
                    this.updateDrawVersion();
                } else if (event.getType() == "after_SelectionChange_DataStore") {
                    this.callSelectionChanged();
                }
            }
        } else if (notification instanceof FeatureDrawnNotification && this.spatialCache.isEnabled()) {
            Geometry geometry = ((FeatureDrawnNotification)notification).getDrawnGeometry();
            this.spatialCache.insert(geometry.getEnvelope(), geometry);
        }
    }

    public void setLayerToSnap(boolean enable) {
        MapContext mapContext = this.getMapContext();
        Set<FLyrVect> layers = mapContext.getLayersToSnap();
        if (enable) {
            layers.add(this);
        } else {
            layers.remove(this);
        }
        mapContext.setLayersToSnap(layers);
        this.getSpatialCache().setEnabled(enable);
    }

    public boolean isLayerToSnap() {
        MapContext mapContext = this.getMapContext();
        if (mapContext == null) {
            return false;
        }
        return mapContext.getLayersToSnap().contains(this);
    }

    public Set getMetadataChildren() {
        TreeSet<FeatureStore> ret = new TreeSet<FeatureStore>();
        ret.add(this.featureStore);
        return ret;
    }

    public Object getMetadataID() throws MetadataException {
        return "Layer(" + this.getName() + "):" + this.featureStore.getMetadataID();
    }

    public GeometryType getTypeVectorLayer() throws DataException, LocatorException, GeometryTypeNotSupportedException, GeometryTypeNotValidException {
        FeatureStore fs = this.getFeatureStore();
        FeatureType fType = fs.getDefaultFeatureType();
        FeatureAttributeDescriptor attr = fType.getAttributeDescriptor(fType.getDefaultGeometryAttributeIndex());
        GeometryType geomType = attr.getGeomType();
        return geomType;
    }

    protected void doDispose() throws BaseException {
        this.dispose((Disposable)this.featureStore);
        this.spatialCache.removeAll();
    }

    public static Envelope fromViewPortCRSToSourceCRS(FLayer lyr, Envelope env) {
        if (lyr == null || env == null) {
            return null;
        }
        ICoordTrans ct = lyr.getCoordTrans();
        if (ct == null) {
            return env;
        }
        return env.convert(ct.getInverted());
    }

    public Geometry transformToSourceCRS(Geometry geom, boolean clone) {
        return FLyrVect.fromViewPortCRSToSourceCRS(this, geom, clone);
    }

    public static Geometry fromViewPortCRSToSourceCRS(FLayer lyr, Geometry geo, boolean clone) {
        if (lyr == null || geo == null) {
            return null;
        }
        ICoordTrans ct = lyr.getCoordTrans();
        Geometry resp = geo;
        if (clone) {
            resp = resp.cloneGeometry();
        }
        if (ct != null) {
            resp.reProject(ct.getInverted());
        }
        return resp;
    }

    public Iterator iterator() {
        return this.getFeatureStore().iterator();
    }

    @Override
    public String getInfoString() {
        File f;
        LayerInformationBuilder builder = MapContextLocator.getMapContextManager().createLayerInformationBuilder();
        if (!this.isAvailable()) {
            builder.title().labelkey("Warning");
            builder.text().value("The layer is not available.", new Object[0]);
        }
        Envelope env = null;
        FeatureAttributeDescriptor attrgeom = null;
        try {
            env = this.getFullEnvelope();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FeatureStore store = this.getFeatureStore();
        try {
            FeatureType ft = store.getDefaultFeatureType();
            attrgeom = ft.getDefaultGeometryAttribute();
        }
        catch (Exception ft) {
            // empty catch block
        }
        builder.title().labelkey("Data_source");
        builder.property().labelkey("Source_type").value(this.getProviderName(), new Object[0]);
        builder.property().labelkey("origen").value(store == null ? "not available" : store.getFullName(), new Object[0]);
        if (this.getDataStoreParameters() instanceof FilesystemStoreParameters && (f = ((FilesystemStoreParameters)this.getDataStoreParameters()).getFile()) != null && f.exists()) {
            builder.property().labelkey("_Size").value("%d bytes", f.length());
        }
        if (attrgeom != null) {
            builder.property().labelkey("_Geometry_column").value(attrgeom.getName(), new Object[0]);
            builder.property().labelkey("_Geometry_type").value(attrgeom.getGeomType().getFullName(), new Object[0]);
        }
        builder.title().labelkey("_Coordenadas_geograficas");
        if (this.isAvailable()) {
            builder.envelope().value(env);
        }
        builder.title().labelkey("_Projection");
        if (this.isAvailable()) {
            builder.property().value(this.getProjection());
            builder.text().asWKT(this.getProjection());
        }
        return builder.toString();
    }

    @Override
    public boolean isTemporary() {
        if (this.featureStore != null && this.featureStore.isTemporary()) {
            return true;
        }
        return super.isTemporary();
    }

    private String getProviderName() {
        if (this.featureStore != null) {
            return this.featureStore.getProviderName();
        }
        if (this.dataStoreParameters != null) {
            return this.dataStoreParameters.getProviderName();
        }
        return null;
    }

    public DataStoreParameters getDataStoreParameters() {
        if (this.featureStore != null) {
            return this.featureStore.getParameters();
        }
        if (this.dataStoreParameters != null) {
            return this.dataStoreParameters;
        }
        return null;
    }

    @Override
    public IProjection getProjection() {
        if (this.featureStore == null) {
            if (this.dataStoreParameters == null) {
                return null;
            }
            if (!this.isVisible()) {
                return null;
            }
            try {
                DataManager dataManager = DALLocator.getDataManager();
                DataStore dataStore = dataManager.openStore(this.dataStoreParameters.getProviderName(), this.dataStoreParameters);
                this.bindToDataStore(dataStore);
                IProjection projection = (IProjection)dataStore.getDynValue("CRS");
                if (projection != null) {
                    this.setProjection(projection);
                }
                if (projection != null && this.getMapContext() != null) {
                    IProjection mapContextProj = this.getMapContext().getProjection();
                    if (!projection.getAbrev().equals(mapContextProj.getAbrev())) {
                        ICoordTrans ct = projection.getCT(mapContextProj);
                        this.setCoordTrans(ct);
                    } else {
                        this.setCoordTrans(null);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't set visibility to layer", ex);
            }
        }
        return super.getProjection();
    }

    private void callSelectionChanged() {
        this.updateDrawVersion(false);
        SelectionEvent e = new SelectionEvent();
        for (LayerListener listener : this.layerListeners) {
            if (!(listener instanceof SelectionListener)) continue;
            SelectionListener l = (SelectionListener)((Object)listener);
            try {
                l.selectionChanged(e);
            }
            catch (Exception ex) {
                logger.warn("Error calling listener '" + listener.toString() + "'.", (Throwable)ex);
            }
        }
    }

    @Override
    public void invalidate() {
        this.updateDrawVersion();
    }

    @Override
    public Object getProperty(Object key) {
        FeatureType ft;
        FeatureStore store;
        Object v = this.properties.getProperty(key);
        if (v == null && (store = this.getFeatureStore()) != null && (ft = store.getDefaultFeatureTypeQuietly()) != null) {
            v = ft.getTags().get("Layer." + key);
        }
        return v;
    }

    protected class EnvelopeCantBeInitializedException
    extends BaseException {
        private static final long serialVersionUID = 4572797479347381552L;
        private static final String MESSAGE_FORMAT = "The envelope can't be initialized, maybe the layer has a wrong projection. Change the projection in layer properties of the add layer dialog to try fix it.";
        private static final String MESSAGE_KEY = "_EnvelopeCantBeInitializedException";

        public EnvelopeCantBeInitializedException() {
            super(MESSAGE_FORMAT, null, MESSAGE_KEY, 4572797479347381552L);
        }
    }

    public static class SelfRegister
    implements Callable {
        public Object call() {
            this.registerPersistence();
            this.registerDefaultVectorLayer();
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            dynObjectManager.registerTag(FLyrVect.TAG_LAYERVECT_MAXSCALE, "Sets the maximum scale visible. Higher scales won't be drawn, -1 if not defined");
            dynObjectManager.registerTag(FLyrVect.TAG_LAYERVECT_MINSCALE, "Sets the minimum scale visible. Lower scales won't be drawn, -1 if not defined");
            return true;
        }

        private Object registerDefaultVectorLayer() {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLayer(FeatureStore.class, FLyrVect.class);
            return true;
        }

        private Object registerPersistence() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(FLyrVect.class, "FLyrVect", "FLyrVect Persistence definition", null, null);
            definition.extend("Persistence", "FLyrDefault");
            definition.addDynFieldObject("legend").setClassOfValue(IVectorLegend.class).setMandatory(false);
            definition.addDynFieldObject("featureStore").setClassOfValue(FeatureStore.class).setMandatory(false);
            definition.addDynFieldBoolean("isLabeled").setMandatory(true);
            definition.addDynFieldInt("typeShape").setMandatory(true);
            definition.addDynFieldObject("labelingStrategy").setClassOfValue(ILabelingStrategy.class).setMandatory(false);
            definition.addDynFieldObject("featureStoreParameters").setClassOfValue(OpenFeatureStoreParameters.class).setMandatory(false);
            return true;
        }
    }
}

