/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.vectorial;

import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntersectsEnvelopeEvaluator
extends AbstractEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntersectsEnvelopeEvaluator.class);
    private final Envelope envelope;
    private final String geomName;
    private final boolean isDefault;
    private final String defaultGeometryAttributeName;
    private final IProjection projection;
    private final GeometryExpressionBuilder builder;
    FeatureAttributeDescriptor fad;

    IntersectsEnvelopeEvaluator(Envelope envelope, IProjection envelopeProjection, FeatureType featureType, String geomName, GeometryExpressionBuilder builder) {
        this.fad = (FeatureAttributeDescriptor)featureType.get(geomName);
        this.defaultGeometryAttributeName = featureType.getDefaultGeometryAttributeName();
        this.isDefault = this.defaultGeometryAttributeName.equals(geomName);
        this.envelope = envelope;
        this.projection = envelopeProjection;
        this.builder = builder;
        this.geomName = geomName;
        this.getFieldsInfo().addMatchFieldValue(geomName, (Object)envelope);
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        Envelope featureEnvelope;
        Geometry geom;
        if (this.isDefault) {
            geom = (Geometry)data.getDataValue(this.defaultGeometryAttributeName);
            featureEnvelope = ((Feature)data.getContextValue("feature")).getDefaultEnvelope();
        } else {
            geom = (Geometry)data.getDataValue(this.geomName);
            if (geom == null) {
                return false;
            }
            featureEnvelope = geom.getEnvelope();
        }
        if (this.envelope.intersects(featureEnvelope)) {
            return this.envelope.intersects(geom);
        }
        return false;
    }

    public String getName() {
        return "intersects envelope";
    }

    public String getSQL() {
        ExpressionBuilder.Variable column = this.builder.column(this.fad.getName());
        IProjection theProjection = this.projection;
        LOGGER.debug("Envelope projection = '" + Objects.toString(theProjection) + "'");
        if (this.fad.getSRS() == null) {
            LOGGER.debug("fad SRS NULL use NULL projection'");
            theProjection = null;
        }
        String s = this.builder.set((ExpressionBuilder.Value)this.builder.and((ExpressionBuilder.Value)this.builder.not_is_null((ExpressionBuilder.Value)column), (ExpressionBuilder.Value)this.builder.andand((ExpressionBuilder.Value)column, (ExpressionBuilder.Value)this.builder.geometry(this.envelope.getGeometry(), theProjection)))).toString();
        LOGGER.debug("Intersects SQL = '" + s + "'");
        return s;
    }
}

