/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.rendering.legend.events;

import java.util.Arrays;
import java.util.List;
import org.gvsig.fmap.mapcontext.events.FMapEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendEventBase;

public class LegendChangedEvent
extends LegendEventBase {
    private final ILegend oldLegend;
    private final ILegend newLegend;
    private List<LegendChangedEvent> events;
    private FMapEvent sourceEvent;

    public static LegendChangedEvent createLegendChangedEvent(ILegend oldLegend, ILegend newLegend) {
        return new LegendChangedEvent(oldLegend, newLegend, 0);
    }

    public static LegendChangedEvent createLegendChangedEvent(ILegend legend, FMapEvent event) {
        LegendChangedEvent e = new LegendChangedEvent(legend, legend, 0);
        e.setSourceEvent(event);
        return e;
    }

    private LegendChangedEvent(ILegend oldLegend, ILegend newLegend, int eventType) {
        this.oldLegend = oldLegend;
        this.newLegend = newLegend;
        this.setEventType(eventType);
    }

    public ILegend getOldLegend() {
        return this.oldLegend;
    }

    public ILegend getNewLegend() {
        return this.newLegend;
    }

    public LegendChangedEvent[] getEvents() {
        return this.events.toArray(new LegendChangedEvent[this.events.size()]);
    }

    public void setEvents(LegendChangedEvent[] events) {
        this.events.addAll(Arrays.asList(events));
    }

    public LegendChangedEvent addEvent(LegendChangedEvent event) {
        this.events.add(event);
        return this;
    }

    public void setSourceEvent(FMapEvent event) {
        this.sourceEvent = event;
    }

    public FMapEvent getSourceEvent() {
        return this.sourceEvent;
    }
}

