/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.rendering.strategies;

import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.LayersVisitor;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.NotSupportedOperationException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedEnvelopeVisitor
implements LayersVisitor {
    private static final Logger logger = LoggerFactory.getLogger(SelectedEnvelopeVisitor.class);
    private Envelope rectangle = null;

    public Envelope getSelectioEnvelope() {
        return this.rectangle;
    }

    public String getProcessDescription() {
        return "Defining rectangle to zoom from selected geometries";
    }

    public void visit(Object obj) throws BaseException {
        if (!(obj instanceof FLayer)) {
            throw new NotSupportedOperationException((Visitor)this, obj);
        }
        this.visit((FLayer)obj);
    }

    @Override
    public void visit(FLayer layer) throws BaseException {
        if (!(layer instanceof SingleLayer)) {
            return;
        }
        if (!layer.isActive()) {
            return;
        }
        if (!(layer instanceof FLyrVect)) {
            return;
        }
        FLyrVect lyr_vect = (FLyrVect)layer;
        Object be = null;
        DataSet selection = ((SingleLayer)layer).getDataStore().getSelection();
        if (selection != null && selection instanceof FeatureSelection) {
            FeatureSelection fsel;
            long sel_count;
            long tot_count = lyr_vect.getFeatureStore().getFeatureCount();
            if (tot_count == (sel_count = (fsel = (FeatureSelection)selection).getSize())) {
                try {
                    this.rectangle = this.accum(this.rectangle, lyr_vect.getFullEnvelope(), null);
                }
                catch (CloneNotSupportedException ex) {
                    logger.debug("Error while adding envelope: " + ex.getMessage(), (Throwable)ex);
                }
            } else {
                ICoordTrans ct = lyr_vect.getCoordTrans();
                DisposableIterator iter = fsel.fastIterator();
                Feature feat = null;
                while (iter.hasNext()) {
                    feat = (Feature)iter.next();
                    try {
                        this.rectangle = this.accum(this.rectangle, feat.getDefaultEnvelope(), ct);
                    }
                    catch (CloneNotSupportedException ex) {
                        logger.debug("Error while adding envelope: " + ex.getMessage(), (Throwable)ex);
                        break;
                    }
                }
                iter.dispose();
            }
        }
    }

    private Envelope accum(Envelope ini_env, Envelope add_env, ICoordTrans cotr) throws CloneNotSupportedException {
        if (add_env == null) {
            return ini_env;
        }
        if (cotr == null) {
            if (ini_env == null) {
                return add_env;
            }
            Envelope resp = (Envelope)ini_env.clone();
            resp.add(add_env);
            return resp;
        }
        Envelope add_rep = (Envelope)add_env.convert(cotr).clone();
        if (ini_env == null) {
            return add_rep;
        }
        Envelope resp = (Envelope)ini_env.clone();
        resp.add(add_rep);
        return resp;
    }
}

