/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.rendering.strategies;

import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.LayersVisitor;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.NotSupportedOperationException;
import org.gvsig.tools.visitor.Visitable;
import org.gvsig.tools.visitor.Visitor;

public class SelectedZoomVisitor
implements LayersVisitor,
Visitor {
    private Envelope rectangle = null;

    public Envelope getSelectBound() {
        return this.rectangle;
    }

    public String getProcessDescription() {
        return "Defining rectangle to zoom from selected geometries";
    }

    public void visit(Feature feature) throws BaseException {
        if (this.rectangle == null) {
            this.rectangle = feature.getDefaultGeometry().getEnvelope();
        } else {
            this.rectangle.add(feature.getDefaultGeometry().getEnvelope());
        }
    }

    public void visit(FeatureReference featureRefence) throws BaseException {
        this.visit(featureRefence.getFeature());
    }

    public void visit(Object obj) throws BaseException {
        if (obj instanceof FeatureReference) {
            this.visit((FeatureReference)obj);
            return;
        }
        if (obj instanceof Feature) {
            this.visit((Feature)obj);
            return;
        }
        if (obj instanceof FLayer) {
            this.visit((FLayer)obj);
            return;
        }
        throw new NotSupportedOperationException((Visitor)this, obj);
    }

    @Override
    public void visit(FLayer layer) throws BaseException {
        if (!(layer instanceof SingleLayer)) {
            return;
        }
        if (!layer.isActive()) {
            return;
        }
        DataSet selection = ((SingleLayer)layer).getDataStore().getSelection();
        if (selection instanceof Visitable) {
            selection.accept((Visitor)this);
        }
    }
}

