/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.rendering.symbols.impl;

import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextRuntimeException;
import org.gvsig.fmap.mapcontext.impl.InvalidRegisteredClassException;
import org.gvsig.fmap.mapcontext.impl.RegisteredClassInstantiationException;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.fmap.mapcontext.rendering.symbols.impl.DefaultSymbolPreferences;
import org.gvsig.fmap.mapcontext.rendering.symbols.impl.LoadSymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.impl.SaveSymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.impl.SymbolFileAlreadyExistsException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSymbolManager
implements SymbolManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSymbolManager.class);
    private SymbolPreferences symbolPreferences = new DefaultSymbolPreferences();
    private Map symbolsByName = Collections.synchronizedMap(new HashMap());
    private Map symbolsByShapeType = Collections.synchronizedMap(new HashMap());
    private Map multiLayerSymbolsByName = Collections.synchronizedMap(new HashMap());
    private Map multiLayerSymbolsByShapeType = Collections.synchronizedMap(new HashMap());
    private IWarningSymbol warningSymbol;
    private Object warningSymbolLock = new Object();
    private static Color[] BREWER_COLOR = new Color[36];
    private static final Random rnd = new Random();

    @Override
    public ISymbol[] loadSymbols(File folder) throws SymbolException {
        return this.loadSymbols(folder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISymbol[] loadSymbols(File folder, FileFilter fileFilter) throws SymbolException {
        if (folder.exists()) {
            File[] symbolFiles = null;
            symbolFiles = fileFilter == null ? folder.listFiles() : folder.listFiles(fileFilter);
            if (symbolFiles != null) {
                TaskStatusManager tm = ToolsLocator.getTaskStatusManager();
                SimpleTaskStatus status = tm.createDefaultSimpleTaskStatus("Load symbols");
                status.setRangeOfValues(0L, (long)symbolFiles.length);
                status.setAutoremove(true);
                status.add();
                status.message("sorting symbols");
                Arrays.sort(symbolFiles, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        File f1 = (File)o1;
                        File f2 = (File)o2;
                        return f1.getName().compareTo(f2.getName());
                    }
                });
                ISymbol[] symbols = null;
                try {
                    symbols = new ISymbol[symbolFiles.length];
                    for (int i = 0; i < symbolFiles.length; ++i) {
                        status.setCurValue((long)i);
                        File symbolFile = symbolFiles[i];
                        try {
                            symbols[i] = this.loadSymbol(symbolFile);
                            continue;
                        }
                        catch (Throwable th) {
                            logger.warn("Can't load symbol '" + symbolFile.getAbsolutePath() + "'.", th);
                        }
                    }
                }
                finally {
                    status.terminate();
                }
                return symbols;
            }
        }
        return null;
    }

    @Override
    public CancellableTask loadSymbols(File folder, FileFilter filter, Visitor visitor) {
        SymbolsLoaderTask task = new SymbolsLoaderTask(folder, filter, visitor);
        task.start();
        return task;
    }

    @Override
    public void saveSymbol(ISymbol symbol, String fileName, File folder) throws SymbolException {
        this.saveSymbol(symbol, fileName, folder, false);
    }

    @Override
    public void saveSymbol(ISymbol symbol, String fileName, File folder, boolean overwrite) throws SymbolException {
        ISymbol_v2 symbolv2;
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        File symbolFile = new File(folder, fileName);
        if (!overwrite && symbolFile.exists()) {
            throw new SymbolFileAlreadyExistsException(symbolFile);
        }
        try {
            FileOutputStream fos = new FileOutputStream(symbolFile);
            persistenceManager.saveState(persistenceManager.getState((Object)symbol), (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (PersistenceException e) {
            throw new SaveSymbolException(e);
        }
        catch (IOException e) {
            throw new SaveSymbolException(e);
        }
        if (symbol instanceof ISymbol_v2 && StringUtils.isBlank((CharSequence)(symbolv2 = (ISymbol_v2)symbol).getID())) {
            symbolv2.setID(FilenameUtils.getBaseName((String)fileName));
        }
    }

    @Override
    public ISymbol loadSymbol(File file) throws SymbolException {
        if (file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                PersistentState state = persistenceManager.loadState((InputStream)fis);
                ISymbol symbol = (ISymbol)persistenceManager.create(state);
                fis.close();
                if (symbol instanceof ISymbol_v2) {
                    ISymbol_v2 symbolv2 = (ISymbol_v2)symbol;
                    symbolv2.setID(FilenameUtils.getBaseName((String)file.getName()));
                }
                return symbol;
            }
            catch (PersistenceException e) {
                throw new LoadSymbolException(e);
            }
            catch (IOException e) {
                throw new LoadSymbolException(e);
            }
        }
        return null;
    }

    @Override
    public SymbolPreferences getSymbolPreferences() {
        return this.symbolPreferences;
    }

    @Override
    public ISymbol createSymbol(String symbolName) throws MapContextRuntimeException {
        return this.createSymbol(symbolName, (Class)this.symbolsByName.get(symbolName), ISymbol.class);
    }

    @Override
    public ISymbol createSymbol(int shapeType) throws MapContextRuntimeException {
        String symbolName = this.getSymbolName(this.symbolsByShapeType, shapeType);
        return symbolName == null ? null : this.createSymbol(symbolName);
    }

    @Override
    public ISymbol createSymbol(String symbolName, Color color) throws MapContextRuntimeException {
        ISymbol symbol = this.createSymbol(symbolName);
        if (symbol != null) {
            symbol.setColor(color);
        }
        return symbol;
    }

    @Override
    public ISymbol createSymbol(int shapeType, Color color) throws MapContextRuntimeException {
        String symbolName = this.getSymbolName(this.symbolsByShapeType, shapeType);
        return symbolName == null ? null : this.createSymbol(symbolName, color);
    }

    @Override
    public IMultiLayerSymbol createMultiLayerSymbol(String symbolName) throws MapContextRuntimeException {
        return (IMultiLayerSymbol)this.createSymbol(symbolName, (Class)this.multiLayerSymbolsByName.get(symbolName), IMultiLayerSymbol.class);
    }

    @Override
    public IMultiLayerSymbol createMultiLayerSymbol(int shapeType) throws MapContextRuntimeException {
        String symbolName = this.getSymbolName(this.multiLayerSymbolsByShapeType, shapeType);
        return symbolName == null ? null : this.createMultiLayerSymbol(symbolName);
    }

    private String getSymbolName(Map symbols, int shapeType) {
        String symbolName = (String)symbols.get(shapeType);
        if (symbolName == null) {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            for (Integer geomType : symbols.keySet()) {
                if (!geomManager.isSubtype(geomType.intValue(), shapeType)) continue;
                symbolName = (String)symbols.get(geomType);
                break;
            }
        }
        return symbolName;
    }

    @Override
    public void registerSymbol(String symbolName, Class symbolClass) throws MapContextRuntimeException {
        if (symbolClass == null || !ISymbol.class.isAssignableFrom(symbolClass)) {
            throw new InvalidRegisteredClassException(ISymbol.class, symbolClass, symbolName);
        }
        this.symbolsByName.put(symbolName, symbolClass);
    }

    @Override
    public void registerSymbol(String symbolName, int[] shapeTypes, Class symbolClass) throws MapContextRuntimeException {
        this.registerSymbol(symbolName, symbolClass);
        if (shapeTypes != null) {
            for (int i = 0; i < shapeTypes.length; ++i) {
                this.symbolsByShapeType.put(shapeTypes[i], symbolName);
            }
        }
    }

    @Override
    public void registerMultiLayerSymbol(String symbolName, Class symbolClass) throws MapContextRuntimeException {
        if (symbolClass == null || !IMultiLayerSymbol.class.isAssignableFrom(symbolClass)) {
            throw new InvalidRegisteredClassException(IMultiLayerSymbol.class, symbolClass, symbolName);
        }
        this.multiLayerSymbolsByName.put(symbolName, symbolClass);
    }

    @Override
    public void registerMultiLayerSymbol(String symbolName, int[] shapeTypes, Class symbolClass) throws MapContextRuntimeException {
        this.registerMultiLayerSymbol(symbolName, symbolClass);
        if (shapeTypes != null) {
            for (int i = 0; i < shapeTypes.length; ++i) {
                this.multiLayerSymbolsByShapeType.put(shapeTypes[i], symbolName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWarningSymbol getWarningSymbol(String message, String symbolDesc, int symbolDrawExceptionType) throws MapContextRuntimeException {
        Object object = this.warningSymbolLock;
        synchronized (object) {
            if (this.warningSymbol == null) {
                this.warningSymbol = (IWarningSymbol)this.createSymbol("warning");
            }
        }
        this.warningSymbol.setDescription(symbolDesc);
        this.warningSymbol.setMessage(message);
        this.warningSymbol.setDrawExceptionType(symbolDrawExceptionType);
        return this.warningSymbol;
    }

    private ISymbol createSymbol(String symbolName, Class symbolClass, Class expectedType) throws MapContextRuntimeException {
        ISymbol symbol;
        try {
            symbol = symbolClass == null ? null : symbolClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RegisteredClassInstantiationException(expectedType, symbolClass, symbolName, e);
        }
        catch (IllegalAccessException e) {
            throw new RegisteredClassInstantiationException(expectedType, symbolClass, symbolName, e);
        }
        Color the_color = null;
        the_color = this.getSymbolPreferences().isDefaultSymbolFillColorAleatory() ? DefaultSymbolManager.getRandomBrewerBasedColor() : this.getSymbolPreferences().getDefaultSymbolFillColor();
        symbol.setColor(the_color);
        return symbol;
    }

    @Override
    public void setSymbolPreferences(SymbolPreferences symbolPreferences) {
        this.symbolPreferences = symbolPreferences;
    }

    @Override
    public List getSymbolLibraryNames() {
        File rootfolder = new File(this.getSymbolPreferences().getSymbolLibraryPath());
        Collection libraries = FileUtils.listFiles((File)rootfolder, (IOFileFilter)FileFilterUtils.directoryFileFilter(), null);
        ArrayList l = new ArrayList();
        l.addAll(libraries);
        return l;
    }

    @Override
    public ISymbol getSymbol(String libraryName, String symbolID) throws SymbolException {
        Collection symbols = null;
        File rootfolder = null;
        try {
            rootfolder = new File(this.getSymbolPreferences().getSymbolLibraryPath());
            symbols = FileUtils.listFiles((File)rootfolder, (IOFileFilter)FileFilterUtils.nameFileFilter((String)(symbolID + this.getSymbolPreferences().getSymbolFileExtension())), (IOFileFilter)FileFilterUtils.trueFileFilter());
        }
        catch (Exception ex) {
            logger.warn("Can't get symbol from symbol library (library:'" + libraryName + "', symbol:'" + symbolID + "', symbolLibraryPath'" + rootfolder + "')", (Throwable)ex);
        }
        if (symbols == null) {
            return null;
        }
        if (symbols.isEmpty()) {
            return null;
        }
        File f = null;
        try {
            f = (File)symbols.iterator().next();
            ISymbol symbol = this.loadSymbol(f);
            return symbol;
        }
        catch (Exception ex) {
            String fname = f == null ? "Null" : f.getAbsolutePath();
            logger.warn("Can't load symbol from symbol library (library:'" + libraryName + "', symbol:'" + symbolID + "', symbolLibraryPath'" + rootfolder + "', symbolFile:'" + fname + "')", (Throwable)ex);
            return null;
        }
    }

    public static Color darker(Color col) {
        return new Color(2 * col.getRed() / 3, 2 * col.getGreen() / 3, 2 * col.getBlue() / 3, col.getAlpha());
    }

    public static Color lighter(Color col) {
        Color resp = DefaultSymbolManager.invert(col);
        resp = DefaultSymbolManager.darker(resp);
        return DefaultSymbolManager.invert(resp);
    }

    public static Color invert(Color col) {
        return new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue(), col.getAlpha());
    }

    private static Color getRandomBrewerBasedColor() {
        int ind = rnd.nextInt(BREWER_COLOR.length);
        Color resp = BREWER_COLOR[ind];
        ind = rnd.nextInt(100);
        if (ind > 66) {
            resp = DefaultSymbolManager.darker(resp);
        } else if (ind > 33) {
            resp = DefaultSymbolManager.lighter(resp);
        }
        resp = DefaultSymbolManager.addDarkNoise(resp);
        return resp;
    }

    private static Color addDarkNoise(Color c) {
        int r = Math.max(0, c.getRed() - rnd.nextInt(30));
        int g = Math.max(0, c.getGreen() - rnd.nextInt(30));
        int b = Math.max(0, c.getBlue() - rnd.nextInt(30));
        return new Color(r, g, b, c.getAlpha());
    }

    static {
        DefaultSymbolManager.BREWER_COLOR[0] = new Color(230, 97, 1);
        DefaultSymbolManager.BREWER_COLOR[1] = new Color(253, 184, 99);
        DefaultSymbolManager.BREWER_COLOR[2] = new Color(178, 171, 210);
        DefaultSymbolManager.BREWER_COLOR[3] = new Color(94, 60, 153);
        DefaultSymbolManager.BREWER_COLOR[4] = new Color(166, 97, 26);
        DefaultSymbolManager.BREWER_COLOR[5] = new Color(223, 194, 125);
        DefaultSymbolManager.BREWER_COLOR[6] = new Color(128, 205, 193);
        DefaultSymbolManager.BREWER_COLOR[7] = new Color(1, 133, 113);
        DefaultSymbolManager.BREWER_COLOR[8] = new Color(123, 50, 148);
        DefaultSymbolManager.BREWER_COLOR[9] = new Color(194, 165, 207);
        DefaultSymbolManager.BREWER_COLOR[10] = new Color(166, 219, 160);
        DefaultSymbolManager.BREWER_COLOR[11] = new Color(0, 136, 55);
        DefaultSymbolManager.BREWER_COLOR[12] = new Color(208, 28, 139);
        DefaultSymbolManager.BREWER_COLOR[13] = new Color(241, 182, 218);
        DefaultSymbolManager.BREWER_COLOR[14] = new Color(184, 225, 134);
        DefaultSymbolManager.BREWER_COLOR[15] = new Color(77, 172, 38);
        DefaultSymbolManager.BREWER_COLOR[16] = new Color(202, 0, 32);
        DefaultSymbolManager.BREWER_COLOR[17] = new Color(244, 165, 130);
        DefaultSymbolManager.BREWER_COLOR[18] = new Color(146, 197, 222);
        DefaultSymbolManager.BREWER_COLOR[19] = new Color(5, 113, 176);
        DefaultSymbolManager.BREWER_COLOR[20] = new Color(202, 0, 32);
        DefaultSymbolManager.BREWER_COLOR[21] = new Color(244, 165, 130);
        DefaultSymbolManager.BREWER_COLOR[22] = new Color(186, 186, 186);
        DefaultSymbolManager.BREWER_COLOR[23] = new Color(64, 64, 64);
        DefaultSymbolManager.BREWER_COLOR[24] = new Color(215, 25, 28);
        DefaultSymbolManager.BREWER_COLOR[25] = new Color(253, 174, 97);
        DefaultSymbolManager.BREWER_COLOR[26] = new Color(171, 217, 233);
        DefaultSymbolManager.BREWER_COLOR[27] = new Color(44, 123, 182);
        DefaultSymbolManager.BREWER_COLOR[28] = new Color(215, 25, 28);
        DefaultSymbolManager.BREWER_COLOR[29] = new Color(253, 174, 97);
        DefaultSymbolManager.BREWER_COLOR[30] = new Color(171, 221, 164);
        DefaultSymbolManager.BREWER_COLOR[31] = new Color(43, 131, 186);
        DefaultSymbolManager.BREWER_COLOR[32] = new Color(215, 25, 28);
        DefaultSymbolManager.BREWER_COLOR[33] = new Color(253, 174, 97);
        DefaultSymbolManager.BREWER_COLOR[34] = new Color(166, 217, 106);
        DefaultSymbolManager.BREWER_COLOR[35] = new Color(26, 150, 65);
    }

    public class SymbolsLoaderTask
    extends AbstractMonitorableTask {
        private File folder;
        private FileFilter filter;
        private Visitor visitor;

        public SymbolsLoaderTask(File folder, FileFilter filter, Visitor visitor) {
            super("Load symbols", true);
            this.folder = folder;
            this.filter = filter;
            this.visitor = visitor;
            if (folder == null) {
                throw new IllegalArgumentException("folder is null");
            }
            if (visitor == null) {
                throw new IllegalArgumentException("visitor is null");
            }
        }

        private File[] getFiles() {
            if (this.filter == null) {
                return this.folder.listFiles();
            }
            return this.folder.listFiles(this.filter);
        }

        private String getVisitorName() {
            String s = this.visitor.toString() + "/" + this.visitor.getClass().getName();
            return s;
        }

        private void visit(File file, ISymbol symbol) throws VisitCanceledException {
            try {
                this.visitor.visit((Object)symbol);
            }
            catch (BaseException e) {
                logger.warn("Can't call visit '" + this.getVisitorName() + "' to offer the symbol '" + file.getAbsolutePath() + "'.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                logger.info("[SymbolsLoaderTask" + this.getId() + "] process initited.");
                if (this.folder.exists()) {
                    this.taskStatus.setAutoremove(true);
                    this.taskStatus.message("preparing");
                    File[] symbolFiles = this.getFiles();
                    if (symbolFiles != null) {
                        this.taskStatus.setRangeOfValues(0L, (long)symbolFiles.length);
                        this.taskStatus.message("sorting");
                        Arrays.sort(symbolFiles, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                File f1 = (File)o1;
                                File f2 = (File)o2;
                                return f1.getName().compareTo(f2.getName());
                            }
                        });
                        this.taskStatus.message("loading");
                        for (int i = 0; i < symbolFiles.length; ++i) {
                            this.taskStatus.setCurValue((long)i);
                            if (this.taskStatus.isCancellationRequested()) {
                                logger.info("[SymbolsLoaderTask" + this.getId() + "] process canceled.");
                                break;
                            }
                            ISymbol symbol = null;
                            try {
                                symbol = DefaultSymbolManager.this.loadSymbol(symbolFiles[i]);
                                this.visit(symbolFiles[i], symbol);
                                continue;
                            }
                            catch (VisitCanceledException e) {
                                break;
                            }
                            catch (Throwable e) {
                                logger.warn("Can't load symbol '" + symbolFiles[i].getAbsolutePath() + "'.", e);
                            }
                        }
                        this.taskStatus.message("");
                    }
                }
            }
            finally {
                this.taskStatus.terminate();
            }
            logger.info("[SymbolsLoaderTask" + this.getId() + "] process terminated.");
        }
    }
}

