/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.tools.persistence;

import java.awt.geom.Point2D;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class Point2DPersistenceFactory
extends AbstractSinglePersistenceFactory {
    static final String FIELD_X = "x";
    static final String FIELD_Y = "y";
    private static final String DYNCLASS_NAME = "AwtPoint2D";
    private static final String DYNCLASS_DESCRIPTION = "Awt Point2D";

    public Point2DPersistenceFactory() {
        super(Point2D.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldDouble(FIELD_X).setMandatory(true);
        definition.addDynFieldDouble(FIELD_Y).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        double x = state.getDouble(FIELD_X);
        double y = state.getDouble(FIELD_Y);
        return new Point2D.Double(x, y);
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Point2D point = (Point2D)obj;
        state.set(FIELD_X, point.getX());
        state.set(FIELD_Y, point.getY());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            persistenceManager.registerFactory((PersistenceFactory)new Point2DPersistenceFactory());
            return Boolean.TRUE;
        }
    }
}

