/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.tools.persistence;

import java.awt.geom.Rectangle2D;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class Rectangle2DPersistenceFactory
extends AbstractSinglePersistenceFactory {
    private static final String DYNCLASS_NAME = "AwtRectangle2D";
    private static final String DYNCLASS_DESCRIPTION = "Awt Rectangle2D";
    public static final String FIELD_X = "x";
    public static final String FIELD_Y = "y";
    public static final String FIELD_WIDTH = "width";
    public static final String FIELD_HEIGHT = "height";

    public Rectangle2DPersistenceFactory() {
        super(Rectangle2D.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldDouble(FIELD_X).setMandatory(true);
        definition.addDynFieldDouble(FIELD_Y).setMandatory(true);
        definition.addDynFieldDouble(FIELD_WIDTH).setMandatory(true);
        definition.addDynFieldDouble(FIELD_HEIGHT).setMandatory(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        double x = state.getDouble(FIELD_X);
        double y = state.getDouble(FIELD_Y);
        double width = state.getDouble(FIELD_WIDTH);
        double height = state.getDouble(FIELD_HEIGHT);
        return new Rectangle2D.Double(x, y, width, height);
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        Rectangle2D rec = (Rectangle2D)obj;
        state.set(FIELD_X, rec.getX());
        state.set(FIELD_Y, rec.getY());
        state.set(FIELD_WIDTH, rec.getWidth());
        state.set(FIELD_HEIGHT, rec.getHeight());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            persistenceManager.registerFactory((PersistenceFactory)new Rectangle2DPersistenceFactory());
            return Boolean.TRUE;
        }
    }
}

