/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.px.dxf;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.cresques.geo.ViewPortData;
import org.cresques.px.Extent;
import org.gvsig.dxf.px.IObjList;
import org.gvsig.dxf.px.PxObj;
import org.gvsig.dxf.px.dxf.DxfEntity;

public class DxfEntityList
extends PxObj
implements IObjList.vector {
    IProjection proj = null;
    private Vector data = null;

    public DxfEntityList(IProjection proj) {
        this.extent = new Extent();
        this.data = new Vector();
    }

    @Override
    public void add(Extent.Has obj) {
        if (obj != null) {
            this.extent.add(obj.getExtent());
            this.data.add(obj);
        }
    }

    @Override
    public Extent.Has get(int cnt) {
        return (Extent.Has)this.data.get(cnt);
    }

    @Override
    public IObjList getAt(Point2D pt) {
        DxfEntityList oList = new DxfEntityList(this.proj);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Extent.Has o = (Extent.Has)iter.next();
            if (!o.getExtent().isAt(pt)) continue;
            oList.add(o);
        }
        return oList;
    }

    @Override
    public Iterator iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void remove(Object obj) {
        this.data.remove(obj);
    }

    @Override
    public void clear() {
        this.extent = new Extent();
        this.data.clear();
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection p) {
        this.proj = p;
    }

    public void reProject(ICoordTrans rp) {
        this.extent = new Extent();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            PxObj o = (PxObj)iter.next();
            ((Projected)o).reProject(rp);
            this.extent.add(o.getExtent());
        }
        this.setProjection(rp.getPDest());
    }

    @Override
    public void draw(Graphics2D g, ViewPortData vp) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            DxfEntity entity = (DxfEntity)iter.next();
            Extent extent = entity.getExtent();
            if (vp.getExtent().minX() > extent.maxX() || vp.getExtent().minY() > extent.maxY() || vp.getExtent().maxX() < extent.minX() || vp.getExtent().maxY() < extent.minY() || entity.layer.frozen || entity.layer.isOff) continue;
            entity.draw(g, vp);
        }
    }

    public String toDxfString() {
        StringBuffer sb = new StringBuffer("");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(((DxfEntity)iter.next()).toDxfString());
        }
        return sb.toString();
    }
}

