/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.px.dxf;

import java.awt.Color;
import org.gvsig.dxf.io.DxfFile;
import org.gvsig.dxf.io.DxfGroup;
import org.gvsig.dxf.px.dxf.AcadColor;
import org.gvsig.dxf.px.dxf.DxfTableItem;

public class DxfLayer
extends DxfTableItem {
    public int colorNumber = 9;
    public String lType = "CONTINUOUS";
    public boolean frozen = false;
    public boolean isOff = false;

    public DxfLayer(String name) {
        super(name, 0);
        DxfFile.logger.debug("Dxf: Capa '" + name + "'.");
        this.colorNumber = 255;
        this.lType = "CONTINUOUS";
    }

    public DxfLayer(String name, int clr) {
        super(name, 0);
        this.colorNumber = clr;
        this.lType = "CONTINUOUS";
        DxfFile.logger.debug("DxfLayer name=" + name + ", color=" + this.colorNumber);
    }

    public DxfLayer(String name, int clr, String lType) {
        super(name, 0);
        this.colorNumber = clr;
        this.lType = lType;
    }

    public Color getColor() {
        return AcadColor.getColor(this.colorNumber);
    }

    @Override
    public String toDxfString() {
        StringBuffer sb = new StringBuffer(LAYER.toString() + super.toDxfString());
        sb.append(DxfGroup.toString(5, 10));
        sb.append(DxfGroup.toString(100, "AcDbSymbolTableRecord"));
        sb.append(DxfGroup.toString(100, "AcDbLayerTableRecord"));
        sb.append(DxfGroup.toString(62, this.colorNumber));
        sb.append(DxfGroup.toString(6, this.lType));
        return sb.toString();
    }
}

