/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.app.mainplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.FeatureTypeDefinitionsManager;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.BookmarksAndHistoryManager;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.DynStruct_v2;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EditingToolOptionsPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingToolOptionsPanel.class);
    private static final String BOOKMARKSANDHISTORY_NAME = "EditingToolOptionsPanel";
    private final EditingContext editingContext;
    private EditingService service;
    private JDynForm form;
    private DynStruct_v2 definition;
    private final Observer contextObserver = (observable, notification) -> this.doContextChanged((Notification)notification);
    private final Observer serviceObserver = (observable, notification) -> this.doServiceChanged((Notification)notification);
    private JFeatureForm featureform;
    private JButton applyDefaultValuesButton;
    private ImageIcon confirmIcon;
    private static final Map<String, JsonObject> defaultValues = new HashMap<String, JsonObject>();
    private JTabbedPane tab;
    private static int currentTab = 0;
    private JButton acceptOptionsButton;
    private JTextField txtBookmarkName;
    private JCheckBoxMenuItem keepWhenNullInMarkerMenuItem;
    private KeyListener keylistener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    break;
                }
                default: {
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    };
    private boolean ignore_events = false;

    public EditingToolOptionsPanel(EditingContext editingContext) {
        this.setLayout(new BorderLayout());
        this.txtBookmarkName = new JTextField();
        this.txtBookmarkName.setBorder(null);
        this.txtBookmarkName.setBackground(UIManager.getColor("Panel.background"));
        this.txtBookmarkName.addKeyListener(this.keylistener);
        this.editingContext = editingContext;
        this.editingContext.addObserver(this.contextObserver);
        EditingService activeService = editingContext.getActiveService();
        this.set(activeService);
        this.put(activeService);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)60, (int)50, (int)120);
        try {
            this.confirmIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("common-applychanges");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Bookmarks getBookmarks(FeatureStore store) {
        boolean useBookmarksByTable = true;
        BookmarksAndHistoryManager manager = ToolsLocator.getBookmarksAndHistoryManager();
        if (useBookmarksByTable) {
            return manager.getBookmarksGroup("EditingToolOptionsPanel_" + store.getName());
        }
        return manager.getBookmarksGroup(BOOKMARKSANDHISTORY_NAME);
    }

    private void set(EditingService service) {
        if (this.service == service && service != null) {
            return;
        }
        if (this.service != null) {
            this.service.deleteObserver(this.serviceObserver);
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        if (this.tab != null) {
            currentTab = this.tab.getSelectedIndex();
        }
        if (service == null) {
            this.removeAll();
            this.tab = null;
            JLabel label = new JLabel("<html><center>" + i18n.getTranslation("_Activate_an_editing_tool_to_see_your_options_here") + "</center></html>");
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
        } else if (service != this.service) {
            this.removeAll();
            this.tab = null;
            FeatureStore store = service.getStore();
            this.add((Component)this.createHeader(store), "North");
            this.tab = new JTabbedPane();
            this.tab.setTabPlacement(3);
            this.tab.setTabLayoutPolicy(1);
            this.add((Component)this.tab, "Center");
            this.definition = this.getToolOptionsDefinition(service);
            if (this.definition != null) {
                DynFormManager dynFormManager = DynFormLocator.getDynFormManager();
                this.form = dynFormManager.createJDynForm((DynStruct)this.definition);
                JPanel optionsPanel = new JPanel();
                optionsPanel.setLayout(new BorderLayout());
                optionsPanel.add((Component)this.form.asJComponent(), "Center");
                JButton cancelButton = new JButton(i18n.getTranslation("_Cancel"));
                cancelButton.addActionListener(e -> this.editingContext.cancelActiveService());
                this.acceptOptionsButton = new JButton(i18n.getTranslation("_Accept"));
                this.acceptOptionsButton.addActionListener(e -> this.applyOptions());
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.setLayout(new FlowLayout(2, 2, 0));
                buttonsPanel.add(this.acceptOptionsButton);
                buttonsPanel.add(cancelButton);
                optionsPanel.add((Component)buttonsPanel, "Last");
                this.tab.add(i18n.getTranslation("_Options"), optionsPanel);
                this.form.addListener(new JDynForm.JDynFormListener(){

                    public void message(String message) {
                    }

                    public void fieldChanged(JDynFormField field) {
                        if (EditingToolOptionsPanel.this.acceptOptionsButton != null) {
                            EditingToolOptionsPanel.this.acceptOptionsButton.setIcon(EditingToolOptionsPanel.this.confirmIcon);
                        }
                    }
                });
            }
            try {
                JsonObject xx = defaultValues.get(store.getFullName());
                EditableFeature f = service.getDefaultFeatureValues();
                if (xx != null) {
                    f.copyFrom(xx);
                }
                DynFormDefinition formdef = this.createFormDefinition(service);
                this.featureform = dataSwingManager.createJFeatureForm(formdef);
                this.featureform.getDynForm().setContext((JDynForm.DynFormContext)dataSwingManager.createFeaturesFormContext(store));
                this.featureform.setFeature((Feature)f);
                JPanel valuesPanel = new JPanel();
                valuesPanel.setLayout(new BorderLayout());
                valuesPanel.add((Component)this.featureform.asJComponent(), "Center");
                this.applyDefaultValuesButton = new JButton(i18n.getTranslation("_Apply"));
                this.applyDefaultValuesButton.addActionListener(e -> this.applyDefaultValues());
                JButton resetDefaultValuesButton = new JButton(i18n.getTranslation("_Reset"));
                resetDefaultValuesButton.addActionListener(e -> this.resetDefaultValues());
                Bookmarks bookmarks = this.getBookmarks(store);
                JButton bookmarksButton = new JButton("...");
                BookmarksController bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(bookmarks, bookmarksButton);
                bookmarksController.addMenuItem((JComponent)this.getKeepWhenNullInMarkerMenuItem());
                bookmarksController.addActionListener(e -> {
                    BookmarksController.BookmarkEvent b = (BookmarksController.BookmarkEvent)e;
                    switch (b.getID()) {
                        case 1002: {
                            EditingToolOptionsDefaultValueBookmark bookmark = new EditingToolOptionsDefaultValueBookmark();
                            bookmark.setDefaultValues((Feature)service.getDefaultFeatureValues());
                            bookmark.setKeepWhenNullInMarker(this.getKeepWhenNullInMarkerMenuItem().isSelected());
                            b.setCurrentValue((Object)bookmark);
                            break;
                        }
                        case 1001: {
                            if (b.getCurrentValue() == null) {
                                return;
                            }
                            EditingToolOptionsDefaultValueBookmark bookmark = (EditingToolOptionsDefaultValueBookmark)b.getCurrentValue();
                            this.getKeepWhenNullInMarkerMenuItem().setSelected(bookmark.getKeepWhenNullInMarker());
                            JsonObject bookmarkFeature = bookmark.getDefaultValues();
                            EditableFeature feature = service.getDefaultFeatureValues();
                            this.featureform.fetch(feature);
                            boolean keepWhenNull = this.getKeepWhenNullInMarkerMenuItem().isSelected();
                            feature.copyFrom(bookmarkFeature, t -> !keepWhenNull || bookmarkFeature.getOrDefault((Object)t.getName(), null) != null);
                            this.featureform.setFeature((Feature)feature);
                            this.applyDefaultValues();
                            this.txtBookmarkName.setText(b.getBookmark().getName());
                            this.txtBookmarkName.setCaretPosition(0);
                        }
                    }
                });
                JPanel applyPanel = new JPanel();
                applyPanel.setLayout(new FlowLayout(2, 4, 0));
                applyPanel.add(this.applyDefaultValuesButton);
                applyPanel.add(resetDefaultValuesButton);
                applyPanel.add(bookmarksButton);
                valuesPanel.add((Component)applyPanel, "Last");
                this.tab.add(i18n.getTranslation("_Default_values"), valuesPanel);
                this.featureform.getDynForm().addListener(new JDynForm.JDynFormListener(){

                    public void message(String message) {
                    }

                    public void fieldChanged(JDynFormField field) {
                        if (EditingToolOptionsPanel.this.applyDefaultValuesButton != null) {
                            EditingToolOptionsPanel.this.applyDefaultValuesButton.setIcon(EditingToolOptionsPanel.this.confirmIcon);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.debug("Can't create panel", (Throwable)ex);
            }
            ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)8, (int)43, (int)25, (int)60);
            try {
                this.tab.setSelectedIndex(currentTab);
            }
            catch (Exception ex) {
                LOGGER.debug("Can't activate tab", (Throwable)ex);
            }
            service.addObserver(this.serviceObserver);
        }
        this.service = service;
    }

    private DynFormDefinition createFormDefinition(EditingService service) throws DataException {
        FeatureTypeDefinitionsManager featureTypeDefinitionsManager = DALLocator.getFeatureTypeDefinitionsManager();
        FeatureStore store = service.getStore();
        FeatureType featureType = store.getDefaultFeatureType();
        DynClass dynClass = featureTypeDefinitionsManager.get(store, featureType);
        DynFormDefinition formdef = DynFormLocator.getDynFormManager().createDefinition((DynStruct)dynClass);
        for (FeatureAttributeDescriptor attr : featureType) {
            if (!attr.isPrimaryKey() && !attr.isReadOnly()) continue;
            formdef.remove(attr.getName());
        }
        for (DynFormFieldDefinition fielddef : formdef) {
            if (!fielddef.isMandatory()) continue;
            fielddef.setMandatory(false);
            fielddef.setLabel("<html><b>" + fielddef.getLabel() + "</b></html>");
        }
        return formdef;
    }

    private DynStruct_v2 getToolOptionsDefinition(EditingService service) {
        if (service == null) {
            return null;
        }
        DynStruct_v2 def = (DynStruct_v2)ToolsLocator.getDynObjectManager().createDynClass(service.getName(), null);
        I18nManager i18n = ToolsLocator.getI18nManager();
        List<ServiceParameterField> params = this.getServiceParameters(service);
        for (ServiceParameterField param : params) {
            switch (param.getType()) {
                case POSITION: {
                    DynField_v2 field = (DynField_v2)def.addDynField(param.getFieldName(), 66);
                    field.setLabel(i18n.getTranslation(param.getName()));
                    field.setDescription(i18n.getTranslation(param.getDescription()));
                    field.setDefaultFieldValue(param.getDefaultValue());
                    Tags tags = field.getTags();
                    tags.set("EditingContext", (Object)this.editingContext);
                    tags.set("ParamType", (Object)param.getType());
                    field.setSubtype("EditingPoint");
                    field.setMandatory(false);
                    break;
                }
                case LIST_POSITIONS: {
                    DynField_v2 field = (DynField_v2)def.addDynField(param.getFieldName(), 66);
                    field.setLabel(i18n.getTranslation(param.getName()));
                    field.setDescription(i18n.getTranslation(param.getDescription()));
                    field.setDefaultFieldValue(param.getDefaultValue());
                    Tags tags = field.getTags();
                    tags.set("EditingContext", (Object)this.editingContext);
                    tags.set("ParamType", (Object)param.getType());
                    field.setSubtype("EditingPoint");
                    field.setMandatory(false);
                    break;
                }
                case VALUE: {
                    DynField_v2 field = (DynField_v2)def.addDynFieldDouble(param.getFieldName());
                    if (param.isAditional()) {
                        field.setLabel(i18n.getTranslation("_Value"));
                    } else {
                        field.setLabel(i18n.getTranslation(param.getName()));
                    }
                    Tags tags = field.getTags();
                    tags.set("ParamType", (Object)param.getType());
                    field.setDescription(i18n.getTranslation(param.getDescription()));
                    field.setDefaultFieldValue(param.getDefaultValue());
                    field.setMandatory(false);
                    break;
                }
                case DISTANCE: {
                    DynField_v2 field = (DynField_v2)def.addDynFieldDouble(param.getFieldName());
                    if (param.isAditional()) {
                        field.setLabel(i18n.getTranslation("_Distance"));
                    } else {
                        field.setLabel(i18n.getTranslation(param.getName()));
                    }
                    Tags tags = field.getTags();
                    tags.set("ParamType", (Object)param.getType());
                    field.setDescription(i18n.getTranslation(param.getDescription()));
                    field.setDefaultFieldValue(param.getDefaultValue());
                    field.setMandatory(false);
                    break;
                }
                case OPTION: {
                    String label;
                    Object value;
                    DynField_v2 field = (DynField_v2)def.addDynField(param.getFieldName(), param.getDataType());
                    if (param.isAditional()) {
                        field.setLabel(i18n.getTranslation("_Options"));
                    } else {
                        field.setLabel(i18n.getTranslation(param.getName()));
                    }
                    field.setDescription(i18n.getTranslation(param.getDescription()));
                    ArrayList<DynObjectValueItem> availableValues = new ArrayList<DynObjectValueItem>();
                    availableValues.add(new DynObjectValueItem(null, " "));
                    if (param.getOptions() == null) {
                        for (EditingServiceParameterOptions.ParameterOption parameterOption : param.getOptions2()) {
                            value = parameterOption.getValue();
                            label = i18n.getTranslation(parameterOption.getLabel());
                            availableValues.add(new DynObjectValueItem(value, label));
                        }
                    } else {
                        for (Map.Entry entry : param.getOptions().entrySet()) {
                            value = (String)entry.getKey();
                            label = i18n.getTranslation((String)entry.getValue());
                            availableValues.add(new DynObjectValueItem(value, label));
                        }
                    }
                    Tags tags = field.getTags();
                    tags.set("ParamType", (Object)param.getType());
                    field.setAvailableValues(availableValues);
                    field.setDefaultFieldValue(param.getDefaultValue());
                    field.setMandatory(false);
                    break;
                }
            }
        }
        return def;
    }

    private void clear() {
        this.form.clear();
    }

    private void put(EditingService service) {
        if (this.service != service || service == null) {
            return;
        }
        List<ServiceParameterField> params = this.getServiceParameters(service);
        for (ServiceParameterField param : params) {
            if (param.getIgnoreCurrentValue()) {
                this.form.setValue(param.getFieldName(), null);
                continue;
            }
            this.form.setValue(param.getFieldName(), service.getValue(param.getParameters(), param.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doServiceChanged(Notification notification) {
        if (this.ignore_events) {
            return;
        }
        try {
            this.ignore_events = true;
            switch (notification.getType()) {
                case "EditingService.ParameterChanged2": 
                case "EditingService.ParameterChanged1": {
                    this.put(this.editingContext.getActiveService());
                    return;
                }
                case "EditingService.Activate": {
                    this.set(this.editingContext.getActiveService());
                    this.put(this.editingContext.getActiveService());
                    return;
                }
            }
            return;
        }
        finally {
            this.ignore_events = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doContextChanged(Notification notification) {
        if (this.ignore_events) {
            return;
        }
        try {
            this.ignore_events = true;
            switch (notification.getType()) {
                case "EditingContext.changeSelectedTool": {
                    EditingService activeService = this.editingContext.getActiveService();
                    this.set(activeService);
                    if (activeService == null) return;
                    this.put(activeService);
                    return;
                }
            }
            return;
        }
        finally {
            this.ignore_events = false;
        }
    }

    public void applyDefaultValues() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        EditableFeature feature = this.service.getDefaultFeatureValues();
        this.featureform.fetch(feature);
        this.applyDefaultValuesButton.setIcon(null);
        defaultValues.put(this.service.getStore().getFullName(), feature.toJson());
        this.txtBookmarkName.setText("");
    }

    public void resetDefaultValues() {
        try {
            FeatureStore store = this.service.getStore();
            EditableFeature resetValues = store.createNewFeature();
            EditableFeature feature = this.service.getDefaultFeatureValues();
            feature.copyFrom((Feature)resetValues);
            this.featureform.setFeature((Feature)feature);
            this.applyDefaultValuesButton.setIcon(null);
            defaultValues.put(this.service.getStore().getFullName(), feature.toJson());
            this.txtBookmarkName.setText("");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't reset default values", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyOptions() {
        boolean ignore_events_save = this.ignore_events;
        try {
            this.ignore_events = true;
            List<ServiceParameterField> params = this.getServiceParameters(this.service);
            for (ServiceParameterField param : params) {
                Object value = this.form.getValue(param.getFieldName());
                try {
                    this.editingContext.setValue(param.getParameters(), value, false);
                }
                catch (Throwable th) {
                    LOGGER.debug("Can't set service parameter '" + param.getName() + "' to '" + Objects.toString(value) + "'.", th);
                }
            }
            try {
                this.editingContext.nextParameter();
            }
            catch (Exception ex) {
                LOGGER.debug("Can't apply service parameters.", (Throwable)ex);
            }
            this.acceptOptionsButton.setIcon(null);
        }
        finally {
            this.ignore_events = ignore_events_save;
        }
        this.put(this.service);
    }

    private List<ServiceParameterField> getServiceParameters(EditingService service) {
        ArrayList<ServiceParameterField> params = new ArrayList<ServiceParameterField>();
        EditingServiceParameter.TYPE[] paramTypesOrdered = new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.LIST_POSITIONS, EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.DISTANCE, EditingServiceParameter.TYPE.OPTION, EditingServiceParameter.TYPE.GEOMETRY, EditingServiceParameter.TYPE.SELECTION, EditingServiceParameter.TYPE.CLIPBOARD};
        int n = 0;
        for (EditingServiceParameter param : service.getParameters()) {
            int count = 0;
            block5: for (int ntype = 0; ntype < paramTypesOrdered.length; ++ntype) {
                EditingServiceParameter.TYPE type = paramTypesOrdered[ntype];
                if (!param.getTypes().contains(type)) continue;
                switch (type) {
                    case POSITION: 
                    case LIST_POSITIONS: 
                    case DISTANCE: 
                    case GEOMETRY: 
                    case SELECTION: 
                    case CLIPBOARD: {
                        continue block5;
                    }
                    case VALUE: 
                    case OPTION: {
                        String name = String.format("param%02d%02d", n, ntype);
                        ServiceParameterField serviceField = new ServiceParameterField(param, type, name, count > 0);
                        if (param.getTypes().contains(EditingServiceParameter.TYPE.LIST_POSITIONS)) {
                            serviceField.setIgnoreCurrentValue(true);
                        }
                        params.add(serviceField);
                        ++count;
                    }
                }
            }
            ++n;
        }
        return params;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("EditingToolOptionsDefaultValueBookmark") == null) {
            DynStruct definition = manager.addDefinition(EditingToolOptionsDefaultValueBookmark.class, "EditingToolOptionsDefaultValueBookmark", "EditingToolOptionsDefaultValueBookmark persistence definition", null, null);
            definition.addDynFieldString("values");
            definition.addDynFieldBoolean("keepWhenNullInMarker").setMandatory(false);
        }
    }

    public JPanel createHeader(FeatureStore store) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String s = i18n.getTranslation("_unknown");
        if (store != null) {
            s = store.getName();
            FeatureType ft = store.getDefaultFeatureTypeQuietly();
            if (ft != null && StringUtils.isNotBlank((String)ft.getLabel()) && !store.getName().equals(ft.getLabel())) {
                s = ft.getLabel() + " (" + store.getName() + ")";
            }
        }
        String storelabel = s;
        JTextField txtTable = new JTextField();
        JTextField txtTool = new JTextField();
        JLabel lblTable = new JLabel(i18n.getTranslation("_Table") + ": ");
        JLabel lblTool = new JLabel(i18n.getTranslation("_Tool") + ": ");
        txtTable.setBorder(null);
        txtTable.setBackground(UIManager.getColor("Panel.background"));
        txtTool.setBorder(null);
        txtTool.setBackground(UIManager.getColor("Panel.background"));
        txtTable.addKeyListener(this.keylistener);
        txtTool.addKeyListener(this.keylistener);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 1;
        c.ipady = 1;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        panel.add((Component)lblTable, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        panel.add((Component)lblTool, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        panel.add((Component)txtTable, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        panel.add((Component)txtTool, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add((Component)this.txtBookmarkName, c);
        SwingUtilities.invokeLater(() -> {
            txtTable.setText(storelabel);
            txtTable.setCaretPosition(0);
            txtTool.setText(i18n.getTranslation(this.service.getDescription()));
            txtTool.setCaretPosition(0);
        });
        return panel;
    }

    private JCheckBoxMenuItem getKeepWhenNullInMarkerMenuItem() {
        if (this.keepWhenNullInMarkerMenuItem == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem();
            item.setText(i18n.getTranslation("_Keep_when_null"));
            item.setToolTipText(i18n.getTranslation("_It_does_not_replace_the_default_values_when_the_marker_is_null"));
            this.keepWhenNullInMarkerMenuItem = item;
        }
        return this.keepWhenNullInMarkerMenuItem;
    }

    public static class EditingToolOptionsDefaultValueBookmark
    implements Persistent {
        private JsonObject values;
        private boolean keepWhenNullInMarker;
        private String label;

        public JsonObject getDefaultValues() {
            return this.values;
        }

        public void setDefaultValues(Feature feature) {
            this.values = feature.toJson();
        }

        public String toString() {
            try {
                StringBuilder buffer = new StringBuilder();
                boolean needcolon = false;
                for (JsonValue value : this.values.values()) {
                    String s;
                    if (value == null || !StringUtils.isNotBlank((String)(s = Json.toString((JsonValue)value)))) continue;
                    if (needcolon) {
                        buffer.append(",");
                    } else {
                        needcolon = true;
                    }
                    buffer.append(s);
                }
                return buffer.toString();
            }
            catch (Exception ex) {
                return "default values";
            }
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("values", Objects.toString(this.values, null));
            state.set("keepWhenNullInMarker", this.keepWhenNullInMarker);
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            String json_s = state.getString("values");
            if (StringUtils.isBlank((String)json_s)) {
                this.values = null;
            } else {
                try {
                    this.values = Json.createObject((String)json_s);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't restore default value from persistence", (Throwable)ex);
                }
            }
            this.keepWhenNullInMarker = state.getBoolean("keepWhenNullInMarker", false);
        }

        public void setKeepWhenNullInMarker(boolean keepWhenNullInMarker) {
            this.keepWhenNullInMarker = keepWhenNullInMarker;
        }

        public boolean getKeepWhenNullInMarker() {
            return this.keepWhenNullInMarker;
        }
    }

    private static class ServiceParameterField {
        private final EditingServiceParameter param;
        private final EditingServiceParameter.TYPE type;
        private final String fieldName;
        private final boolean aditional;
        private boolean ignoreCurrentValue;

        public ServiceParameterField(EditingServiceParameter param, EditingServiceParameter.TYPE type, String fieldName, boolean aditional) {
            this.aditional = aditional;
            this.fieldName = fieldName;
            this.param = param;
            this.type = type;
            this.ignoreCurrentValue = false;
        }

        private EditingServiceParameter.TYPE getType() {
            return this.type;
        }

        private String getName() {
            return this.param.getName();
        }

        private int getDataType() {
            return this.param.getDataType();
        }

        private String getDescription() {
            return this.param.getDescription();
        }

        private String getFieldName() {
            return this.fieldName;
        }

        private Object getDefaultValue() {
            return this.param.getDefaultValue();
        }

        private Map<String, String> getOptions() {
            return this.param.getOptions();
        }

        private EditingServiceParameterOptions getOptions2() {
            return this.param.getOptions2();
        }

        private boolean isAditional() {
            return this.aditional;
        }

        private EditingServiceParameter getParameters() {
            return this.param;
        }

        public void setIgnoreCurrentValue(boolean ignoreCurrentValue) {
            this.ignoreCurrentValue = ignoreCurrentValue;
        }

        public boolean getIgnoreCurrentValue() {
            return this.ignoreCurrentValue;
        }
    }
}

