/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.app.mainplugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.swing.ExportSwingLocator;
import org.gvsig.export.swing.ExportSwingManager;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.vectorediting.app.mainplugin.EditingExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilayerFinishEditingPanel
extends JPanel
implements org.gvsig.tools.swing.api.Component {
    private static final int OPTION_SAVE = 0;
    private static final int OPTION_DISMISS = 1;
    private static final int OPTION_CONTINUE = 2;
    private static final int OPTION_EXPORT = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingExtension.class);
    private Dialog dialog;
    private final List<Row> rows = new ArrayList<Row>();
    private final MapContext mapContext;

    public MultilayerFinishEditingPanel(MapContext mapContext) {
        this.mapContext = mapContext;
        this.initComponents();
    }

    private Row getRow(int rowIndex) {
        Row row = this.rows.get(rowIndex);
        return row;
    }

    public void addLayer(FLayer layer) {
        if (layer instanceof FLyrVect) {
            FLyrVect layerVect = (FLyrVect)layer;
            this.rows.add(new Row(this, layerVect));
        }
    }

    public void build() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        int rownum = 0;
        for (Row row : this.rows) {
            this.addComponent(rownum, 0, row.getJLabel());
            this.addComponent(rownum, 1, row.getJDropDown());
            this.addComponent(rownum, 2, row.getJButton());
            ++rownum;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 0.9;
        c.weightx = 0.9;
        c.gridx = 1;
        c.gridy = rownum;
        this.add((Component)new JLabel(""), c);
    }

    private void addComponent(int gridY, int gridX, JComponent component) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        c.ipadx = 2;
        c.ipady = 2;
        c.gridx = gridX;
        c.gridy = gridY;
        this.add((Component)component, c);
    }

    private void initComponents() {
        Iterator layers = this.mapContext.deepiterator();
        while (layers.hasNext()) {
            FLayer layer = (FLayer)layers.next();
            if (!layer.isEditing()) continue;
            this.addLayer(layer);
        }
        this.build();
    }

    private boolean checkExportLayers() {
        boolean exportLayer = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.getRow(i);
            if (row.getJComboBoxOption() != 3) continue;
            exportLayer = true;
        }
        return exportLayer;
    }

    private void updateEnableOkButton() {
        if (this.dialog == null) {
            return;
        }
        if (this.checkExportLayers()) {
            this.dialog.setButtonEnabled(1, false);
        } else {
            this.dialog.setButtonEnabled(1, true);
        }
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.updateEnableOkButton();
    }

    public void apply() {
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.getRow(i);
            if (row.getJComboBoxOption() == 0) {
                try {
                    row.getLayer().getFeatureStore().finishEditing();
                }
                catch (DataException ex) {
                    LOGGER.error(PluginServices.getText((Object)this, (String)"Finish editing process has problems, save option"), (Throwable)ex);
                }
                continue;
            }
            if (row.getJComboBoxOption() != 1) continue;
            try {
                row.getLayer().getFeatureStore().cancelEditing();
                continue;
            }
            catch (DataException ex) {
                LOGGER.error(PluginServices.getText((Object)this, (String)"Finish editing process has problems, dismiss option"), (Throwable)ex);
            }
        }
    }

    public JComponent asJComponent() {
        ToolsSwingManager toolSwingmanager = ToolsSwingLocator.getToolsSwingManager();
        this.build();
        this.setPreferredSize(new Dimension(400, 200));
        JScrollPane scrollPanel = new JScrollPane();
        scrollPanel.setPreferredSize(new Dimension(420, 220));
        scrollPanel.setViewportView(this);
        toolSwingmanager.removeBorder((JComponent)this);
        scrollPanel.setBorder(null);
        return scrollPanel;
    }

    private static class Row {
        private final FLyrVect layer;
        private final DropDown dropDownOptions;
        private final JButton jButtonExport;
        private final LabeledValue[] options;
        I18nManager i18n = ToolsLocator.getI18nManager();
        private final JLabel dropDownComponent;
        private final MultilayerFinishEditingPanel panel;

        public Row(MultilayerFinishEditingPanel panel, FLyrVect layer) {
            this.layer = layer;
            this.panel = panel;
            this.options = new LabeledValue[]{new LabeledValueImpl(this.i18n.getTranslation("_save"), (Object)0), new LabeledValueImpl(this.i18n.getTranslation("_dismiss"), (Object)1), new LabeledValueImpl(this.i18n.getTranslation("_continue"), (Object)2), new LabeledValueImpl(this.i18n.getTranslation("_export"), (Object)3)};
            DefaultComboBoxModel<LabeledValue> modelJComboBoxOptions = new DefaultComboBoxModel<LabeledValue>();
            for (LabeledValue option : this.options) {
                modelJComboBoxOptions.addElement(option);
            }
            ToolsSwingManager toolSwingmanager = ToolsSwingLocator.getToolsSwingManager();
            this.dropDownComponent = new JLabel();
            this.dropDownOptions = toolSwingmanager.createDropDown(this.dropDownComponent);
            this.dropDownOptions.setModel(modelJComboBoxOptions);
            if (this.allowSave()) {
                this.dropDownOptions.setSelectedIndex(0);
            } else {
                this.dropDownOptions.setSelectedIndex(3);
            }
            this.dropDownOptions.setVisibleDropdownArrow(true);
            this.jButtonExport = new JButton(this.i18n.getTranslation("_export"));
            this.jButtonExport.addActionListener(e -> {
                WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                ExportManager exportManager = ExportLocator.getManager();
                ExportSwingManager exportSwingManager = ExportSwingLocator.getSwingManager();
                ExportProcess process = exportManager.createProcess(layer.getFeatureStore());
                JExportProcessPanel panel1 = exportSwingManager.createJExportProcessPanel(process);
                windowManager.showWindow(panel1.asJComponent(), "_export", WindowManager.MODE.WINDOW);
                this.dropDownOptions.setSelectedIndex(1);
                this.panel.updateEnableOkButton();
            });
            this.dropDownOptions.addItemListener(e -> panel.updateEnableOkButton());
        }

        public boolean allowSave() {
            return this.layer.getFeatureStore().allowWrite();
        }

        public FLyrVect getLayer() {
            return this.layer;
        }

        public JLabel getJLabel() {
            String layerName = this.layer.getName();
            JLabel layerNameJLabel = new JLabel(layerName);
            return layerNameJLabel;
        }

        public JComponent getJDropDown() {
            return this.dropDownOptions.asJComponent();
        }

        public JButton getJButton() {
            return this.jButtonExport;
        }

        public int getJComboBoxOption() {
            LabeledValue optionSelected = (LabeledValue)this.dropDownOptions.getSelectedItem();
            return (Integer)optionSelected.getValue();
        }
    }
}

