/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.app.mainplugin.dynformfield.point;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.JPointPanel;

public class JDynFormFieldPoint
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected Point assignedValue = null;
    protected Point currentValue = null;
    protected JTextComponent jtext = null;
    protected JButton jbutton = null;
    protected boolean readonly = false;

    public JDynFormFieldPoint(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (Point)value;
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        if (this.contents != null) {
            if (readonly) {
                this.jtext.setEditable(false);
                this.jbutton.setEnabled(false);
            } else {
                this.jtext.setEditable(true);
                this.jbutton.setEnabled(true);
            }
        }
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        JTextComponent text;
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        this.jtext = text = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
        this.fixPreferredWidth(text);
        text.addFocusListener(this);
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JDynFormFieldPoint.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JDynFormFieldPoint.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JDynFormFieldPoint.this.fireFieldChangedEvent();
            }
        });
        this.jbutton = this.getComponentsFactory().getJButton(this.getDefinition(), null);
        this.jbutton.setIcon(this.getIcon("insert-point"));
        if (StringUtils.equals((CharSequence)"...", (CharSequence)this.jbutton.getText())) {
            this.jbutton.setText("");
        }
        this.jbutton.addActionListener(e -> this.onClickPointPanel());
        this.contents.add((Component)this.jtext, "Center");
        this.contents.add((Component)this.jbutton, "After");
        this.contents.setVisible(true);
        if (this.readonly) {
            this.jtext.setEditable(false);
            this.jbutton.setEnabled(false);
        } else {
            this.jtext.setEditable(true);
            this.jbutton.setEnabled(true);
        }
        this.setValue(this.assignedValue);
    }

    public void onClickPointPanel() {
        this.fireFieldEnterEvent();
        Point previous = this.currentValue;
        this.problemIndicator().restore();
        Point x = this.showOpenPointDialog(this.getLabel(), this.currentValue);
        if (x == null) {
            return;
        }
        this.currentValue = x;
        this.jtext.setText(this.pointToText(x));
        this.fireFieldChangedEventIfChanged(previous);
    }

    private void fireFieldChangedEventIfChanged(Point previous) {
        if (previous == null) {
            if (this.currentValue == null) {
                return;
            }
            this.fireFieldChangedEvent();
            return;
        }
        if (this.currentValue == null) {
            this.fireFieldChangedEvent();
            return;
        }
        if (!previous.toString().equals(this.currentValue.toString())) {
            this.fireFieldChangedEvent();
        }
    }

    public void setValue(Object value) {
        Point previous = this.currentValue;
        if (value == null) {
            this.jtext.setText("");
        } else {
            if (!(value instanceof Point)) {
                LOGGER.info("setValue invoked with non Point value (" + value.toString() + ").");
                return;
            }
            this.jtext.setText(this.pointToText((Point)value));
            this.fixPreferredWidth(this.jtext);
        }
        this.currentValue = this.assignedValue = (Point)value;
        this.fireFieldChangedEventIfChanged(previous);
    }

    public Object getValue() {
        String s = this.jtext.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        Point value = this.textToPoint(s);
        return value;
    }

    public boolean hasValidValue() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void clear() {
        Object value = this.getDefinition().getDefaultValue();
        value = value != null ? this.pointToText((Point)value) : "";
        this.jtext.setText((String)value);
    }

    private String pointToText(Point p) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < p.getDimension(); ++i) {
            double n = p.getCoordinateAt(i);
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(n);
        }
        return buffer.toString();
    }

    private Point textToPoint(String text) {
        try {
            return (Point)ExpressionUtils.evaluate((String)("ST_MakePoint(" + text + ")"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Point showOpenPointDialog(String label, Point currentValue) {
        Tags tags = this.getDefinition().getTags();
        EditingContext editingContext = (EditingContext)tags.get("EditingContext");
        JPointPanel pointPanel = EditingSwingLocator.getSwingManager().createPointPanel(editingContext);
        pointPanel.setPoint(currentValue);
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(pointPanel.asJComponent(), i18n.getTranslation("enter_point"), null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() != 1) {
            return null;
        }
        return pointPanel.getPoint();
    }
}

