/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl;

import java.util.Objects;
import javax.swing.JComponent;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.featureform.swing.JFeatureForm;
import org.gvsig.featureform.swing.impl.DefaultFeaturesFormContext;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.FeatureTypeDefinitionsManager;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.ScriptManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJFeatureForm
implements JFeatureForm {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJFeatureForm.class);
    Feature feature = null;
    FeatureStore store = null;
    DynFormDefinition definition;
    JDynForm form;

    public JComponent asJComponent() {
        return this.form.asJComponent();
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public void setStore(FeatureStore store) {
        if (Objects.equals(this.store, store)) {
            return;
        }
        this.store = store;
        if (store == null) {
            this.form = null;
            return;
        }
        try {
            FeatureType featureType = this.store.getDefaultFeatureType();
            FeatureTypeDefinitionsManager featureTypeDefinitionsManager = DALLocator.getFeatureTypeDefinitionsManager();
            DynClass dynClass = featureTypeDefinitionsManager.get(store, featureType);
            this.form = DynFormLocator.getDynFormManager().createJDynForm((JDynForm.DynFormContext)new DefaultFeaturesFormContext(this.store){

                @Override
                public Feature getCurrentFeature() {
                    return DefaultJFeatureForm.this.feature;
                }
            }, (DynStruct)dynClass);
        }
        catch (Exception ex) {
            logger.warn("Can't create form.", (Throwable)ex);
            throw new RuntimeException("Can't create form.", ex);
        }
    }

    public void setFeatureType(FeatureType featureType) {
        try {
            FeatureTypeDefinitionsManager featureTypeDefinitionsManager = DALLocator.getFeatureTypeDefinitionsManager();
            DynClass dynClass = featureTypeDefinitionsManager.get(null, featureType);
            this.form = DynFormLocator.getDynFormManager().createJDynForm(new JDynForm.DynFormContext(){

                public ResourcesStorage getResourcesStorage() {
                    return ResourcesStorage.EMPTY_RESOURCESSTORAGE;
                }

                public ScriptManager getScriptManager() {
                    return ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
                }
            }, (DynStruct)dynClass);
        }
        catch (Exception ex) {
            logger.warn("Can't create form.", (Throwable)ex);
            throw new RuntimeException("Can't create form.", ex);
        }
    }

    public void setDefinition(DynFormDefinition definition) {
        try {
            this.form = DynFormLocator.getDynFormManager().createJDynForm(definition);
            this.definition = definition;
        }
        catch (Exception ex) {
            logger.warn("Can't create form.", (Throwable)ex);
            throw new RuntimeException("Can't create form.", ex);
        }
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
        if (this.definition == null) {
            this.setStore(this.feature.getStore());
        }
        this.form.setValues(feature.getAsDynObject());
    }

    public Feature getFeature() {
        return this.feature;
    }

    public JDynForm getDynForm() {
        return this.form;
    }

    public void fetch(EditableFeature feature) {
        this.form.getValues(feature.getAsDynObject());
    }
}

