/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.featureform.swing.impl.DefaultFeaturesFormContext;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FacadeOfAFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.impl.DefaultDataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.AbortActionException;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJFeaturesForm
implements JFeaturesForm,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJFeaturesForm.class);
    private static final int PAGE_SIZE = 10;
    private JFeaturesFormPanel panel;
    private JDynFormSet formset;
    private FeatureStore store;
    private boolean needrefresh;
    private FeaturePagingHelper features;
    private DynFormDefinition definition = null;
    private FeatureQuery currentQuery;
    private List<Action> otherActions = new ArrayList<Action>();
    private final ActionListenerSupport actionListeners;
    private final PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();
    private boolean terminateEditingOnClose = true;
    private boolean ignoreTerminateEditingOnClose = false;

    public DefaultJFeaturesForm() {
        this.propertiesHelper.setProperty("FeaturesForm", (Object)this);
        this.panel = new JFeaturesFormPanel((PropertiesSupport)this.propertiesHelper, new BorderLayout());
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DefaultJFeaturesForm.this.onClose();
                DefaultJFeaturesForm.this.dispose();
            }
        });
        this.actionListeners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    }

    public static void selfRegister() {
    }

    public void setPreferredSize(Dimension dimension) {
        this.panel.setPreferredSize(dimension);
    }

    private void updateForm() {
        if (this.formset == null) {
            this.getFormset();
        }
        try {
            if (this.currentQuery != null) {
                this.currentQuery.retrievesAllAttributes();
            }
            this.features = DALLocator.getDataManager().createFeaturePagingHelper(this.store, this.currentQuery, 10);
            this.callUserEvent("form_beforeReload", this.formset.getForm());
            this.formset.setValues(this.features.asListOfDynObjects());
            this.callUserEvent("form_afterReload", this.formset.getForm());
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't update form", ex);
        }
        this.needrefresh = false;
        this.updateButtonEnabledStatus();
    }

    public JComponent asJComponent() {
        if (this.features == null) {
            try {
                this.updateForm();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.panel;
    }

    public void bind(FeatureStore store) {
        this.bind(store, null, null);
    }

    public void bind(FeatureStore store, DynClass definition) {
        this.bind(store, definition, null);
    }

    public void bind(FeatureStore store, DynClass definition, FeatureQuery query) {
        if (store == null) {
            throw new IllegalArgumentException("bind need a store as parameter, not a null.");
        }
        if (this.store == store) {
            return;
        }
        try {
            if (store.isEditing()) {
                this.ignoreTerminateEditingOnClose = true;
            }
            if (definition == null) {
                DefaultDataSwingManager manager = (DefaultDataSwingManager)DALSwingLocator.getSwingManager();
                definition = manager.featureType2DynClass(store, store.getDefaultFeatureType());
            }
            DynFormManager formManager = DynFormLocator.getDynFormManager();
            this.definition = formManager.getDefinition((DynStruct)definition);
            if (this.formset != null) {
                this.panel.remove(this.formset.asJComponent());
                this.panel.revalidate();
                this.formset = null;
            }
            this.store = store;
            DisposeUtils.bind((Disposable)store);
            this.currentQuery = query;
            if (this.features != null) {
                this.features = null;
                this.updateForm();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't bind store '" + store.getName() + "' to form", ex);
        }
    }

    public void dispose() {
        if (this.formset != null) {
            Action action = this.formset.getAction("finishEditing");
            if (action != null) {
                DisposeUtils.disposeQuietly((Object)action);
            }
            if ((action = this.formset.getAction("startEditing")) != null) {
                DisposeUtils.disposeQuietly((Object)action);
            }
        }
        if (this.panel != null) {
            this.panel.setVisible(false);
        }
        DisposeUtils.disposeQuietly((Disposable)this.store);
        this.store = null;
        this.panel = null;
        this.formset = null;
        this.features = null;
        this.definition = null;
        this.currentQuery = null;
        this.otherActions = null;
    }

    public JDynFormSet getFormset() {
        if (this.formset == null) {
            JComponent component;
            DynFormManager formManager = DynFormLocator.getDynFormManager();
            this.formset = formManager.createJDynFormSet((JDynForm.DynFormContext)new MyFeaturesFormContext(this), this.definition, null);
            if (!this.definition.getTags().has("dynform.layoutmode")) {
                this.formset.setLayoutMode(1);
            }
            List groups = this.definition.getGroups();
            if ((this.formset.getLayoutMode() == 1 || this.formset.getLayoutMode() == 2) && groups.size() == 1 && groups.get(0) == null) {
                this.formset.setLayoutMode(0);
            }
            if ((component = this.formset.getActionButton("set-current-record")) != null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                component.setToolTipText("<html>" + i18n.getTranslation("_Table") + ": " + this.store.getName() + "<br>\n" + "( " + this.store.getFullName() + " )" + "</html>");
            }
            this.formset.setAllowNew(true);
            this.formset.setAllowDelete(true);
            this.formset.setAllowUpdate(true);
            this.formset.setAllowClose(true);
            this.formset.setAllowSearch(true);
            this.formset.setAutosave(true);
            this.formset.addAction((Action)new StartEditingAction());
            this.formset.addAction((Action)new FinishEditingAction());
            this.formset.addAction((Action)new RefreshAction());
            FormActionContext actionContext = new FormActionContext();
            actionContext.set("featuresform", this);
            try {
                Collection factories = DALSwingLocator.getSwingManager().getApplicableStoreActions((DALActionFactory.DALActionContext)actionContext);
                for (DALActionFactory factory : factories) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)factory.getName(), (CharSequence)"ShowForm")) continue;
                    try {
                        Action action = factory.createAction((DALActionFactory.DALActionContext)actionContext);
                        this.formset.addAction(action);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't add action " + factory.getName(), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Can't add actions", (Throwable)ex);
            }
            for (Action action : this.otherActions) {
                this.formset.addAction(action);
            }
            this.formset.addListener((JDynFormSet.JDynFormSetListener)new FormSetListener());
            this.formset.getForm().addListener(new JDynForm.JDynFormListener(){

                public void message(String string) {
                }

                public void fieldChanged(JDynFormField jdff) {
                    DefaultJFeaturesForm.this.updateButtonEnabledStatus();
                }
            });
            ToolsSwingLocator.getToolsSwingManager().removeBorder(this.formset.asJComponent());
            this.panel.add((Component)this.formset.asJComponent(), "Center");
            this.panel.revalidate();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ToolsSwingUtils.ensureHeightWitdh((JComponent)this.panel, (int)256, (int)400, (int)(screenSize.height - 100), (int)(screenSize.width - 60));
        }
        this.updateButtonEnabledStatus();
        return this.formset;
    }

    public void addAction(Action action) {
        this.otherActions.add(action);
        if (this.formset != null) {
            this.formset.addAction(action);
        }
    }

    public long getCurrentIndex() {
        if (this.formset == null) {
            return -1L;
        }
        return this.formset.getCurrentIndex();
    }

    public Feature get(long index) {
        if (this.formset == null || this.features == null) {
            return null;
        }
        try {
            return this.features.getFeatureAt(index);
        }
        catch (BaseException ex) {
            return null;
        }
    }

    public void setQuery(FeatureQuery query) {
        if (this.features != null && this.formset != null && !this.formset.isReadOnly() && this.formset.isAutosave() && this.formset.countValues() > 0 && this.formset.getForm().isModified()) {
            if (!this.store.isEditing()) {
                try {
                    this.store.edit();
                }
                catch (DataException e1) {
                    throw new RuntimeException("Can't set query", e1);
                }
            }
            this.saveChanges(this.formset);
        }
        this.currentQuery = query;
        this.updateForm();
    }

    private FeatureQuery getCurrentQuery() {
        return this.currentQuery;
    }

    public void showForm(WindowManager.MODE mode) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String title = i18n.getTranslation("_Form") + ": " + this.definition.getLabel();
        this.showForm(title, mode);
    }

    public void showForm(String title, WindowManager.MODE mode) {
        WindowManager winmgr = ToolsSwingLocator.getWindowManager();
        if (StringUtils.isBlank((CharSequence)title)) {
            title = this.definition.getLabel();
        }
        winmgr.showWindow(this.asJComponent(), title, mode);
    }

    public void hideForm() {
        DisposeUtils.dispose((Disposable)this);
    }

    private void saveChanges(JDynFormSet theFormSet) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            EditingNotificationManager editingManager = DALSwingLocator.getEditingNotificationManager();
            if (theFormSet.isInNewState()) {
                EditableFeature newFeature = this.store.createNewFeature(false);
                JDynForm form = this.formset.getForm();
                for (FeatureAttributeDescriptor attr : this.store.getDefaultFeatureTypeQuietly()) {
                    String name = attr.getName();
                    if (!newFeature.canSetValue(name)) continue;
                    JDynFormField field = form.getField(name);
                    if (field == null) {
                        newFeature.set(name, attr.getDefaultValueCoerced());
                        continue;
                    }
                    try {
                        Object value = field.getValue();
                        newFeature.set(name, value);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't get value of field '" + name + "'.", (Throwable)ex);
                    }
                }
                EditingNotification notification = editingManager.notifyObservers((Object)this, "BEFORE_INSERT_FEATURE", null, (DataStore)this.store, (Feature)newFeature);
                if (notification.isAborted()) {
                    theFormSet.message(i18n.getTranslation("Problems occurred while saving the data."));
                    return;
                }
                if (notification.isCanceled()) {
                    theFormSet.message(i18n.getTranslation("Data saving has been cancelled."));
                    return;
                }
                if (!editingManager.validateFeature((Feature)newFeature)) {
                    theFormSet.message(i18n.getTranslation("The data cannot be saved. Check that all the required fields are filled out.."));
                    return;
                }
                this.features.insert(newFeature);
                editingManager.notifyObservers((Object)this, "AFTER_INSERT_FEATURE", null, (DataStore)this.store, (Feature)newFeature);
                this.formset.message(i18n.getTranslation("_Record_saved"));
                try {
                    this.formset.setValues(this.features.asListOfDynObjects());
                    this.formset.setCurrentIndex((int)this.features.getTotalSize() - 1);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't reload form data after insert.", (Throwable)ex);
                }
            } else {
                int index = theFormSet.getCurrentIndex();
                DynObject currentElement = theFormSet.get(index);
                theFormSet.getFormValues(currentElement);
                EditableFeature feature = ((FacadeOfAFeature)currentElement).getEditableFeature();
                EditingNotification notification = editingManager.notifyObservers((Object)this, "BEFORE_UPDATE_FEATURE", null, (DataStore)this.store, (Feature)feature);
                if (notification.isAborted()) {
                    theFormSet.message(i18n.getTranslation("Problems occurred while saving the data."));
                    return;
                }
                if (notification.isCanceled()) {
                    theFormSet.message(i18n.getTranslation("Data saving has been cancelled."));
                    return;
                }
                if (!editingManager.validateFeature((Feature)feature)) {
                    theFormSet.message(i18n.getTranslation("The data cannot be saved. Check that all the required fields are filled out.."));
                    return;
                }
                this.features.update(feature);
                editingManager.notifyObservers((Object)this, "AFTER_UPDATE_FEATURE", null, (DataStore)this.store, (Feature)feature);
                this.formset.message(i18n.getTranslation("_Record_saved"));
                try {
                    this.formset.setCurrentIndex(index);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't reload form data after insert.", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            theFormSet.message(i18n.getTranslation("error_saving_data_will_not_save"));
            throw new RuntimeException("Can't save values", ex);
        }
        finally {
            this.updateButtonEnabledStatus();
        }
    }

    private void deleteCurrentElement(JDynFormSet theFormSet) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            EditingNotificationManager editingManager = DALSwingLocator.getEditingNotificationManager();
            int index = theFormSet.getCurrentIndex();
            DynObject currentElement = theFormSet.get(index);
            theFormSet.getFormValues(currentElement);
            Feature feature = ((FacadeOfAFeature)currentElement).getFeature();
            if (feature instanceof EditableFeature) {
                feature = ((EditableFeature)feature).getNotEditableCopy();
            }
            if (editingManager.notifyObservers((Object)this, "BEFORE_REMOVE_FEATURE", null, (DataStore)this.store, feature).isCanceled()) {
                theFormSet.message(i18n.getTranslation("The delete operation has been cancelled."));
                return;
            }
            this.features.delete(feature);
            editingManager.notifyObservers((Object)this, "AFTER_REMOVE_FEATURE", null, (DataStore)this.store, feature);
            this.formset.message(i18n.getTranslation("_Record_removed"));
            this.formset.setValues(this.features.asListOfDynObjects());
            if (this.features.getTotalSize() - 1L < (long)index) {
                --index;
            }
            this.formset.setCurrentIndex(index);
        }
        catch (Exception ex) {
            theFormSet.message(i18n.getTranslation("error_removing_data_will_not_remove"));
            throw new RuntimeException("Can't remove values", ex);
        }
        finally {
            this.updateButtonEnabledStatus();
        }
    }

    public void saveChanges() {
        if (this.formset != null && this.formset.countValues() > 0) {
            if (this.store != null && !this.store.isEditing()) {
                try {
                    this.store.edit();
                }
                catch (DataException e1) {
                    LOGGER.warn("Can't edit the store " + this.store.getName());
                    throw new RuntimeException("Can't save changes.", e1);
                }
            }
            this.saveChanges(this.formset);
        }
    }

    private void updateButtonEnabledStatus() {
        if (this.formset == null) {
            return;
        }
        if (this.store == null || this.store.isBroken() || this.store.isAppending() || this.features == null) {
            this.formset.setReadOnly(true);
            this.formset.setActionVisible("startEditing", true);
            this.formset.setActionEnabled("startEditing", true);
            this.formset.setActionVisible("finishEditing", false);
            this.formset.setActionEnabled("finishEditing", false);
            this.formset.setActionEnabled("delete", false);
            this.formset.setActionEnabled("new", false);
            this.formset.setActionEnabled("cancel-new", false);
            this.formset.setActionEnabled("save", false);
            this.formset.setActionEnabled("search", false);
            this.formset.setActionEnabled("refreshForm", true);
            this.formset.setActionEnabled("#navigation", false);
            return;
        }
        if (this.needrefresh) {
            this.formset.setReadOnly(true);
            this.formset.setActionEnabled("delete", false);
            this.formset.setActionEnabled("new", false);
            this.formset.setActionEnabled("cancel-new", false);
            this.formset.setActionEnabled("save", false);
            this.formset.setActionEnabled("search", false);
            this.formset.setActionEnabled("#navigation", false);
            for (Action action : this.formset.getActions()) {
                this.formset.setActionEnabled((String)action.getValue("ActionCommandKey"), false);
            }
            this.formset.setActionEnabled("refreshForm", true);
            return;
        }
        if (this.store.isEditing()) {
            this.formset.setReadOnly(false);
            this.formset.setActionVisible("startEditing", false);
            this.formset.setActionEnabled("startEditing", false);
            this.formset.setActionVisible("finishEditing", true);
            this.formset.setActionEnabled("finishEditing", true);
            if (this.formset.isInNewState()) {
                this.formset.setActionEnabled("delete", false);
                this.formset.setActionEnabled("search", false);
                this.formset.setActionEnabled("new", false);
                this.formset.setActionEnabled("cancel-new", true);
                this.formset.setActionEnabled("save", true);
                this.formset.setActionEnabled("finishEditing", false);
                this.formset.setActionEnabled("refreshForm", false);
            } else if (this.features != null && this.features.isEmpty()) {
                this.formset.getForm().setReadOnly(true);
                this.formset.setActionEnabled("delete", false);
                this.formset.setActionEnabled("search", false);
                this.formset.setActionEnabled("new", true);
                this.formset.setActionEnabled("cancel-new", true);
                this.formset.setActionEnabled("save", false);
                this.formset.setActionEnabled("refreshForm", true);
                this.formset.setActionEnabled("finishEditing", true);
                this.formset.setActionEnabled("#navigation", false);
            } else if (this.formset.getForm().isModified()) {
                this.formset.setActionEnabled("delete", false);
                this.formset.setActionEnabled("search", false);
                this.formset.setActionEnabled("new", false);
                this.formset.setActionEnabled("cancel-new", false);
                this.formset.setActionEnabled("save", true);
                this.formset.setActionEnabled("refreshForm", true);
                this.formset.setActionEnabled("finishEditing", false);
                this.formset.setActionEnabled("#navigation", false);
            } else {
                this.formset.setActionEnabled("delete", true);
                this.formset.setActionEnabled("search", true);
                this.formset.setActionEnabled("new", true);
                this.formset.setActionEnabled("cancel-new", false);
                this.formset.setActionEnabled("save", false);
                this.formset.setActionEnabled("refreshForm", true);
                this.formset.setActionEnabled("finishEditing", true);
                this.formset.setActionEnabled("#navigation", true);
            }
            return;
        }
        this.formset.setReadOnly(true);
        this.formset.setActionVisible("startEditing", true);
        this.formset.setActionEnabled("startEditing", true);
        this.formset.setActionVisible("finishEditing", false);
        this.formset.setActionEnabled("finishEditing", false);
        this.formset.setActionEnabled("delete", false);
        this.formset.setActionEnabled("new", false);
        this.formset.setActionEnabled("cancel-new", false);
        this.formset.setActionEnabled("save", false);
        this.formset.setActionEnabled("search", true);
        this.formset.setActionEnabled("refreshForm", true);
        for (Action action : this.formset.getActions()) {
            this.formset.setActionEnabled((String)action.getValue("ActionCommandKey"), true);
        }
    }

    private void clearUniqueFields() {
        for (FeatureAttributeDescriptor attr : this.store.getDefaultFeatureTypeQuietly()) {
            JDynFormField field;
            if ((!attr.isPrimaryKey() || attr.isAutomatic()) && (!attr.isIndexed() || attr.allowIndexDuplicateds()) || (field = this.formset.getForm().getField(attr.getName())) == null) continue;
            field.clear();
        }
    }

    private void setEnabledUniqueFields(boolean enabled) {
        for (FeatureAttributeDescriptor attr : this.store.getDefaultFeatureTypeQuietly()) {
            JDynFormField field;
            if ((!attr.isPrimaryKey() || attr.isAutomatic()) && (!attr.isIndexed() || attr.allowIndexDuplicateds()) || (field = this.formset.getForm().getField(attr.getName())) == null) continue;
            field.setReadOnly(!enabled);
        }
    }

    public long getDataSetSize() {
        if (this.features != null) {
            return this.features.getTotalSize();
        }
        return 0L;
    }

    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public FeatureType getFeatureType() {
        if (this.store == null) {
            return null;
        }
        return this.store.getDefaultFeatureTypeQuietly();
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.addActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListeners.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.actionListeners.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent event) {
        this.actionListeners.fireActionEvent(event);
    }

    public boolean hasActionListeners() {
        return this.actionListeners.hasActionListeners();
    }

    public Feature getCurrentFeature() {
        long index = this.getCurrentIndex();
        if (index < 0L) {
            return null;
        }
        Feature f = this.get(index);
        try {
            DynObject adapter = f.getAsDynObject();
            this.getFormset().getForm().getValues(adapter);
            f = ((FacadeOfAFeature)adapter).getFeature();
            return f;
        }
        catch (Exception ex) {
            return f;
        }
    }

    protected void callUserEvent(String name, Object ... args) {
        JDynForm form = this.formset.getForm();
        form.callUserEvent(name, args);
    }

    public void setTerminateEditingOnClose(boolean b) {
        this.terminateEditingOnClose = b;
    }

    public boolean isTerminateEditingOnClose() {
        return this.terminateEditingOnClose;
    }

    private void onClose() {
        if (this.store == null || this.ignoreTerminateEditingOnClose) {
            return;
        }
        if (this.store.isEditing() && this.terminateEditingOnClose) {
            DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
            ThreadSafeDialogsManager dialogManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            try {
                int x = dataSwingManager.askUserStopEditing((Component)this.formset.asJComponent(), this.store, false);
                switch (x) {
                    case 0: {
                        this.store.finishEditing();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        this.store.cancelEditing();
                        break;
                    }
                    case 3: {
                        if (((DefaultDataSwingManager)dataSwingManager).exportStore(this.store, WindowManager.MODE.DIALOG)) break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Can't finish editing in FeatureForm (" + DataStore.getNameQuietly((DataStore)this.store) + ").", (Throwable)ex);
                dialogManager.messageDialog(i18nManager.getTranslation("_Problems_finish_table_editing") + "\n\n" + i18nManager.getTranslation("_see_error_log_for_more_information"), i18nManager.getTranslation("_Stop_editing"), 0);
            }
        }
    }

    private class FormSetListener
    implements JDynFormSet.JDynFormSetListener {
        private FormSetListener() {
        }

        public void formMessage(String message) {
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formMessage"));
        }

        public void formClose() {
            DefaultJFeaturesForm.this.panel.setVisible(false);
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formClose"));
        }

        public void formMovedTo(int currentPosition) throws AbortActionException {
            LOGGER.trace("formMovedTo " + currentPosition);
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formMovedTo"));
        }

        public void formBeforeSave(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeSave");
            DefaultJFeaturesForm.this.saveChanges(dynformSet);
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeSave"));
        }

        public void formBeforeNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeNew");
            DefaultJFeaturesForm.this.clearUniqueFields();
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeNew"));
        }

        public void formBeforeDelete(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeDelete");
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeDelete"));
        }

        public void formAfterSave(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterSave");
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterSave"));
        }

        public void formAfterNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterNew");
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterNew"));
        }

        public void formAfterDelete(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterDelete");
            DefaultJFeaturesForm.this.deleteCurrentElement(dynformSet);
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterDelete"));
        }

        public void formBeforeSearch(JDynFormSet dynformSet) throws AbortActionException {
            Evaluator filter;
            LOGGER.trace("formBeforeSearch");
            DataSwingManager dataSwingmanager = DALSwingLocator.getSwingManager();
            WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            FeatureStoreSearchPanel searchPanel = dataSwingmanager.createFeatureStoreSearchPanel(DefaultJFeaturesForm.this.store);
            searchPanel.setShowActions(false);
            FeatureQuery currentQuery = DefaultJFeaturesForm.this.getCurrentQuery();
            if (currentQuery != null && (filter = currentQuery.getFilter()) instanceof ExpressionEvaluator) {
                Expression expression = ((ExpressionEvaluator)filter).toExpression();
                searchPanel.setFilter(expression);
                searchPanel.search();
            }
            ToolsSwingUtils.ensureHeightWitdh((org.gvsig.tools.swing.api.Component)searchPanel, (int)0, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
            I18nManager i18n = ToolsLocator.getI18nManager();
            Dialog dialog = winmgr.createDialog(searchPanel.asJComponent(), i18n.getTranslation("_Filter"), i18n.getTranslation("_Creating_filter_for") + ": '" + DefaultJFeaturesForm.this.store.getName() + "'", 3);
            dialog.show(WindowManager.MODE.DIALOG);
            if (dialog.getAction() == 1) {
                SearchParameters params = searchPanel.fetch(null);
                if (params.getQuery() != null) {
                    FeatureQuery searchQuery = params.getQuery().getCopy();
                    Expression expresion = null;
                    if (searchQuery != null) {
                        expresion = searchQuery.getExpressionFilter();
                    }
                    try {
                        FeatureQuery query = DefaultJFeaturesForm.this.store.createFeatureQuery();
                        if (ExpressionUtils.isPhraseEmpty((Expression)expresion)) {
                            query.clearFilter();
                        } else {
                            query.setFilter(expresion);
                        }
                        DefaultJFeaturesForm.this.setQuery(query);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't apply filter '" + expresion + "'.", (Throwable)ex);
                    }
                } else {
                    LOGGER.warn("FeatureQuery from parameters is null. Query is not applied to the JFeaturesFrom");
                }
            }
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeSearch"));
        }

        public void formAfterSearch(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterSearch");
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterSearch"));
        }

        public void formBeforeCancelNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formBeforeCancelNew");
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formBeforeCancelNew"));
        }

        public void formAfterCancelNew(JDynFormSet dynformSet) throws AbortActionException {
            LOGGER.trace("formAfterCancelNew");
            try {
                int index = DefaultJFeaturesForm.this.formset.getCurrentIndex();
                if (index < 0) {
                    DefaultJFeaturesForm.this.formset.getForm().clear();
                } else {
                    DefaultJFeaturesForm.this.formset.setCurrentIndex(index);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Can't reload form data after cancel new.", (Throwable)ex);
            }
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
            DefaultJFeaturesForm.this.actionListeners.fireActionEvent(new ActionEvent(this, 1, "formAfterCancelNew"));
        }
    }

    private class StartEditingAction
    extends AbstractAction
    implements Observer,
    Disposable {
        public StartEditingAction() {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            this.putValue("Name", null);
            this.putValue("ShortDescription", i18nManager.getTranslation("_Start_editing"));
            this.putValue("SmallIcon", iconTheme.get("table-start-editing"));
            this.putValue("ActionCommandKey", "startEditing");
            this.setEnabled(!DefaultJFeaturesForm.this.store.isEditing());
            DefaultJFeaturesForm.this.store.addObserver((Observer)this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (DefaultJFeaturesForm.this.store == null || DefaultJFeaturesForm.this.formset == null) {
                return;
            }
            if (!DefaultJFeaturesForm.this.store.isEditing()) {
                try {
                    EditingNotificationManager editingManager = DALSwingLocator.getEditingNotificationManager();
                    EditingNotification notification = editingManager.notifyObservers((Object)this, "BEFORE_ENTER_EDITING_STORE", null, (DataStore)DefaultJFeaturesForm.this.store);
                    if (notification.isCanceled() || notification.isAborted()) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        DefaultJFeaturesForm.this.formset.message(i18n.getTranslation("Enter editing has been cancelled."));
                        return;
                    }
                    DefaultJFeaturesForm.this.store.edit();
                    editingManager.notifyObservers((Object)this, "AFTER_ENTER_EDITING_STORE", null, (DataStore)DefaultJFeaturesForm.this.store);
                }
                catch (DataException ex) {
                    LOGGER.warn("Can't finish editing in FeatureForm (" + DefaultJFeaturesForm.this.store.getName() + ").", (Throwable)ex);
                }
            }
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
        }

        public void update(Observable observable, Object notification) {
            if (DefaultJFeaturesForm.this.store == null || DefaultJFeaturesForm.this.formset == null) {
                return;
            }
            if (notification instanceof FeatureStoreNotification) {
                FeatureStoreNotification n = (FeatureStoreNotification)notification;
                switch (n.getType()) {
                    case "after_CancelEditing_DataStore": {
                        DefaultJFeaturesForm.this.needrefresh = true;
                    }
                    case "after_StartEditing_DataStore": 
                    case "after_FinishEditing_DataStore": {
                        DefaultJFeaturesForm.this.updateButtonEnabledStatus();
                    }
                }
            }
        }

        public void dispose() {
            DefaultJFeaturesForm.this.store.deleteObserver((Observer)this);
        }
    }

    private class FinishEditingAction
    extends AbstractAction
    implements Observer,
    Disposable {
        public FinishEditingAction() {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            this.putValue("Name", null);
            this.putValue("ShortDescription", i18nManager.getTranslation("_Stop_editing"));
            this.putValue("SmallIcon", iconTheme.get("table-stop-editing"));
            this.putValue("ActionCommandKey", "finishEditing");
            this.setEnabled(DefaultJFeaturesForm.this.store.isEditing());
            DefaultJFeaturesForm.this.store.addObserver((Observer)this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (DefaultJFeaturesForm.this.store == null || DefaultJFeaturesForm.this.formset == null) {
                return;
            }
            if (DefaultJFeaturesForm.this.store.isEditing()) {
                EditingNotificationManager editingManager = DALSwingLocator.getEditingNotificationManager();
                DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                ThreadSafeDialogsManager dialogManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                try {
                    int x = dataSwingManager.askUserStopEditing((Component)DefaultJFeaturesForm.this.formset.asJComponent(), DefaultJFeaturesForm.this.store, true);
                    switch (x) {
                        case 0: {
                            EditingNotification notification = editingManager.notifyObservers((Object)this, "BEFORE_EXIT_EDITING_STORE", null, (DataStore)DefaultJFeaturesForm.this.store);
                            if (notification.isCanceled() || notification.isAborted()) {
                                I18nManager i18n = ToolsLocator.getI18nManager();
                                DefaultJFeaturesForm.this.formset.message(i18n.getTranslation("Finish editing has been cancelled."));
                                return;
                            }
                            DefaultJFeaturesForm.this.store.finishEditing();
                            editingManager.notifyObservers((Object)this, "AFTER_EXIT_EDITING_STORE", null, (DataStore)DefaultJFeaturesForm.this.store);
                            int index = DefaultJFeaturesForm.this.formset.getCurrentIndex();
                            try {
                                DefaultJFeaturesForm.this.updateForm();
                                DefaultJFeaturesForm.this.formset.setCurrentIndex(index);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Can't reload form data after edit.", (Throwable)ex);
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            DefaultJFeaturesForm.this.store.cancelEditing();
                            int index = DefaultJFeaturesForm.this.formset.getCurrentIndex();
                            try {
                                DefaultJFeaturesForm.this.updateForm();
                                DefaultJFeaturesForm.this.formset.setCurrentIndex(index);
                            }
                            catch (IndexOutOfBoundsException ex) {
                                LOGGER.debug("Can't reload form data after discard edit.", (Throwable)ex);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Can't reload form data after discard edit.", (Throwable)ex);
                            }
                            break;
                        }
                        case 3: {
                            if (((DefaultDataSwingManager)dataSwingManager).exportStore(DefaultJFeaturesForm.this.store, WindowManager.MODE.DIALOG)) break;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't finish editing in FeatureForm (" + DefaultJFeaturesForm.this.store.getName() + ").", (Throwable)ex);
                    dialogManager.messageDialog(i18nManager.getTranslation("_Problems_finish_table_editing") + "\n\n" + i18nManager.getTranslation("_see_error_log_for_more_information"), i18nManager.getTranslation("_Stop_editing"), 0);
                }
            }
            DefaultJFeaturesForm.this.updateButtonEnabledStatus();
        }

        public void update(Observable observable, Object notification) {
            if (DefaultJFeaturesForm.this.store == null || DefaultJFeaturesForm.this.formset == null) {
                return;
            }
            if (notification instanceof FeatureStoreNotification) {
                FeatureStoreNotification n = (FeatureStoreNotification)notification;
                switch (n.getType()) {
                    case "after_CancelEditing_DataStore": {
                        DefaultJFeaturesForm.this.needrefresh = true;
                    }
                    case "after_StartEditing_DataStore": 
                    case "after_FinishEditing_DataStore": {
                        DefaultJFeaturesForm.this.updateButtonEnabledStatus();
                    }
                }
            }
        }

        public void dispose() {
            DefaultJFeaturesForm.this.store.deleteObserver((Observer)this);
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            this.putValue("Name", null);
            this.putValue("ShortDescription", i18nManager.getTranslation("_Reload_data"));
            this.putValue("SmallIcon", iconTheme.get("common-form-refresh"));
            this.putValue("ActionCommandKey", "refreshForm");
            this.setEnabled(!DefaultJFeaturesForm.this.formset.isInNewState());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                I18nManager i18n = ToolsLocator.getI18nManager();
                DefaultJFeaturesForm.this.formset.message(i18n.getTranslation("_Form_reloaded"));
                int x = DefaultJFeaturesForm.this.formset.getCurrentIndex();
                DefaultJFeaturesForm.this.updateForm();
                DefaultJFeaturesForm.this.formset.setCurrentIndex(x);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't reload form", (Throwable)ex);
            }
        }
    }

    public static class MyFeaturesFormContext
    extends DefaultFeaturesFormContext {
        private final DefaultJFeaturesForm featuresForm;

        public MyFeaturesFormContext(DefaultJFeaturesForm featuresForm) {
            super(featuresForm.store);
            this.featuresForm = featuresForm;
        }

        @Override
        public JFeaturesForm getFeaturesForm() {
            return this.featuresForm;
        }

        @Override
        public Feature getCurrentFeature() {
            return this.featuresForm.getCurrentFeature();
        }
    }

    private class FormActionContext
    extends AbstractDALActionFactory.AbstractDALActionContext {
        public FormActionContext() {
            super("FormActionContext");
        }

        public DataStore getStore() {
            return DefaultJFeaturesForm.this.store;
        }

        public FeatureQuery getQuery() {
            Feature f;
            if (DefaultJFeaturesForm.this.currentQuery == null && (f = DefaultJFeaturesForm.this.getCurrentFeature()) != null) {
                FeatureQuery query = DefaultJFeaturesForm.this.store.createFeatureQuery(f.createFilter());
                return query;
            }
            return DefaultJFeaturesForm.this.currentQuery;
        }

        public int getSelectedsCount() {
            return DefaultJFeaturesForm.this.getCurrentFeature() == null ? 0 : 1;
        }

        public Expression getFilterForSelecteds() {
            Feature f = DefaultJFeaturesForm.this.getCurrentFeature();
            if (f != null) {
                Expression filter = f.createFilter();
                return filter;
            }
            return null;
        }

        public FeatureSelection getSelecteds() {
            try {
                FeatureSelection selection = DefaultJFeaturesForm.this.getFeatureStore().createFeatureSelection();
                selection.select(DefaultJFeaturesForm.this.getCurrentFeature());
                return selection;
            }
            catch (DataException ex) {
                return null;
            }
        }

        public JComponent getActionButton(String actionName) {
            if (DefaultJFeaturesForm.this.formset == null) {
                return null;
            }
            return DefaultJFeaturesForm.this.formset.getActionButton(actionName);
        }
    }

    private class JFeaturesFormPanel
    extends JPanel
    implements PropertiesSupport {
        private final PropertiesSupport properties;

        private JFeaturesFormPanel(PropertiesSupport properties, BorderLayout layout) {
            super(layout);
            this.properties = properties;
        }

        public Object getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public void setProperty(String name, Object value) {
            this.properties.setProperty(name, value);
        }

        public Map<String, Object> getProperties() {
            return this.properties.getProperties();
        }
    }
}

