/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl.dynformfield.ImageByteArray;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.imageviewer.ImageViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.util.ToolsUtilLocator;

public abstract class AbstractJDynFormFieldImage<T>
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected SimpleImage assignedValue = null;
    protected boolean readonly = false;
    protected ImageViewer imageViewer;
    private int fieldHeight;
    private final ChangeListener changeListener = e -> this.fireFieldChangedEvent();

    public AbstractJDynFormFieldImage(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(value);
    }

    public void loadDefaultValuesFromTags(Tags tags) {
        super.loadDefaultValuesFromTags(tags);
        this.fieldHeight = tags.getInt("dynform.height", 200);
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        if (this.contents != null) {
            this.contents.setEnabled(!readonly);
        }
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        this.initImageViewer();
        this.setValue(this.assignedValue);
    }

    protected void initImageViewer() {
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout(2, 0));
        this.imageViewer = ToolsUtilLocator.getImageViewerManager().createImageViewer();
        this.imageViewer.addChangeListener(this.changeListener);
        JComponent jimageViewer = this.imageViewer.asJComponent();
        jimageViewer.setPreferredSize(new Dimension(300, this.fieldHeight));
        jimageViewer.setSize(300, this.fieldHeight);
        this.contents.add((Component)jimageViewer, "Center");
        this.contents.setVisible(true);
        this.imageViewer.addAction((Action)new AbstractAction(null, this.getIcon("picker-bytearray-download")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractJDynFormFieldImage.this.doDownload();
            }
        });
        this.imageViewer.addAction((Action)new AbstractAction(null, this.getIcon("picker-bytearray-upload")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractJDynFormFieldImage.this.doUpload();
            }
        });
        this.imageViewer.addAction((Action)new AbstractAction(null, this.getIcon("picker-bytearray-setnull")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractJDynFormFieldImage.this.clear();
            }
        });
    }

    public boolean hasValidValue() {
        return true;
    }

    protected void fireFieldChangedEventIfChanged(SimpleImage previous) {
        if (!Objects.equals(this.getCurrent(), previous)) {
            this.fireFieldChangedEvent();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void clear() {
        this.imageViewer.clean();
    }

    protected Object getPreparedValue(Object value) {
        return value;
    }

    public double getResizeWeight() {
        Tags tags = this.getDefinition().getTags();
        if (!tags.has("dynform.resizeWeight")) {
            return 1.0;
        }
        int resizeWeight = tags.getInt("dynform.resizeWeight", 0);
        if (resizeWeight < 1) {
            return 0.0;
        }
        if (resizeWeight > 100) {
            return 1.0;
        }
        return (double)resizeWeight / 100.0;
    }

    public abstract Object getValue();

    public void setValue(Object value) {
        if (this.imageViewer != null) {
            this.imageViewer.setImage(value);
            this.assignedValue = this.imageViewer.getImage();
        } else {
            this.assignedValue = value instanceof SimpleImage ? (SimpleImage)value : ToolsSwingLocator.getToolsSwingManager().createSimpleImage(value);
        }
    }

    public boolean isModified() {
        return !Objects.equals(this.assignedValue, this.getCurrent());
    }

    protected SimpleImage getCurrent() {
        if (this.imageViewer == null) {
            return this.assignedValue;
        }
        return this.imageViewer.getImage();
    }

    protected File fileChooser(String title, int mode) {
        FoldersManager folderManager;
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        Object[] f = dialogs.showChooserDialog(title, mode, 0, true, (folderManager = ToolsLocator.getFoldersManager()).getLastPath("DynFormFieldImage", null), null, true);
        if (ArrayUtils.isEmpty((Object[])f)) {
            return null;
        }
        folderManager.setLastPath("DynFormFieldImage", (File)f[0]);
        return f[0];
    }

    private void doDownload() {
        SimpleImage current = this.getCurrent();
        if (current == null) {
            return;
        }
        File f = this.fileChooser("Save file", 1);
        if (f == null) {
            return;
        }
        try {
            FileUtils.writeByteArrayToFile((File)f, (byte[])current.toBytearray());
        }
        catch (Exception ex) {
            LOGGER.warn("Can't save bytes from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    private void doUpload() {
        File f = this.fileChooser("Load file", 0);
        if (f == null) {
            return;
        }
        try {
            this.setValue(f);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load bytes from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }
}

