/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtils.class);

    private ReportUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JsonObject> getReports(FeatureStore store) {
        ArrayList<JsonObject> reports;
        block10: {
            reports = new ArrayList<JsonObject>();
            ResourcesStorage resources = null;
            try {
                List reportsResources;
                resources = store.getResourcesStorage();
                if (resources == null || (reportsResources = resources.getResources("report")) == null || reportsResources.isEmpty()) break block10;
                for (ResourcesStorage.Resource resource : reportsResources) {
                    InputStream is = null;
                    try {
                        is = resource.asInputStream();
                        JsonObject json = Json.createReader((InputStream)is).readObject();
                        reports.add(json);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't load report form resource (" + resource.getURL() + ")", (Throwable)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    DisposeUtils.disposeQuietly((Object)resource);
                }
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)resources);
            }
        }
        if (reports.isEmpty()) {
            return null;
        }
        return reports;
    }

    public static List<ReportAction> getReportActions(DataStore store) {
        return ReportUtils.getReportActions(store, null, null, null);
    }

    public static List<ReportAction> getReportActions(DataStore store, Predicate filter) {
        return ReportUtils.getReportActions(store, filter, null, null);
    }

    public static List<ReportAction> getReportActions(DataStore store, Predicate<JsonObject> filter, DALActionFactory.DALActionContext context, ActionEvent e) {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ArrayList<ReportAction> actions = new ArrayList<ReportAction>();
        List<JsonObject> reports = ReportUtils.getReports((FeatureStore)store);
        if (reports != null && !reports.isEmpty()) {
            FeatureSelection selecteds = null;
            if (context == null) {
                selecteds = context.getSelecteds();
            }
            for (JsonObject json : reports) {
                String label;
                if (filter != null && !filter.test(json)) continue;
                ReportAction action = null;
                for (ReportActionFactory theFactory : dataSwingManager.getReportActionFactories()) {
                    if (!theFactory.isApplicable(new Object[]{json, context, e})) continue;
                    if (context == null) {
                        action = theFactory.createReportAction((FeatureStore)store, null, null, json);
                        continue;
                    }
                    action = theFactory.createReportAction((FeatureStore)store, context.getQuery(), selecteds, json);
                }
                if (action == null) continue;
                String name = action.getReportName();
                if (StringUtils.isBlank((CharSequence)name)) {
                    action.setReportName(store.getName());
                }
                if (StringUtils.isBlank((CharSequence)(label = action.getReportLabel()))) {
                    action.setReportLabel(action.getReportName());
                }
                actions.add(action);
            }
        }
        Collections.sort(actions, (o1, o2) -> StringUtils.compare((String)o1.getReportLabel(), (String)o2.getReportLabel()));
        return actions;
    }
}

