/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionAddAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionAddAction.class);
    private final DALActionFactory.DALActionContext context;

    public SelectionAddAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "SelectionAdd");
        this.putValue("ShortDescription", i18n.getTranslation("_Add_to_selection"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("storeaction-select-add"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureSelection currentSelection = this.context.getSelecteds();
            if (currentSelection != null) {
                featureStore.getFeatureSelection().select((FeatureSet)currentSelection);
                return;
            }
            Expression filter = null;
            FeatureQuery query = null;
            FeatureQuery contextQuery = this.context.getQuery();
            if (contextQuery != null && (filter = contextQuery.getExpressionFilter()) != null) {
                query = featureStore.createFeatureQuery();
                query.setFilter(filter);
            }
            currentSelection = featureStore.getFeatureSelection();
            if (query == null) {
                currentSelection.selectAll();
                return;
            }
            FeatureSet selection = featureStore.getFeatureSet(query);
            currentSelection.select(selection);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction.", (Throwable)ex);
        }
    }

    public static class SelectionAddActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "SelectionAdd";

        public SelectionAddActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new SelectionAddAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new SelectionAddActionFactory());
        }
    }
}

