/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator.suggestions;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.Factory;

public class WrongNameFieldSuggestionProviderFactory
implements Factory {
    private final FeatureStore store;
    private FeatureType featureType;

    public WrongNameFieldSuggestionProviderFactory(FeatureStore store) {
        this.store = store;
        try {
            this.featureType = store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            this.featureType = null;
        }
    }

    public String getName() {
        return "WrongNameFieldSuggestion";
    }

    public Object create(Object ... parameters) {
        WrongNameFieldSuggestionProvider suggestionProvider = new WrongNameFieldSuggestionProvider();
        return suggestionProvider;
    }

    private String getSuggestedAttrName(String nameSearched, int maxdistance) {
        LevenshteinDistance comparator = LevenshteinDistance.getDefaultInstance();
        nameSearched = nameSearched.toLowerCase();
        String found_name = null;
        int found_distance = Integer.MAX_VALUE;
        for (FeatureAttributeDescriptor attr : this.featureType) {
            String name = attr.getName();
            int distance = comparator.apply((CharSequence)name.toLowerCase(), (CharSequence)nameSearched);
            if (distance >= found_distance) continue;
            found_name = name;
            found_distance = distance;
        }
        if (found_distance <= maxdistance) {
            return found_name;
        }
        return null;
    }

    private class WrongNameFieldSuggestionProvider
    implements SuggestionProvider {
        private WrongNameFieldSuggestionProvider() {
        }

        public String getSuggestion(String expression) {
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            HashMap similarFields = new HashMap();
            try {
                Code code = ExpressionUtils.compile((String)expression);
                if (code == null) {
                    return null;
                }
                code.accept(obj -> {
                    if (obj instanceof Code.Identifier) {
                        String varname = ((Code.Identifier)obj).name().toLowerCase();
                        if (varname.length() < 3 || WrongNameFieldSuggestionProviderFactory.this.featureType.get(varname) != null) {
                            return;
                        }
                        if (similarFields.containsKey(varname)) {
                            return;
                        }
                        String suggestedName = WrongNameFieldSuggestionProviderFactory.this.getSuggestedAttrName(varname, 3);
                        if (suggestedName != null) {
                            similarFields.put(varname, suggestedName);
                        }
                    }
                });
            }
            catch (Throwable code) {
                // empty catch block
            }
            if (similarFields.isEmpty()) {
                return null;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            StringBuilder suggestion = new StringBuilder();
            suggestion.append(i18n.getTranslation("_Perhaps_you_wanted_to_use_a_similar_field"));
            suggestion.append("\n");
            boolean needAComma = false;
            for (Map.Entry entry : similarFields.entrySet()) {
                if (needAComma) {
                    suggestion.append(", ");
                } else {
                    needAComma = true;
                }
                suggestion.append((String)entry.getKey());
                suggestion.append(" --> ");
                suggestion.append((String)entry.getValue());
            }
            return suggestion.toString();
        }
    }
}

