/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.swing.FeatureTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.SelectionChangeException;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureSelectionModel
implements ListSelectionModel,
Observer {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureSelectionModel.class);
    protected EventListenerList listenerList = new EventListenerList();
    private final FeatureTableModel featureTableModel;
    private int selectionMode = 1;
    private boolean isAdjusting = false;
    private int anchor = -1;
    private int lead = -1;
    private int currentFirst = -1;
    private int currentLast = -1;

    public FeatureSelectionModel(FeatureTableModel featureTableModel) {
        this.featureTableModel = featureTableModel;
        this.featureTableModel.getFeatureSelection().addObserver((Observer)this);
        this.featureTableModel.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ChangeSelection".equals(e.getActionCommand())) {
                    FeatureSelectionModel.this.featureSelectionChanged();
                }
            }
        });
    }

    private void featureSelectionChanged() {
        this.featureTableModel.getFeatureSelection().addObserver((Observer)this);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchor;
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.lead;
    }

    @Override
    public int getMaxSelectionIndex() {
        int resp = this.getSelectionIndex(true);
        return resp;
    }

    @Override
    public int getMinSelectionIndex() {
        int resp = this.getSelectionIndex(false);
        return resp;
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this.anchor = index;
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this.lead = index;
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (!this.featureTableModel.isSelectionLocked()) {
            this.doWithSelection(new FeatureSelectionOperation(){

                @Override
                public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                    for (int i = first; i <= last; ++i) {
                        Feature feature = FeatureSelectionModel.this.getFeature(i);
                        if (selection.isSelected(feature)) continue;
                        selection.select(feature);
                    }
                }
            }, index0, index1, true);
        }
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (!this.featureTableModel.isSelectionLocked()) {
            this.doWithSelection(new FeatureSelectionOperation(){

                @Override
                public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                    selection.deselectAll();
                    for (int i = first; i <= last; ++i) {
                        Feature feature = FeatureSelectionModel.this.getFeature(i);
                        selection.select(feature);
                    }
                }
            }, index0, index1, true);
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (!this.featureTableModel.isSelectionLocked()) {
            this.doWithSelection(new FeatureSelectionOperation(){

                @Override
                public void doWithSelection(FeatureSelection selection, int first, int last) throws DataException {
                    for (int i = first; i <= last; ++i) {
                        Feature feature = FeatureSelectionModel.this.getFeature(i);
                        if (!selection.isSelected(feature)) continue;
                        selection.deselect(feature);
                    }
                }
            }, index0, index1, false);
        }
    }

    @Override
    public void clearSelection() {
        if (!this.featureTableModel.isSelectionLocked()) {
            try {
                this.getFeatureSelection().deselectAll();
            }
            catch (DataException e) {
                throw new SelectionChangeException(e);
            }
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        if (index == -1) {
            return false;
        }
        Feature feature = this.featureTableModel.getFeatureAt(index);
        return this.getFeatureSelection().isSelected(feature);
    }

    @Override
    public boolean isSelectionEmpty() {
        try {
            return this.getFeatureSelection().isEmpty();
        }
        catch (Exception ex) {
            throw new SelectionChangeException(ex);
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (this.isAdjusting != valueIsAdjusting) {
            this.isAdjusting = valueIsAdjusting;
            if (this.isAdjusting) {
                this.getFeatureSelection().beginComplexNotification();
            } else {
                this.getFeatureSelection().endComplexNotification();
            }
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public void update(Observable observable, Object notification) {
        if (observable instanceof FeatureSelection) {
            try {
                this.fireValueChanged(-1, -1, false);
            }
            catch (ConcurrentDataModificationException e) {
                LOG.warn("The store has been updated and the selection can not be refreshed", (Throwable)e);
            }
        }
    }

    private FeatureSelection getFeatureSelection() {
        return this.featureTableModel.getFeatureSelection();
    }

    private void doWithSelection(FeatureSelectionOperation operation, int index0, int index1, boolean select) {
        int last;
        this.anchor = index0;
        this.lead = index1;
        int first = index0 <= index1 ? index0 : index1;
        int n = last = index0 <= index1 ? index1 : index0;
        if (this.currentFirst == first && this.currentLast == last) {
            return;
        }
        this.currentFirst = first;
        this.currentLast = last;
        FeatureSelection selection = this.getFeatureSelection();
        selection.beginComplexNotification();
        try {
            if (first == 0 && last == this.featureTableModel.getRowCount() - 1) {
                if (select) {
                    selection.selectAll();
                } else {
                    selection.deselectAll();
                }
            } else {
                operation.doWithSelection(selection, first, last);
            }
        }
        catch (DataException e) {
            throw new SelectionChangeException(e);
        }
        finally {
            selection.endComplexNotification();
        }
        this.fireValueChanged(first, last, this.isAdjusting);
    }

    private Feature getFeature(int index) {
        return this.featureTableModel.getFeatureAt(index);
    }

    private FeatureStore getFeatureStore() {
        return this.featureTableModel.getFeatureStore();
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        ListSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListSelectionListener.class) continue;
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    private int getSelectionIndex(boolean last) {
        int resp;
        block12: {
            int ind = -1;
            resp = -1;
            FeatureSet fs = null;
            DisposableIterator diter = null;
            try {
                FeatureSelection selection = this.getFeatureSelection();
                if (selection.isEmpty()) break block12;
                FeatureStore store = this.getFeatureStore();
                FeatureQuery query = this.featureTableModel.getFeatureQuery();
                if (query == null) {
                    query = store.createFeatureQuery();
                } else {
                    try {
                        query = (FeatureQuery)query.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                query.addEssentialAttributeNames(store);
                fs = store.getFeatureSet(query);
                diter = fs.fastIterator();
                while (diter.hasNext()) {
                    ++ind;
                    Feature feat = (Feature)diter.next();
                    if (!selection.isSelected(feat)) continue;
                    resp = ind;
                    if (last) continue;
                    break;
                }
            }
            catch (DataException e) {
                throw new SelectionChangeException(e);
            }
            finally {
                if (diter != null) {
                    diter.dispose();
                }
                if (fs != null) {
                    fs.dispose();
                }
            }
        }
        return resp;
    }

    private static interface FeatureSelectionOperation {
        public void doWithSelection(FeatureSelection var1, int var2, int var3) throws DataException;
    }
}

