/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.gvsig.fmap.dal.DataStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.FeatureTableModel;
import org.gvsig.fmap.dal.swing.JFeatureTable;
import org.gvsig.fmap.dal.swing.impl.featuretable.FeatureTable;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTablePanel
extends JPanel
implements Observer,
JFeatureTable {
    private static final Logger logger = LoggerFactory.getLogger(FeatureTablePanel.class);
    private static final long serialVersionUID = -9199073063283531216L;
    private FeatureTable table = null;
    private JScrollPane jScrollPane = null;
    private JPanel selectionPanel;
    private JLabel selectionLabel;

    public FeatureTablePanel(FeatureTableModel tableModel, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.table = new FeatureTable(tableModel);
        this.initComonents();
        tableModel.getFeatureStore().addObserver((Observer)this);
        tableModel.getFeatureSelection().addObserver((Observer)this);
        tableModel.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ChangeSelection".equals(e.getActionCommand())) {
                    FeatureTablePanel.this.featureSelectionChanged();
                }
            }
        });
    }

    private void featureSelectionChanged() {
        ((FeatureTableModel)this.table.getModel()).getFeatureSelection().addObserver((Observer)this);
    }

    private void initComonents() {
        this.setLayout(new BorderLayout());
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setViewportView(this.table);
        this.createTheRowHeader();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("RowHeight".equalsIgnoreCase(pce.getPropertyName())) {
                    FeatureTablePanel.this.createTheRowHeader();
                }
            }
        });
        this.getFeatureTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                FeatureTablePanel.this.createTheRowHeader();
            }
        });
        this.selectionLabel = new JLabel();
        this.selectionLabel.setText(this.getSelectionLabel());
        this.selectionPanel = new JPanel();
        this.selectionPanel.add((Component)this.selectionLabel, "East");
        this.add((Component)this.jScrollPane, "Center");
        this.add((Component)this.selectionPanel, "South");
        ToolsSwingLocator.getToolsSwingManager().createTableColumnAdjuster((JTable)this.table);
    }

    public void addColumnSelectionListener(ActionListener listener) {
        this.table.addColumnSelectionListener(listener);
    }

    public void fireColumnSelection(ActionEvent e) {
        this.table.fireColumnSelection(e);
    }

    public void setModel(TableModel dataModel) {
        this.table.setModel(dataModel);
    }

    public TableModel getModel() {
        return this.table.getModel();
    }

    public FeatureTableModel getFeatureTableModel() {
        return (FeatureTableModel)this.table.getModel();
    }

    public int getSelectedColumnCount() {
        return this.table.getSelectedColumnCount();
    }

    public int[] getSelectedColumns() {
        return this.table.getSelectedColumns();
    }

    private String getSelectionLabel() {
        String label = this.getFeatureTableModel().getSelectionCount() + " / " + this.getFeatureTableModel().getRowCount() + " " + Messages.getText((String)"registros_seleccionados_total") + ".";
        return label;
    }

    private void createTheRowHeader() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FeatureTablePanel.this.table.getRowCount() < 1) {
                    FeatureTablePanel.this.jScrollPane.setRowHeaderView(null);
                    return;
                }
                AbstractListModel lm = new AbstractListModel(){
                    private static final long serialVersionUID = -310252331647118271L;

                    @Override
                    public int getSize() {
                        return FeatureTablePanel.this.table.getRowCount();
                    }

                    @Override
                    public Object getElementAt(int index) {
                        return String.valueOf(index + 1);
                    }
                };
                JList rowHeader = new JList(lm);
                rowHeader.setBackground(FeatureTablePanel.this.table.getTableHeader().getBackground());
                rowHeader.setCellRenderer(new RowHeaderRenderer(FeatureTablePanel.this.table, rowHeader));
                FeatureTablePanel.this.jScrollPane.setRowHeaderView(rowHeader);
            }
        });
    }

    public JTable getJTable() {
        return this.table;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void update(Observable observable, Object notification) {
        String type;
        if (observable instanceof FeatureSelection) {
            this.repaint();
            return;
        }
        if (observable instanceof FeatureStore && "after_SelectionChange_DataStore".equals(type = ((DataStoreNotification)notification).getType())) {
            this.selectionLabel.setText(this.getSelectionLabel());
        }
    }

    public void setCurrent(int index) {
        logger.warn("setCurrent not implemented !!!!!!!!!!!!!!!!!!!!!!!!");
    }

    public void setVisibleStatusbar(boolean visible) {
        this.selectionPanel.setVisible(visible);
    }

    public boolean isVisibleStatusbar() {
        return this.selectionPanel.isVisible();
    }

    private static class RowHeaderRenderer
    extends JButton
    implements ListCellRenderer {
        private static final long serialVersionUID = -3811876981965840126L;
        private JTable table = null;
        private final Dimension dimension = new Dimension();
        private final JList rowHeader;

        RowHeaderRenderer(JTable table, JList rowHeader) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            this.table = table;
            this.rowHeader = rowHeader;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            this.setPreferredSize(null);
            this.dimension.height = this.table.getRowHeight(index);
            this.dimension.width = this.getPreferredSize().width + 10;
            this.setPreferredSize(this.dimension);
            return this;
        }
    }
}

