/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.swing.FeatureTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.FeaturesDataReloadException;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.renders.GetFeatureAtException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.ComplexNotification;
import org.gvsig.tools.observer.ComplexObserver;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureTableModel
extends AbstractTableModel
implements FeatureTableModel,
ComplexObserver {
    private static final long serialVersionUID = -8223987814719746492L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultFeatureTableModel.class);
    private List<String> columnNames;
    private List<String> visibleColumnNames;
    private List<String> visibleColumnNamesOriginal;
    private Map<String, String> name2Alias;
    private Map<String, String> name2AliasOriginal;
    private Map<String, String> patterns = null;
    private Locale localeOfData;
    private final FeaturePagingHelper featurePager;
    private EditableFeature editableFeature;
    private boolean selectionLocked = false;
    private final DelayAction delayAction = new DelayAction();
    private FeatureSelection selection = null;
    private Set<ActionListener> changeListeners = null;

    public DefaultFeatureTableModel(FeaturePagingHelper featurePager) {
        this.featurePager = featurePager;
        this.localeOfData = Locale.getDefault();
        this.initialize();
    }

    private void initialize() {
        this.getFeatureStore().addObserver((Observer)this);
        int columns = this.getOriginalColumnCount();
        this.columnNames = new ArrayList<String>(columns);
        this.visibleColumnNames = new ArrayList<String>(columns);
        for (int i = 0; i < columns; ++i) {
            FeatureAttributeDescriptor descriptor = this.getInternalColumnDescriptor(i);
            String columnName = descriptor.getName();
            this.columnNames.add(columnName);
            if (descriptor.getType() == 66) continue;
            this.visibleColumnNames.add(columnName);
        }
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
        this.name2Alias = new HashMap<String, String>(columns);
        this.name2AliasOriginal = new HashMap<String, String>(columns);
        this.initializeFormatingPatterns();
        this.updatePagerWithHiddenColums();
    }

    private void initializeFormatingPatterns() {
        int columns = this.getOriginalColumnCount();
        this.patterns = new HashMap<String, String>();
        block6: for (int i = 0; i < columns; ++i) {
            FeatureAttributeDescriptor descriptor = this.getInternalColumnDescriptor(i);
            String columnName = descriptor.getName();
            switch (descriptor.getDataType().getType()) {
                case 2: 
                case 4: 
                case 5: {
                    String defaultIntegerPattern = "#,##0";
                    this.patterns.put(columnName, defaultIntegerPattern);
                    continue block6;
                }
                case 7: {
                    String defaultDoublePattern = "#,##0.0000000000";
                    this.patterns.put(columnName, defaultDoublePattern);
                    continue block6;
                }
                case 6: {
                    String defaultFloatPattern = "#,##0.0000";
                    this.patterns.put(columnName, defaultFloatPattern);
                    continue block6;
                }
                case 9: {
                    String defaultDatePattern = new SimpleDateFormat().toPattern();
                    this.patterns.put(columnName, defaultDatePattern);
                    continue block6;
                }
                default: {
                    this.patterns.put(columnName, null);
                }
            }
        }
    }

    private void updatePagerWithHiddenColums() {
    }

    public FeaturePagingHelper getFeaturePager() {
        return this.featurePager;
    }

    public FeatureQuery getFeatureQuery() {
        return this.getFeaturePager().getFeatureQuery();
    }

    public FeatureType getFeatureType() {
        return this.getFeaturePager().getFeatureType();
    }

    public FeatureStore getFeatureStore() {
        return this.getFeaturePager().getFeatureStore();
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnNames.size();
    }

    public int getOriginalColumnCount() {
        FeatureType featureType = this.getFeatureType();
        return featureType.size();
    }

    @Override
    public String getColumnName(int column) {
        String columName = this.getOriginalColumnName(column);
        return this.getColumnAlias(columName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        FeatureAttributeDescriptor attributeDesc = this.getInternalColumnDescriptor(originalIndex);
        if (attributeDesc == null) {
            return super.getColumnClass(originalIndex);
        }
        Class<?> clazz = attributeDesc.getObjectClass();
        return clazz == null ? super.getColumnClass(originalIndex) : clazz;
    }

    public FeatureAttributeDescriptor getColumnDescriptor(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        return this.getInternalColumnDescriptor(originalIndex);
    }

    protected FeatureAttributeDescriptor getInternalColumnDescriptor(int columnIndex) {
        FeatureType featureType = this.getFeatureType();
        if (featureType == null) {
            return null;
        }
        return featureType.getAttributeDescriptor(columnIndex);
    }

    public String getOriginalColumnName(int column) {
        return this.getInternalColumnDescriptor(column).getName();
    }

    public void setColumnVisible(String name, boolean visible) {
        if (!this.columnNames.contains(name)) {
            throw new InvalidParameterException(name);
        }
        if (visible) {
            if (!this.visibleColumnNames.contains(name)) {
                this.visibleColumnNames.add(name);
                this.setVisibleColumns(this.visibleColumnNames);
            }
        } else if (this.visibleColumnNames.contains(name)) {
            this.visibleColumnNames.remove(name);
            this.setVisibleColumns(this.visibleColumnNames);
            this.fireTableStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatureType(FeatureType featureType) {
        String colName;
        ArrayList<String> newColumns = new ArrayList<String>();
        ArrayList<String> renamedColumnsNewName = new ArrayList<String>();
        for (FeatureAttributeDescriptor fad : featureType) {
            colName = fad.getName();
            if (this.columnNames.contains(colName)) continue;
            if (fad instanceof EditableFeatureAttributeDescriptor) {
                EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)fad;
                if (efad.getOriginalName() != null) {
                    if (!this.columnNames.contains(efad.getOriginalName())) {
                        newColumns.add(colName);
                        continue;
                    }
                    renamedColumnsNewName.add(colName);
                    continue;
                }
                newColumns.add(colName);
                continue;
            }
            newColumns.add(colName);
        }
        this.columnNames.clear();
        for (FeatureAttributeDescriptor fad : featureType) {
            colName = fad.getName();
            this.columnNames.add(colName);
            if (this.visibleColumnNames.contains(colName) || !newColumns.contains(colName) && !renamedColumnsNewName.contains(colName) || fad.getType() == 66) continue;
            this.visibleColumnNames.add(colName);
            this.visibleColumnNamesOriginal.add(colName);
        }
        this.visibleColumnNames = this.intersectKeepOrder(this.columnNames, this.visibleColumnNames);
        this.visibleColumnNamesOriginal = this.intersectKeepOrder(this.columnNames, this.visibleColumnNamesOriginal);
        this.name2Alias.keySet().retainAll(this.columnNames);
        this.name2AliasOriginal.keySet().retainAll(this.columnNames);
        this.initializeFormatingPatterns();
        this.getFeatureQuery().setFeatureType(featureType);
        this.reloadFeatures();
        this.selectionLocked = true;
        try {
            this.fireTableStructureChanged();
        }
        catch (Exception e) {
            logger.warn("Couldn't reload changed table");
        }
        finally {
            this.selectionLocked = false;
        }
    }

    private void reloadFeatures() {
        try {
            this.getFeaturePager().reload();
        }
        catch (BaseException ex) {
            throw new FeaturesDataReloadException(ex);
        }
    }

    private List<String> intersectKeepOrder(List<String> lista, List<String> listb) {
        ArrayList<String> resp = new ArrayList<String>();
        resp.addAll(lista);
        resp.retainAll(listb);
        return resp;
    }

    public void setVisibleColumns(List<String> names) {
        this.visibleColumnNames = new ArrayList<String>(names.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String columnName = this.columnNames.get(i);
            if (!names.contains(columnName)) continue;
            this.visibleColumnNames.add(columnName);
        }
        this.updatePagerWithHiddenColums();
        this.fireTableStructureChanged();
    }

    protected String[] getHiddenColumnNames() {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        hiddenColumns.addAll(this.columnNames);
        for (int i = 0; i < this.visibleColumnNames.size(); ++i) {
            String columnName = this.visibleColumnNames.get(i);
            hiddenColumns.remove(columnName);
        }
        if (hiddenColumns.size() < 1) {
            return null;
        }
        return hiddenColumns.toArray(new String[hiddenColumns.size()]);
    }

    public void setAllVisible() {
        this.visibleColumnNames.clear();
        this.visibleColumnNames.addAll(this.columnNames);
        this.fireTableStructureChanged();
    }

    public void setColumnOrder(String name, boolean ascending) throws BaseException {
        FeatureQueryOrder order = this.getFeatureQuery().getOrder();
        order.clear();
        order.add(name, ascending);
        this.getFeaturePager().reload();
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1));
    }

    @Override
    public int getRowCount() {
        try {
            long totalSize = this.getFeaturePager().getTotalSize();
            if (totalSize > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totalSize;
        }
        catch (ConcurrentDataModificationException e) {
            logger.debug("Error while getting the total size of the set", (Throwable)e);
            return 0;
        }
    }

    public boolean isColumnVisible(String name) {
        return this.visibleColumnNames.contains(name);
    }

    public String getColumnAlias(String name) {
        String alias = this.name2Alias.get(name);
        return alias == null ? name : alias;
    }

    public void setColumnAlias(String name, String alias) {
        this.name2Alias.put(name, alias);
        this.fireTableStructureChanged();
    }

    public int getOriginalColumnIndex(int columnIndex) {
        String columnName = this.visibleColumnNames.get(columnIndex);
        return this.columnNames.indexOf(columnName);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Feature feature = this.getFeatureAt(rowIndex);
        return feature == null ? null : this.getFeatureValue(feature, columnIndex);
    }

    public Feature getFeatureAt(int rowIndex) {
        try {
            return this.getFeaturePager().getFeatureAt((long)rowIndex);
        }
        catch (BaseException ex) {
            throw new GetFeatureAtException(rowIndex, ex);
        }
    }

    protected Object getFeatureValue(Feature feature, int columnIndex) {
        int realColumnIndex = this.getOriginalColumnIndex(columnIndex);
        return feature.get(realColumnIndex);
    }

    protected EditableFeature setFeatureValue(Feature feature, int columnIndex, Object value) {
        int realColumnIndex = this.getOriginalColumnIndex(columnIndex);
        EditableFeature editableFeature = feature.getEditable();
        editableFeature.set(realColumnIndex, value);
        return editableFeature;
    }

    public void acceptChanges() {
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
        this.name2AliasOriginal = new HashMap<String, String>(this.name2Alias);
    }

    public void cancelChanges() {
        this.visibleColumnNames = new ArrayList<String>(this.visibleColumnNamesOriginal);
        this.name2Alias = new HashMap<String, String>(this.name2AliasOriginal);
        this.fireTableStructureChanged();
    }

    public String getColumnFormattingPattern(int column) {
        String columnName = this.visibleColumnNames.get(column);
        return this.getColumnFormattingPattern(columnName);
    }

    public String getColumnFormattingPattern(String columnName) {
        String pattern = this.patterns.get(columnName);
        return pattern;
    }

    public void setColumnFormattingPattern(String columnName, String pattern) {
        this.patterns.put(columnName, pattern);
    }

    public Locale getLocaleOfData() {
        return this.localeOfData;
    }

    public void setLocaleOfData(Locale locale) {
        this.localeOfData = locale;
    }

    public boolean isSelectionLocked() {
        if (!this.getFeatureType().supportReferences()) {
            return true;
        }
        return this.selectionLocked;
    }

    public boolean isSelectionUp() {
        return this.getFeaturePager().isSelectionUp();
    }

    public void setSelectionUp(boolean selectionUp) {
        this.getFeaturePager().setSelectionUp(selectionUp);
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1));
    }

    private void reloadIfFeatureCountChanged(Feature feature) {
        if (this.editableFeature == null || !this.editableFeature.equals(feature)) {
            this.reloadFeatures();
            this.selectionLocked = true;
            try {
                this.fireTableDataChanged();
            }
            catch (Exception e) {
                logger.warn("Couldn't reload changed table");
            }
            finally {
                this.selectionLocked = false;
            }
        }
    }

    private void reloadIfFeatureUpdated(Feature feature) {
        if (this.editableFeature == null || !this.editableFeature.equals(feature)) {
            this.reloadFeatures();
            this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount()));
        }
    }

    private void reloadIfTypeChanged(FeatureType updatedType) {
        if (updatedType != null && updatedType.getId().equals(this.getFeatureType().getId())) {
            this.setFeatureType(updatedType);
        }
    }

    private void reloadAll() {
        this.reloadFeatureType();
    }

    private void reloadFeatureType() {
        try {
            FeatureType featureType = this.getFeaturePager().getFeatureType();
            FeatureStore store = this.getFeaturePager().getFeatureStore();
            this.setFeatureType(store.getFeatureType(featureType.getId()));
        }
        catch (DataException e) {
            throw new FeaturesDataReloadException(e);
        }
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof ComplexNotification) {
            this.delayAction.nextState(1);
        } else if (observable.equals(this.getFeatureStore()) && notification instanceof FeatureStoreNotification) {
            FeatureStoreNotification fsNotification = (FeatureStoreNotification)notification;
            String type = fsNotification.getType();
            if ("after_Delete_Feature".equals(type) || "after_Insert_Feature".equals(type)) {
                this.delayAction.nextState(2, fsNotification.getFeature());
            } else if ("after_Update_Feature".equals(type)) {
                this.delayAction.nextState(4, fsNotification.getFeature());
            } else if ("after_Update_Type".equals(type)) {
                this.delayAction.nextState(8, (FeatureType)fsNotification.getFeatureType());
            } else if ("Transform_Change".equals(type) || "after_Undo_DataStore".equals(type) || "after_Redo_DataStore".equals(type) || "after_refresh".equals(type)) {
                this.delayAction.nextState(1);
            } else if ("after_FinishEditing_DataStore".equals(type) || "after_StartEditing_DataStore".equals(type) || "after_CancelEditing_DataStore".equals(type)) {
                this.delayAction.nextState(16, (FeatureType)fsNotification.getFeatureType());
            } else if ("after_SelectionChange_DataStore".equals(type) && this.isSelectionUp()) {
                this.setSelectionUp(true);
                this.delayAction.nextState(32);
            }
        }
    }

    public FeatureSelection getFeatureSelection() {
        if (this.selection == null) {
            try {
                return this.getFeatureStore().getFeatureSelection();
            }
            catch (Exception e) {
                logger.warn("Error getting the selection", (Throwable)e);
            }
        }
        return this.selection;
    }

    public void setFeatureSelection(FeatureSelection selection) {
        this.selection = selection;
        this.featurePager.setSelection(selection);
        this.fireChangeListeners(new ActionEvent(this, 0, "ChangeSelection"));
    }

    public void addChangeListener(ActionListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet<ActionListener>();
        }
        this.changeListeners.add(listener);
    }

    public void fireChangeListeners(ActionEvent event) {
        if (this.changeListeners == null) {
            return;
        }
        for (ActionListener listener : this.changeListeners) {
            try {
                listener.actionPerformed(event);
            }
            catch (Exception exception) {}
        }
    }

    public int getSelectionCount() {
        try {
            FeatureSelection selection = this.getFeatureSelection();
            return (int)selection.getSize();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't get selection of the FeatureTableModel", ex);
        }
    }

    private class DelayAction
    extends Timer
    implements ActionListener,
    Runnable {
        private static final int STATE_NONE = 0;
        private static final int STATE_NEED_RELOADALL = 1;
        private static final int STATE_NEED_RELOAD_IF_FEATURE_COUNT_CHANGED = 2;
        private static final int STATE_NEED_RELOAD_IF_FEATURE_UPDATED = 4;
        private static final int STATE_NEED_RELOAD_IF_FEATURE_TYPE_CHANGED = 8;
        private static final int STATE_NEED_RELOAD_FEATURE_TYPE = 16;
        private static final int STATE_NEED_SELECTION_UP = 32;
        private static final int STATE_NEED_RELOAD_ALL_FEATURES = 64;
        private static final long serialVersionUID = -5692569125344166705L;
        private int state;
        private Feature feature;
        private FeatureType featureType;
        private boolean isSelecctionUp;

        public DelayAction() {
            super(1000, null);
            this.state = 0;
            this.setRepeats(false);
            this.reset();
            this.addActionListener(this);
        }

        private void reset() {
            this.state = 0;
            this.isSelecctionUp = false;
            this.feature = null;
            this.featureType = null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.run();
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            this.stop();
            logger.info("DelayAction.run[" + this.state + "] begin");
            switch (this.state) {
                case 1: {
                    DefaultFeatureTableModel.this.reloadAll();
                    break;
                }
                case 2: {
                    DefaultFeatureTableModel.this.reloadIfFeatureCountChanged(this.feature);
                    break;
                }
                case 4: {
                    DefaultFeatureTableModel.this.reloadIfFeatureUpdated(this.feature);
                    break;
                }
                case 8: {
                    DefaultFeatureTableModel.this.reloadIfTypeChanged(this.featureType);
                    break;
                }
                case 16: {
                    DefaultFeatureTableModel.this.reloadFeatureType();
                    DefaultFeatureTableModel.this.updatePagerWithHiddenColums();
                    break;
                }
                case 64: {
                    DefaultFeatureTableModel.this.reloadFeatures();
                    DefaultFeatureTableModel.this.fireTableChanged(new TableModelEvent(DefaultFeatureTableModel.this, 0, DefaultFeatureTableModel.this.getRowCount()));
                    break;
                }
            }
            if (this.isSelecctionUp) {
                DefaultFeatureTableModel.this.getFeaturePager().setSelectionUp(true);
            }
            this.reset();
            logger.info("DelayAction.run[" + this.state + "] end");
        }

        public void nextState(int nextstate) {
            this.nextState(nextstate, null, null);
        }

        public void nextState(int nextstate, Feature feature) {
            this.nextState(nextstate, feature, null);
        }

        public void nextState(int nextstate, FeatureType featureType) {
            this.nextState(nextstate, null, featureType);
        }

        public void nextState(int nextstate, Feature feature, FeatureType featureType) {
            this.feature = feature;
            this.featureType = featureType;
            block0 : switch (nextstate) {
                case 1: 
                case 2: 
                case 4: {
                    switch (this.state) {
                        case 1: 
                        case 2: {
                            this.state = 1;
                            break block0;
                        }
                        case 8: 
                        case 16: {
                            this.state = 16;
                            break block0;
                        }
                        case 4: 
                        case 64: {
                            this.state = 64;
                            break block0;
                        }
                        case 32: {
                            this.state = nextstate;
                            this.isSelecctionUp = true;
                            break block0;
                        }
                    }
                    this.state = nextstate;
                    break;
                }
                case 8: 
                case 16: {
                    switch (this.state) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 64: {
                            this.state = 16;
                            break block0;
                        }
                        case 32: {
                            this.state = nextstate;
                            this.isSelecctionUp = true;
                            break block0;
                        }
                    }
                    this.state = nextstate;
                    break;
                }
                case 32: {
                    switch (this.state) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: {
                            this.isSelecctionUp = true;
                            break block0;
                        }
                    }
                    this.state = nextstate;
                    this.isSelecctionUp = true;
                    break;
                }
                default: {
                    this.state = 0;
                }
            }
            if (this.state != 0) {
                this.start();
            }
        }
    }
}

