/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable.table;

import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.swing.FeatureTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.DynFieldFacadeOfAFeatureAttributeDescriptor;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.ComplexObserver;
import org.gvsig.tools.observer.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyFeatureTableModel
extends AbstractTableModel
implements FeatureTableModel,
ComplexObserver {
    private static final long serialVersionUID = -8223987814719746492L;
    private static final Logger logger = LoggerFactory.getLogger(EmptyFeatureTableModel.class);
    private List<String> columnNames;
    private List<String> visibleColumnNames;
    private List<String> visibleColumnNamesOriginal;
    private Map<String, String> name2Alias;
    private Map<String, String> name2AliasOriginal;
    private Map<String, String> patterns = null;
    private Locale localeOfData;
    private DynStruct struct = null;

    public EmptyFeatureTableModel(DynStruct struct) {
        this.struct = struct;
        this.localeOfData = Locale.getDefault();
        this.initialize();
    }

    private void initialize() {
        int i;
        int columns = this.getOriginalColumnCount();
        this.columnNames = new ArrayList<String>(columns);
        this.visibleColumnNames = new ArrayList<String>(columns);
        for (i = 0; i < columns; ++i) {
            String columnName = super.getColumnName(i);
            this.columnNames.add(columnName);
            FeatureAttributeDescriptor descriptor = this.getInternalColumnDescriptor(i);
            if (descriptor.getType() == 66) continue;
            this.visibleColumnNames.add(columnName);
        }
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
        this.name2Alias = new HashMap<String, String>(columns);
        this.name2AliasOriginal = new HashMap<String, String>(columns);
        this.patterns = new HashMap<String, String>();
        block6: for (i = 0; i < columns; ++i) {
            FeatureAttributeDescriptor descriptor = this.getInternalColumnDescriptor(i);
            String columnName = descriptor.getName();
            switch (descriptor.getDataType().getType()) {
                case 2: 
                case 4: 
                case 5: {
                    String defaultIntegerPattern = "#,##0";
                    this.patterns.put(columnName, defaultIntegerPattern);
                    continue block6;
                }
                case 6: 
                case 7: {
                    String defaultDecimalPattern = "#,##0.000";
                    this.patterns.put(columnName, defaultDecimalPattern);
                    continue block6;
                }
                case 9: {
                    String defaultDatePattern = new SimpleDateFormat().toPattern();
                    this.patterns.put(columnName, defaultDatePattern);
                    continue block6;
                }
                default: {
                    this.patterns.put(columnName, null);
                }
            }
        }
        this.updatePagerWithHiddenColums();
    }

    private void updatePagerWithHiddenColums() {
        FeatureQuery query = this.getFeaturePager().getFeatureQuery();
        if (this.getFeaturePager().getFeatureStore().isEditing()) {
            if (query.hasConstantsAttributeNames()) {
                query.clearConstantsAttributeNames();
            }
        } else {
            query.setConstantsAttributeNames(this.getHiddenColumnNames());
        }
        try {
            this.getFeaturePager().reload();
        }
        catch (BaseException ex) {
            logger.warn("Can't reload paging-helper.", (Throwable)ex);
        }
    }

    public FeaturePagingHelper getFeaturePager() {
        return null;
    }

    public FeatureQuery getFeatureQuery() {
        return null;
    }

    public FeatureType getFeatureType() {
        return null;
    }

    public FeatureStore getFeatureStore() {
        return null;
    }

    public FeatureSelection getFeatureSelection() {
        return null;
    }

    public void setFeatureSelection(FeatureSelection selection) {
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnNames.size();
    }

    public int getOriginalColumnCount() {
        return this.struct.getDynFields().length;
    }

    @Override
    public String getColumnName(int column) {
        String columName = this.getOriginalColumnName(column);
        return this.getColumnAlias(columName);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        FeatureAttributeDescriptor attributeDesc = this.getInternalColumnDescriptor(originalIndex);
        if (attributeDesc == null) {
            return super.getColumnClass(originalIndex);
        }
        Class<?> clazz = attributeDesc.getObjectClass();
        return clazz == null ? super.getColumnClass(originalIndex) : clazz;
    }

    public FeatureAttributeDescriptor getColumnDescriptor(int columnIndex) {
        int originalIndex = this.getOriginalColumnIndex(columnIndex);
        return this.getInternalColumnDescriptor(originalIndex);
    }

    protected FeatureAttributeDescriptor getInternalColumnDescriptor(int columnIndex) {
        return new DynFieldFacadeOfAFeatureAttributeDescriptor(this.struct.getDynFields()[columnIndex]);
    }

    public String getOriginalColumnName(int column) {
        return this.struct.getDynFields()[column].getName();
    }

    public void setColumnVisible(String name, boolean visible) {
        if (!this.columnNames.contains(name)) {
            throw new InvalidParameterException(name);
        }
        if (visible && !this.visibleColumnNames.contains(name)) {
            this.visibleColumnNames.add(name);
            this.setVisibleColumns(this.visibleColumnNames);
        } else {
            this.visibleColumnNames.remove(name);
            this.setVisibleColumns(this.visibleColumnNames);
            this.fireTableStructureChanged();
        }
    }

    public void setFeatureType(FeatureType featureType) {
    }

    private void setVisibleColumns(List<String> names) {
        this.visibleColumnNames = new ArrayList<String>(names.size());
        for (String columnName : this.columnNames) {
            if (!names.contains(columnName)) continue;
            this.visibleColumnNames.add(columnName);
        }
        this.updatePagerWithHiddenColums();
        this.fireTableStructureChanged();
    }

    protected String[] getHiddenColumnNames() {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        hiddenColumns.addAll(this.columnNames);
        for (String columnName : this.visibleColumnNames) {
            hiddenColumns.remove(columnName);
        }
        if (hiddenColumns.size() < 1) {
            return null;
        }
        return hiddenColumns.toArray(new String[hiddenColumns.size()]);
    }

    public void setAllVisible() {
        this.visibleColumnNames.clear();
        this.visibleColumnNames.addAll(this.columnNames);
        this.fireTableStructureChanged();
    }

    public void setColumnOrder(String name, boolean ascending) throws BaseException {
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    public boolean isColumnVisible(String name) {
        return this.visibleColumnNames.contains(name);
    }

    public String getColumnAlias(String name) {
        String alias = this.name2Alias.get(name);
        return alias == null ? name : alias;
    }

    public void setColumnAlias(String name, String alias) {
        this.name2Alias.put(name, alias);
        this.fireTableStructureChanged();
    }

    public int getOriginalColumnIndex(int columnIndex) {
        String columnName = this.visibleColumnNames.get(columnIndex);
        return this.columnNames.indexOf(columnName);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    public Feature getFeatureAt(int rowIndex) {
        return null;
    }

    protected Object getFeatureValue(Feature feature, int columnIndex) {
        return null;
    }

    protected EditableFeature setFeatureValue(Feature feature, int columnIndex, Object value) {
        return null;
    }

    public void acceptChanges() {
        this.visibleColumnNamesOriginal = new ArrayList<String>(this.visibleColumnNames);
        this.name2AliasOriginal = new HashMap<String, String>(this.name2Alias);
    }

    public void cancelChanges() {
        this.visibleColumnNames = new ArrayList<String>(this.visibleColumnNamesOriginal);
        this.name2Alias = new HashMap<String, String>(this.name2AliasOriginal);
        this.fireTableStructureChanged();
    }

    public String getColumnFormattingPattern(int column) {
        String columnName = this.visibleColumnNames.get(column);
        return this.getColumnFormattingPattern(columnName);
    }

    public String getColumnFormattingPattern(String columnName) {
        String pattern = this.patterns.get(columnName);
        return pattern;
    }

    public void setColumnFormattingPattern(String columnName, String pattern) {
        this.patterns.put(columnName, pattern);
    }

    public Locale getLocaleOfData() {
        return this.localeOfData;
    }

    public void setLocaleOfData(Locale locale) {
        this.localeOfData = locale;
    }

    public boolean isSelectionLocked() {
        return false;
    }

    public boolean isSelectionUp() {
        return false;
    }

    public void setSelectionUp(boolean selectionUp) {
    }

    public void update(Observable observable, Object notification) {
    }

    public int getSelectionCount() {
        return 0;
    }

    public void addChangeListener(ActionListener listener) {
    }
}

