/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureAttributeTreeModel
implements TreeModel,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureAttributeTreeModel.class);
    private final FeatureQuery query;
    private final Set<String> stores;
    private final DefaultNode root;
    private final Predicate<FeatureAttributeDescriptor> filterByDataType;
    private boolean showRelations;

    public FeatureAttributeTreeModel(FeatureStore store, FeatureType featureType, boolean showRelations, Predicate<FeatureAttributeDescriptor> filterByDataType) {
        this(store, featureType, showRelations, filterByDataType, null);
    }

    public FeatureAttributeTreeModel(FeatureStore store, FeatureType featureType, boolean showRelations, Predicate<FeatureAttributeDescriptor> filterByDataType, FeatureQuery query) {
        FeatureExtraColumns extraColumns;
        this.query = query;
        this.filterByDataType = filterByDataType == null ? Search.ALL_FILTER : filterByDataType;
        if (featureType == null) {
            featureType = store.getDefaultFeatureTypeQuietly();
        }
        ArrayList<FeatureAttributeDescriptor> extra = null;
        if (this.query != null && !(extraColumns = this.query.getExtraColumns()).isEmpty()) {
            extra = new ArrayList<FeatureAttributeDescriptor>();
            for (FeatureAttributeDescriptor extraColumn : extraColumns) {
                extra.add(extraColumn);
            }
        }
        Search featureTypeSearch = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
        List attributes = featureTypeSearch.getOrderedAttributes(filterByDataType, Search.LABEL_ORDER, -1, extra);
        this.root = new DefaultNode(store.getName(), () -> store, attributes);
        this.stores = new HashSet<String>();
        this.showRelations = showRelations;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object parent) {
        DefaultNode node = (DefaultNode)parent;
        return node.getChildren().size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        DefaultNode node = (DefaultNode)parent;
        if (node.getChildren() == null) {
            return null;
        }
        return node.getChildren().get(index);
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DefaultNode)node).isLeaf();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        try {
            DefaultNode parantNode = (DefaultNode)parent;
            DefaultNode childNode = (DefaultNode)child;
            int index = 0;
            for (Node node : parantNode.getChildren()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)((FeatureAttributeDescriptor)childNode.getValue()).getName(), (CharSequence)((FeatureAttributeDescriptor)node.getValue()).getName())) {
                    return index;
                }
                ++index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    private class DefaultNode
    extends LabeledValueImpl<FeatureAttributeDescriptor>
    implements Node {
        private List<Node> childs;
        private Supplier<FeatureStore> store;
        private final int type;

        public DefaultNode(String name, Supplier<FeatureStore> store, List<Search.OrderedAttribute> attributes) {
            super(name, null);
            DisposeUtils.bind(store);
            this.store = store;
            this.type = 0;
            this.childs = new ArrayList<Node>();
            for (Search.OrderedAttribute attribute : attributes) {
                this.childs.add(new DefaultNode(store, attribute.getDescriptor(), attribute.getType()));
            }
        }

        private DefaultNode(Supplier<FeatureStore> store, FeatureAttributeDescriptor attribute, int type) {
            super(attribute.getLocalizedLabel(), (Object)attribute);
            DisposeUtils.bind(store);
            this.store = store;
            this.type = type;
            this.childs = null;
        }

        public String getLabel(int type) {
            String theLabel;
            FeatureAttributeDescriptor attrdesc = (FeatureAttributeDescriptor)this.getValue();
            if (attrdesc == null) {
                theLabel = super.getLabel();
            } else {
                String tableName = null;
                if (attrdesc.isForeingKey()) {
                    ForeingKey foreingKey = attrdesc.getForeingKey();
                    tableName = foreingKey.getTableName();
                }
                theLabel = DALSwingLocator.getDataSwingManager().getAttributeDescriptorLabel(attrdesc, tableName);
            }
            switch (type) {
                case 0: {
                    break;
                }
                case 2: {
                    theLabel = "<html><b>" + theLabel + "</b></html>";
                    break;
                }
                case 1: {
                    theLabel = "<html><i><b>" + theLabel + "</b></i></html>";
                }
            }
            return theLabel;
        }

        public String getLabel() {
            return this.getLabel(this.type);
        }

        @Override
        public FeatureStore getFeatureStore() {
            return this.store.get();
        }

        @Override
        public boolean isRoot() {
            return this.getValue() == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Node> getChildren() {
            if (FeatureAttributeTreeModel.this.showRelations && this.childs == null) {
                FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.getValue();
                try {
                    this.childs = Collections.EMPTY_LIST;
                    switch (descriptor.getRelationType()) {
                        case 1: 
                        case 2: {
                            if (!((FeatureAttributeDescriptor)this.getValue()).isForeingKey()) break;
                            ForeingKey foreingKey = ((FeatureAttributeDescriptor)this.getValue()).getForeingKey();
                            ForeingKey.ContextForeingKey context = foreingKey.createContext();
                            try {
                                StoresRepository storesRepository = foreingKey.getStoresRepository(context);
                                String tableName = foreingKey.getTableName();
                                Supplier<FeatureStore> theStore = () -> (FeatureStore)storesRepository.getStore(tableName);
                                FeatureType featureType = storesRepository.getFeatureType(tableName);
                                OpenFeatureStoreParameters theStoreParams = (OpenFeatureStoreParameters)storesRepository.get((Object)tableName);
                                if (featureType == null || theStoreParams == null) {
                                    this.childs = Collections.EMPTY_LIST;
                                } else {
                                    String fullName = theStoreParams.getSourceId();
                                    if (FeatureAttributeTreeModel.this.stores.contains(fullName)) {
                                        this.childs = Collections.EMPTY_LIST;
                                    } else {
                                        Search featureTypeSearch = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
                                        List attributes = featureTypeSearch.getOrderedAttributes(FeatureAttributeTreeModel.this.filterByDataType, Search.LABEL_ORDER, -1);
                                        this.childs = new ArrayList<Node>();
                                        for (Search.OrderedAttribute attribute : attributes) {
                                            this.childs.add(new DefaultNode(theStore, attribute.getDescriptor(), attribute.getType()));
                                        }
                                        FeatureAttributeTreeModel.this.stores.add(fullName);
                                    }
                                }
                                break;
                            }
                            finally {
                                context.dispose();
                            }
                        }
                        case 3: 
                        case 4: {
                            Code.Callable caller;
                            FeatureAttributeEmulator emulator = descriptor.getFeatureAttributeEmulator();
                            if (!(emulator instanceof FeatureAttributeEmulatorExpression)) break;
                            FeatureAttributeEmulatorExpression emulatorExp = (FeatureAttributeEmulatorExpression)emulator;
                            Code code = emulatorExp.getExpression().getCode();
                            if (code.code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)(caller = (Code.Callable)code).name(), (CharSequence)"SELECT")) {
                                Codes parameters = caller.parameters();
                                String tableName = ((Code.Identifier)parameters.get(1)).name();
                                DataManager dataManager = DALLocator.getDataManager();
                                StoresRepository storesRepository = dataManager.getStoresRepository();
                                Supplier<FeatureStore> theStore = () -> (FeatureStore)storesRepository.getStore(tableName);
                                OpenFeatureStoreParameters theStoreParams = (OpenFeatureStoreParameters)storesRepository.get((Object)tableName);
                                FeatureType featureType = storesRepository.getFeatureType(tableName);
                                if (featureType == null || theStoreParams == null) {
                                    this.childs = Collections.EMPTY_LIST;
                                    break;
                                }
                                String fullName = theStoreParams.getSourceId();
                                if (FeatureAttributeTreeModel.this.stores.contains(fullName)) {
                                    this.childs = Collections.EMPTY_LIST;
                                    break;
                                }
                                Search featureTypeSearch = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
                                List attributes = featureTypeSearch.getOrderedAttributes(FeatureAttributeTreeModel.this.filterByDataType, Search.LABEL_ORDER, -1);
                                this.childs = new ArrayList<Node>();
                                for (Search.OrderedAttribute attribute : attributes) {
                                    this.childs.add(new DefaultNode(theStore, attribute.getDescriptor(), attribute.getType()));
                                }
                                FeatureAttributeTreeModel.this.stores.add(fullName);
                            }
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    this.childs = Collections.EMPTY_LIST;
                    LOGGER.warn("Can't get childs of " + descriptor.getName(), (Throwable)ex);
                }
            }
            return this.childs;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildren().isEmpty();
        }

        public void dispose() {
            this.store = null;
            if (this.childs != null) {
                for (Node child : this.childs) {
                    child.dispose();
                }
                this.childs = null;
            }
        }
    }

    public static interface Node
    extends LabeledValue<FeatureAttributeDescriptor>,
    Disposable {
        public FeatureStore getFeatureStore();

        public boolean isRoot();

        public boolean isLeaf();

        public List<Node> getChildren();
    }
}

