/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn;

import java.util.List;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AbstractAggregateOperation;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AggregateOperation;

public class SumAggregateOperation
extends AbstractAggregateOperation {
    double sum = 0.0;

    public boolean isApplicable(Object ... value) {
        return value[0] instanceof Number;
    }

    @Override
    public void reset() {
        this.sum = 0.0;
    }

    @Override
    public void perform(Object value) {
        if (value == null) {
            return;
        }
        this.sum += ((Number)value).doubleValue();
    }

    @Override
    public Object getValue() {
        return this.sum;
    }

    @Override
    public void fixAttributeDescriptor(EditableFeatureAttributeDescriptor descriptor) {
        super.fixAttributeDescriptor(descriptor);
        int type = descriptor.getType();
        switch (type) {
            case 2: 
            case 4: 
            case 5: {
                descriptor.setDataType(5);
                descriptor.setPrecision(19);
                descriptor.setScale(0);
                descriptor.setDefaultFormat("%d");
                break;
            }
            case 6: 
            case 7: {
                descriptor.setDataType(7);
                descriptor.setPrecision(16);
                descriptor.setScale(8);
                descriptor.setDefaultFormat("%f");
                break;
            }
            default: {
                if (descriptor.getScale() > 0) {
                    descriptor.setDataType(7);
                    descriptor.setPrecision(16);
                    descriptor.setScale(8);
                    descriptor.setDefaultFormat("%f");
                    break;
                }
                descriptor.setDataType(5);
                descriptor.setPrecision(19);
                descriptor.setScale(0);
                descriptor.setDefaultFormat("%d");
            }
        }
        descriptor.setRelationType(0);
        descriptor.getForeingKey().clean();
        descriptor.setAvailableValues((List)null);
    }

    public static class SumAggregateOperationFactory
    implements AggregateOperation.AggregateOperationFactory {
        public static final String NAME = "Summation";

        public String getName() {
            return NAME;
        }

        @Override
        public AggregateOperation create(Object ... os) {
            return new SumAggregateOperation();
        }

        public boolean isApplicable(Object ... value) {
            return Number.class.isAssignableFrom((Class)value[0]);
        }
    }
}

