/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.storesrepository;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryTreeModel;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynField;

public class StoresRepositoryControllerImpl
implements StoresRepositoryController {
    private JTree tree;
    private final StoresRepository rootRepository;
    private boolean useGeometryIcons;

    public StoresRepositoryControllerImpl(JTree tree) {
        this(tree, DALLocator.getDataManager().getStoresRepository());
    }

    public StoresRepositoryControllerImpl(JTree tree, StoresRepository rootRepository) {
        this.tree = tree;
        this.tree.setExpandsSelectedPaths(true);
        this.useGeometryIcons = false;
        this.rootRepository = rootRepository;
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.tree.setModel(dataSwingManager.createTreeModel(rootRepository));
        this.configureToolTip(this.tree);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (StoresRepositoryControllerImpl.this.useGeometryIcons) {
                    Icon icon = StoresRepositoryControllerImpl.this.getIconForItem(value);
                    this.setIcon(icon);
                }
                return label;
            }
        });
    }

    public void setUseGeometryIcons(boolean useGeometryIcons) {
        this.useGeometryIcons = useGeometryIcons;
    }

    public boolean getUseGeometryIcons() {
        return this.useGeometryIcons;
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.addTreeSelectionListener(tsl);
    }

    public DataStore getSelectedStore() {
        DataStore store;
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        StoresRepositoryTreeModel.StoresRepositoryElement element = (StoresRepositoryTreeModel.StoresRepositoryElement)path.getLastPathComponent();
        if (element == null) {
            return null;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        StoresRepositoryTreeModel.StoresRepositoryElement parentElement = (StoresRepositoryTreeModel.StoresRepositoryElement)parentPath.getLastPathComponent();
        if (!element.isStore()) {
            return null;
        }
        if (!parentElement.isRepository()) {
            return null;
        }
        StoresRepository repository = parentElement.getRepository();
        try {
            store = repository.getStore(element.getStoreName());
        }
        catch (Exception ex) {
            store = null;
        }
        return store;
    }

    public String getSelectedStoreId() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        StoresRepositoryTreeModel.StoresRepositoryElement element = (StoresRepositoryTreeModel.StoresRepositoryElement)path.getLastPathComponent();
        if (element == null) {
            return null;
        }
        if (!element.isStore()) {
            return null;
        }
        StringBuilder storeid = new StringBuilder();
        for (int i = 1; i < path.getPathCount(); ++i) {
            element = (StoresRepositoryTreeModel.StoresRepositoryElement)path.getPathComponent(i);
            if (i > 1) {
                storeid.append("/");
            }
            if (element.isRepository()) {
                storeid.append(element.getRepository().getID());
                continue;
            }
            storeid.append(element.getStoreName());
        }
        return storeid.toString();
    }

    public boolean setSelectedStore(FeatureStore store) {
        StoresRepositoryTreeModel.StoresRepositoryElement element;
        StoresRepositoryTreeModel.StoresRepositoryElement root;
        ArrayList path;
        TreeModel model = this.tree.getModel();
        if (!this.setSelectedStore(model, path = new ArrayList(), root = (StoresRepositoryTreeModel.StoresRepositoryElement)model.getRoot(), store.getParameters())) {
            return false;
        }
        int currentRow = 0;
        TreePath elementPath = null;
        for (int i = 0; i < path.size() && (elementPath = this.tree.getNextMatch((element = (StoresRepositoryTreeModel.StoresRepositoryElement)path.get(i)).getLabel(), currentRow, Position.Bias.Forward)) != null; ++i) {
            this.tree.expandPath(elementPath);
            currentRow = this.tree.getRowForPath(elementPath);
            if (currentRow < 0) break;
        }
        if (elementPath == null) {
            return false;
        }
        this.tree.setSelectionPath(elementPath);
        this.tree.scrollPathToVisible(elementPath);
        return true;
    }

    public boolean setSelectedStore(String storeName) {
        StoresRepositoryTreeModel.StoresRepositoryElement element;
        StoresRepositoryTreeModel.StoresRepositoryElement root;
        ArrayList path;
        if (StringUtils.isBlank((CharSequence)storeName)) {
            this.tree.clearSelection();
            return true;
        }
        DataStoreParameters params = (DataStoreParameters)this.rootRepository.get((Object)storeName);
        TreeModel model = this.tree.getModel();
        if (!this.setSelectedStore(model, path = new ArrayList(), root = (StoresRepositoryTreeModel.StoresRepositoryElement)model.getRoot(), params)) {
            return false;
        }
        int currentRow = 0;
        TreePath elementPath = null;
        for (int i = 0; i < path.size() && (elementPath = this.tree.getNextMatch((element = (StoresRepositoryTreeModel.StoresRepositoryElement)path.get(i)).getLabel(), currentRow, Position.Bias.Forward)) != null; ++i) {
            this.tree.expandPath(elementPath);
            currentRow = this.tree.getRowForPath(elementPath);
            if (currentRow < 0) break;
        }
        if (elementPath == null) {
            return false;
        }
        this.tree.setSelectionPath(elementPath);
        this.tree.scrollPathToVisible(elementPath);
        return true;
    }

    private boolean setSelectedStore(TreeModel model, List path, StoresRepositoryTreeModel.StoresRepositoryElement node, DataStoreParameters storeParams) {
        if (node == null) {
            return false;
        }
        if (node.isStore() && node.getStoreParameters().isTheSameStore(storeParams)) {
            return true;
        }
        for (int i = 0; i < model.getChildCount(node); ++i) {
            StoresRepositoryTreeModel.StoresRepositoryElement child = (StoresRepositoryTreeModel.StoresRepositoryElement)model.getChild(node, i);
            path.add(child);
            if (this.setSelectedStore(model, path, child, storeParams)) {
                return true;
            }
            path.remove(path.size() - 1);
        }
        return false;
    }

    public FeatureStore getSelectedFeatureStore() {
        DataStore store = this.getSelectedStore();
        if (store instanceof FeatureStore) {
            return (FeatureStore)store;
        }
        DisposeUtils.dispose((Disposable)store);
        return null;
    }

    private void configureToolTip(final JTree repositoryTree) {
        repositoryTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TreePath path = repositoryTree.getPathForLocation(e.getX(), e.getY());
                StoresRepositoryControllerImpl.this.updateToolTip(repositoryTree, path);
            }
        });
        repositoryTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.mouseExited(new MouseEvent(repositoryTree, 0, 0L, 0, 0, 0, 0, true));
            }
        });
    }

    private void updateToolTip(JTree repositoryTree, TreePath path) {
        if (path == null) {
            repositoryTree.setToolTipText("");
            return;
        }
        Object x = path.getLastPathComponent();
        if (!(x instanceof StoresRepositoryTreeModel.StoresRepositoryElement)) {
            repositoryTree.setToolTipText("");
            return;
        }
        StoresRepositoryTreeModel.StoresRepositoryElement element = (StoresRepositoryTreeModel.StoresRepositoryElement)x;
        if (element.isRepository()) {
            StoresRepository repository = (StoresRepository)element.getValue();
            String s = "<html>\n<b>" + repository.getLabel() + "</b><br>\nID: " + repository.getID() + "\n</html>";
            repositoryTree.setToolTipText(s);
        } else if (element.isStore()) {
            List<DynField> fields = Arrays.asList(element.getStoreParameters().getDynClass().getDynFields());
            Collections.sort(fields, (o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getName(), (String)o2.getName()));
            StringBuilder s = new StringBuilder();
            s.append("<html>\n<b>");
            s.append(element.getLabel());
            s.append("</b><br>\n");
            for (DynField field : fields) {
                String value = Objects.toString(element.getStoreParameters().getDynValue(field.getName()), null);
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) continue;
                s.append(field.getName());
                s.append(": ");
                if (StringUtils.equalsIgnoreCase((CharSequence)field.getName(), (CharSequence)"password")) {
                    s.append("********");
                } else {
                    s.append(value);
                }
                s.append("<br>\n");
            }
            s.append("</html>");
            repositoryTree.setToolTipText(s.toString());
        } else {
            repositoryTree.setToolTipText("");
        }
    }

    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Icon getIconForItem(Object item0) {
        StoresRepositoryTreeModel.StoresRepositoryElement item = (StoresRepositoryTreeModel.StoresRepositoryElement)item0;
        if (item.isStore()) {
            Icon icon;
            FeatureStore store = null;
            try {
                Icon icon2;
                DataManager dataManager = DALLocator.getDataManager();
                DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                store = (FeatureStore)dataManager.openStore(item.getStoreParameters().getProviderName(), item.getStoreParameters());
                icon = icon2 = dataSwingManager.getStoreGeometryIcon(store);
            }
            catch (Exception exception) {
                DisposeUtils.disposeQuietly(store);
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return icon;
        }
        return null;
    }
}

