/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.merge;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.merge.MergeOperation;
import org.gvsig.geoprocess.algorithm.merge.MergeParametersPanel;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class MergeAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String RESULT_LINE = "RESULT_LINE";
    public static final String LAYERS = "LAYERS";
    public static final String FIELDLAYER = "LAYER";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Merge"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addMultipleInput(LAYERS, this.getTranslation("Input_layers"), 5, true);
            this.m_Parameters.addInputVectorLayer(FIELDLAYER, this.getTranslation("Fields"), -1, true);
            this.addOutputVectorLayer(RESULT_POL, this.getTranslation("Merge_polygon"), 2);
            this.addOutputVectorLayer(RESULT_LINE, this.getTranslation("Merge_line"), 1);
            this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("Merge_point"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_POL, 0) || this.existsOutPutFile(RESULT_LINE, 0) || this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(FIELDLAYER);
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(LAYERS);
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureStore outFeatStore;
            ArrayList<FeatureStore> featureStoreList = new ArrayList<FeatureStore>();
            for (int i = 0; i < layers.size(); ++i) {
                IVectorLayer lyr = (IVectorLayer)layers.get(i);
                if (!(lyr instanceof FlyrVectIVectorLayer) || layer.getShapeType() != lyr.getShapeType()) {
                    JOptionPane.showMessageDialog(null, this.getTranslation("layers_type_are_different"), "Error", 2);
                    return false;
                }
                featureStoreList.add(((FlyrVectIVectorLayer)lyr).getFeatureStore());
            }
            FeatureSet features = null;
            features = storeLayer.getFeatureSet();
            FeatureType featureType = features.getDefaultFeatureType();
            MergeOperation operation = new MergeOperation(layer, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            if (this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 6, this.getTranslation("Merge_polygon"), RESULT_POL);
                operation.computesGeometryOperationInAList(featureStoreList, outFeatStore, this.attrNames, false, false, true);
            } else {
                this.buildOutPutStore(featureType, 6, this.getTranslation("Null_polygon"), RESULT_POL);
            }
            if (this.isLine(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 5, this.getTranslation("Merge_line"), RESULT_LINE);
                operation.computesGeometryOperationInAList(featureStoreList, outFeatStore, this.attrNames, false, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 5, this.getTranslation("Null_line"), RESULT_LINE);
            }
            if (this.isPoint(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Merge_point"), RESULT_POINT);
                operation.computesGeometryOperationInAList(featureStoreList, outFeatStore, this.attrNames, false, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Null_point"), RESULT_POINT);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.getTaskMonitor().isCanceled();
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return MergeParametersPanel.class;
    }
}

