/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class PointEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        return geom;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        return geom;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) {
        if (index != 0) {
            return geom;
        }
        Point p = (Point)geom;
        int min = point.getDimension() < p.getDimension() ? point.getDimension() : p.getDimension();
        for (int i = 0; i < min; ++i) {
            p.setCoordinateAt(i, point.getCoordinateAt(i));
        }
        return p;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) {
        ArrayList<Point> vertexList = new ArrayList<Point>();
        if (geom instanceof Point) {
            Point point = (Point)geom;
            vertexList.add(point);
        }
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        return 1;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, auxiliaryPointSymbolEditing, "");
    }
}

