/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.ogc.request;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.RemoteClientStatus;
import org.gvsig.remoteclient.ogc.OGCProtocolHandler;
import org.gvsig.remoteclient.utils.Utilities;

public abstract class OGCRequest {
    protected RemoteClientStatus status = null;
    protected OGCProtocolHandler protocolHandler = null;
    protected boolean isDeleted = false;
    protected static final String XMLTAG_STARTCHARACTER = "<";
    protected static final String XMLTAG_FINISHCHARACTER = "</";
    protected static final String XMLTAG_ENDCHARACTER = ">";
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public OGCRequest(RemoteClientStatus status, OGCProtocolHandler protocolHandler) {
        this.status = status;
        this.protocolHandler = protocolHandler;
    }

    public File sendRequest(ICancellable cancel) throws ConnectException, UnknownHostException, IOException {
        if (this.status != null && this.status.getProtocol() != -1) {
            if (this.status.getProtocol() == 0) {
                String onlineResource = this.protocolHandler.getHost();
                String symbol = OGCRequest.getSymbol(onlineResource);
                onlineResource = onlineResource + symbol;
                return this.sendHttpGetRequest(onlineResource, cancel);
            }
            String onlineResource = this.protocolHandler.getHost();
            return this.sendHttpPostRequest(onlineResource);
        }
        String onlineResource = this.protocolHandler.getServiceInformation().getOnlineResource(this.getOperationName(), 0);
        if (onlineResource != null) {
            String symbol = OGCRequest.getSymbol(onlineResource);
            onlineResource = onlineResource + symbol;
            return this.sendHttpGetRequest(onlineResource, cancel);
        }
        onlineResource = this.protocolHandler.getServiceInformation().getOnlineResource(this.getOperationName(), 1);
        if (onlineResource != null) {
            return this.sendHttpPostRequest(onlineResource);
        }
        onlineResource = this.protocolHandler.getHost();
        String symbol = OGCRequest.getSymbol(onlineResource);
        onlineResource = onlineResource + symbol;
        return this.sendHttpGetRequest(onlineResource, cancel);
    }

    protected abstract String getHttpGetRequest(String var1);

    protected abstract String getHttpPostRequest(String var1);

    protected abstract String getTempFilePrefix();

    protected abstract String getOperationName();

    protected abstract String getSchemaLocation();

    public URL getURL() throws MalformedURLException {
        String onlineResource = this.protocolHandler.getServiceInformation().getOnlineResource(this.getOperationName(), 0);
        if (onlineResource != null) {
            String symbol = OGCRequest.getSymbol(onlineResource);
            onlineResource = onlineResource + symbol;
            return new URL(this.getHttpGetRequest(onlineResource));
        }
        onlineResource = this.protocolHandler.getHost();
        String symbol = OGCRequest.getSymbol(onlineResource);
        onlineResource = onlineResource + symbol;
        return new URL(this.getHttpGetRequest(onlineResource));
    }

    private File sendHttpGetRequest(String onlineResource, ICancellable cancel) throws ConnectException, UnknownHostException, IOException {
        URL url = new URL(stringUtils.replaceAll(this.getHttpGetRequest(onlineResource), " ", "%20"));
        if (this.isDeleted()) {
            Utilities.removeURL(url);
        }
        return Utilities.downloadFile(url, this.getTempFilePrefix(), cancel);
    }

    private File sendHttpPostRequest(String onlineResource) throws ConnectException, UnknownHostException, IOException {
        URL url = new URL(onlineResource);
        String data = this.getHttpPostRequest(onlineResource);
        if (this.isDeleted()) {
            Utilities.removeURL(url + data);
        }
        return Utilities.downloadFile(url, data, this.getTempFilePrefix(), null);
    }

    protected static String getSymbol(String h) {
        String symbol = h.indexOf("?") == -1 ? "?" : (h.indexOf("?") != h.length() - 1 ? "&" : "");
        return symbol;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    protected String createXMLStartTag(String tagName) {
        return XMLTAG_STARTCHARACTER + tagName + XMLTAG_ENDCHARACTER;
    }

    protected String createXMLEndtTag(String tagName) {
        return XMLTAG_FINISHCHARACTER + tagName + XMLTAG_ENDCHARACTER;
    }
}

