/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.DALExpressionBuilder;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.SpatialCache;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.service.spi.AbstractProviderServices;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingProviderServices
extends AbstractProviderServices
implements EditingProviderServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEditingProviderServices.class);
    private EditableFeature defaultFeatureValues;

    public void insertFeatureIntoFeatureStore(Feature feature, FeatureStore featureStore) {
        EditableFeature eFeature = null;
        try {
            eFeature = feature instanceof EditableFeature ? (EditableFeature)feature : feature.getEditable();
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_INSERT_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Can't insert feature into %1$s, canceled by some observer.", featureStore.getName());
                throw new CancelationException(msg, notification.getAbortCause());
            }
            if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature((Feature)eFeature)) {
                String msg = String.format("%1$s is not valid", eFeature.toString());
                throw new Exception(msg);
            }
            featureStore.insert(eFeature);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_INSERT_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
        }
        catch (Exception e) {
            String msg = String.format("Can't insert %1$s into %2$s", eFeature.toString(), featureStore.getName());
            LOGGER.info(msg, (Throwable)e);
        }
    }

    public EditableFeature createNewFeature(FeatureStore store) {
        try {
            EditableFeature f = store.createNewFeature();
            f.copyFrom((Feature)this.getDefaultFeatureValues(), t -> !t.isPrimaryKey() && (!t.isIndexed() || t.allowIndexDuplicateds()));
            return f;
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create feature", ex);
        }
    }

    public void insertGeometryIntoFeatureStore(Geometry geometry, FeatureStore featureStore) {
        EditableFeature eFeature = null;
        try {
            eFeature = this.createNewFeature(featureStore);
            eFeature.setGeometry(featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName(), geometry);
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_INSERT_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Can't insert geometry into %1$s, canceled by some observer.", featureStore.getName());
                throw new CancelationException(msg, notification.getAbortCause());
            }
            if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature((Feature)eFeature)) {
                String msg = String.format("%1$s is not valid", eFeature.toString());
                throw new Exception(msg);
            }
            featureStore.insert(eFeature);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_INSERT_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
        }
        catch (Exception e) {
            String msg = String.format("Can't insert %1$s into %2$s", Objects.toString(eFeature), featureStore.getName());
            LOGGER.info(msg, (Throwable)e);
        }
    }

    public void deleteFeatureFromFeatureSet(Feature feature, FeatureStore featureStore, FeatureSet set) {
        try {
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_REMOVE_FEATURE", null, null, (DataStore)featureStore, feature);
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Can't delete feature from %1$s, canceled by some observer.", featureStore.getName());
                throw new CancelationException(msg, notification.getAbortCause());
            }
            set.delete(feature);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_REMOVE_FEATURE", null, null, (DataStore)featureStore, feature);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteFeatureFromFeatureStore(Feature feature, FeatureStore featureStore) {
        try {
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_REMOVE_FEATURE", null, null, (DataStore)featureStore, feature);
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Can't delete feature from %1$s, canceled by some observer.", featureStore.getName());
                throw new CancelationException(msg, notification.getAbortCause());
            }
            featureStore.delete(feature);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_REMOVE_FEATURE", null, null, (DataStore)featureStore, feature);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void updateFeatureInFeatureStore(Feature feature, FeatureStore featureStore) {
        EditableFeature eFeature = null;
        try {
            eFeature = feature instanceof EditableFeature ? (EditableFeature)feature : feature.getEditable();
            EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
            EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_UPDATE_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
            if (notification.isCanceled() || notification.isAborted()) {
                String msg = String.format("Can't update feature in %1$s, canceled by some observer.", featureStore.getName());
                throw new CancelationException(msg, notification.getAbortCause());
            }
            if (notification.shouldValidateTheFeature() && !editingNotificationManager.validateFeature((Feature)eFeature)) {
                String msg = String.format("%1$s is not valid", eFeature.toString());
                throw new Exception(msg);
            }
            featureStore.update(eFeature);
            editingNotificationManager.notifyObservers((Object)this, "AFTER_UPDATE_FEATURE", null, null, (DataStore)featureStore, (Feature)eFeature);
        }
        catch (Exception e) {
            String msg = String.format("Can't update %1$s in %2$s", eFeature.toString(), featureStore.getName());
            LOGGER.info(msg, (Throwable)e);
        }
    }

    public Circle createCircle(Point center, double radius, int subtype) throws CreateGeometryException {
        return GeometryUtils.createCircle((Point)center, (double)radius, (int)subtype);
    }

    public Circle createCircle(Point firstPoint, Point secondPoint, Point thridPoint, int subtype) throws CreateGeometryException {
        return GeometryUtils.createCircle((Point)firstPoint, (Point)secondPoint, (Point)thridPoint, (int)subtype);
    }

    public Arc createArc(Point center, double radius, double startAngle, double angleExt, int subtype) throws CreateGeometryException {
        return GeometryUtils.createArc((Point)center, (double)radius, (double)startAngle, (double)angleExt, (int)subtype);
    }

    public Ellipse createFilledEllipse(Point firstPointAxisA, Point secondPointAxisA, double halfLengthAxisB, int subtype) throws CreateGeometryException {
        return GeometryUtils.createFilledEllipse((Point)firstPointAxisA, (Point)secondPointAxisA, (double)halfLengthAxisB, (int)subtype);
    }

    public Arc createArc(Point start, Point middle, Point end, int subtype) throws BaseException {
        return GeometryUtils.createArc((Point)start, (Point)middle, (Point)end, (int)subtype);
    }

    public Point createPoint(double x, double y, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.createPoint(x, y, subtype);
    }

    public Line createLine(double x1, double y1, double x2, double y2, int subtype) throws CreateGeometryException {
        return GeometryUtils.createLine((double)x1, (double)y1, (double)x2, (double)y2, (int)subtype);
    }

    public int getSubType(FeatureStore featureStore) throws DataException {
        GeometryType geomType = this.getGeomType(featureStore);
        if (geomType != null) {
            return geomType.getSubType();
        }
        return 4;
    }

    public GeometryType getGeomType(FeatureStore featureStore) throws DataException {
        return featureStore.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
    }

    public EditableFeature getFeatureCopyWithoutUniqueIndex(FeatureStore featureStore, Feature feature) throws DataException {
        EditableFeature editableFeature = featureStore.createNewFeature(feature.getType(), true);
        editableFeature.copyFrom((Feature)this.getDefaultFeatureValues(), t -> !t.isPrimaryKey() && (!t.isIndexed() || t.allowIndexDuplicateds()));
        editableFeature.copyFrom(feature, t -> !t.isPrimaryKey() && (!t.isIndexed() || t.allowIndexDuplicateds()));
        return editableFeature;
    }

    public Point getCenter(Point a, Point b, Point c, int subtype) throws CreateGeometryException {
        return GeometryUtils.getCenter((Point)a, (Point)b, (Point)c, (int)subtype);
    }

    public Point getMidPoint(Point a, Point b, int subtype) throws CreateGeometryException {
        return GeometryUtils.getMidPoint((Point)a, (Point)b, (int)subtype);
    }

    public Double[] getLineParams(Point point, Point nextPoint) {
        Double[] lineParams = new Double[2];
        double denom = nextPoint.getX() - point.getX();
        if (denom != 0.0) {
            lineParams[0] = (nextPoint.getY() - point.getY()) / denom;
            lineParams[1] = point.getY() - lineParams[0] * point.getX();
        } else if (nextPoint.getY() >= point.getY()) {
            lineParams[0] = Double.POSITIVE_INFINITY;
            lineParams[1] = Double.NEGATIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        } else {
            lineParams[0] = Double.NEGATIVE_INFINITY;
            lineParams[1] = Double.POSITIVE_INFINITY;
            if (point.getX() == 0.0) {
                lineParams[1] = 0.0;
            }
        }
        return lineParams;
    }

    public Point[] getPerpendicular(Double m, Double b, Point point, int subtype) throws CreateGeometryException {
        Double m1 = -1.0 / m;
        Double b1 = point.getY() - m1 * point.getX();
        Point[] res = new Point[2];
        if (Double.isInfinite(m1)) {
            if (m1 > 0.0) {
                res[0] = this.createPoint(point.getX(), 0.0, subtype);
                res[1] = this.createPoint(point.getX(), 1.0, subtype);
            } else {
                res[0] = this.createPoint(point.getX(), 0.0, subtype);
                res[1] = this.createPoint(point.getX(), -1.0, subtype);
            }
        } else {
            res[0] = this.createPoint(0.0, b1, subtype);
            Double mod = Math.sqrt(1.0 + Math.pow(m1, 2.0));
            Double x = 1.0 / mod;
            Double y = m1 * x + b1;
            res[1] = this.createPoint(x, y, subtype);
        }
        return res;
    }

    public Point getIntersection(Point[] lineA, Point[] lineB, int subtype) throws CreateGeometryException {
        Point p1 = lineA[0];
        Point p2 = lineA[1];
        Point p3 = lineB[0];
        Point p4 = lineB[1];
        double m1 = Double.POSITIVE_INFINITY;
        if (p2.getX() - p1.getX() != 0.0) {
            m1 = (p2.getY() - p1.getY()) / (p2.getX() - p1.getX());
        }
        double m2 = Double.POSITIVE_INFINITY;
        if (p4.getX() - p3.getX() != 0.0) {
            m2 = (p4.getY() - p3.getY()) / (p4.getX() - p3.getX());
        }
        if (m1 == Double.POSITIVE_INFINITY && m2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        double b1 = p2.getY() - m1 * p2.getX();
        double b2 = p4.getY() - m2 * p4.getX();
        if (m1 != Double.POSITIVE_INFINITY && m2 != Double.POSITIVE_INFINITY) {
            if (m1 == m2) {
                return null;
            }
            double x = (b2 - b1) / (m1 - m2);
            return this.createPoint(x, m1 * x + b1, subtype);
        }
        if (m1 == Double.POSITIVE_INFINITY) {
            double x = p1.getX();
            return this.createPoint(x, m2 * x + b2, subtype);
        }
        if (m2 == Double.POSITIVE_INFINITY) {
            double x = p3.getX();
            return this.createPoint(x, m1 * x + b1, subtype);
        }
        return null;
    }

    public double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public double angleDistance(double angle1, double angle2) {
        double result = angle2 - angle1;
        if (result < 0.0) {
            result = Math.PI * 2 + result;
        }
        return result;
    }

    public Line createLine(Point p1, Point p2, int subtype) throws CreateGeometryException {
        return GeometryUtils.createLine((Point)p1, (Point)p2, (int)subtype);
    }

    public Spline createSpline(List<Point> points, int subtype) throws CreateGeometryException {
        return GeometryUtils.createSpline(points, (int)subtype);
    }

    public String makeConsoleMessage(String preText, Map<String, String> options) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        StringBuilder stb = new StringBuilder();
        if (preText != null) {
            stb.append(i18nManager.getTranslation(preText));
            stb.append(" ");
        }
        for (String option : options.keySet()) {
            stb.append("[");
            stb.append(option);
            stb.append("]");
            stb.append(i18nManager.getTranslation(options.get(option)));
            stb.append(" ");
        }
        return stb.toString();
    }

    public String makeConsoleMessage(String preText, EditingServiceParameterOptions options) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        StringBuilder stb = new StringBuilder();
        if (preText != null) {
            stb.append(i18nManager.getTranslation(preText));
            stb.append(" ");
        }
        for (EditingServiceParameterOptions.ParameterOption option : options) {
            stb.append("[");
            stb.append(option.getConsoleValue());
            stb.append("]");
            stb.append(i18nManager.getTranslation(option.getLabel()));
            stb.append(" ");
        }
        return stb.toString();
    }

    public Arc createEllipse(Point firstPointAxisA, Point secondPointAxisA, double halfLengthAxisB, int subtype) throws CreateGeometryException {
        return GeometryUtils.createEllipse((Point)firstPointAxisA, (Point)secondPointAxisA, (double)halfLengthAxisB, (int)subtype);
    }

    public Circle createCircle(Point firstPoint, Point secondPoint, Point thirdPoint, Point fourthPoint, Point fifthPoint, int subtype) throws CreateGeometryException {
        return GeometryUtils.createCircle((Point)firstPoint, (Point)secondPoint, (Point)thirdPoint, (Point)fourthPoint, (Point)fifthPoint, (int)subtype);
    }

    public Circle createCircle(EuclideanLine2D line1, EuclideanLine2D line2, Point point, int subtype) throws CreateGeometryException {
        return GeometryUtils.createCircle((EuclideanLine2D)line1, (EuclideanLine2D)line2, (Point)point, (int)subtype);
    }

    public Circle createCircle(Geometry geometry1, Geometry geometry2, double radius, Point firstPoint, Point secondPoint, int subtype) throws CreateGeometryException {
        return GeometryUtils.createCircle((Geometry)geometry1, (Geometry)geometry2, (double)radius, (Point)firstPoint, (Point)secondPoint, (int)subtype);
    }

    public Feature getFeature(Point point, FeatureStore store, MapContext mapContext) {
        Feature feature = null;
        try {
            double tolerance = mapContext.getViewPort().toMapDistance(mapContext.getLayers().getDefaultTolerance());
            Geometry buffer = point.buffer(tolerance);
            DataManager dataManager = DALLocator.getDataManager();
            DALExpressionBuilder dalBuilder = dataManager.createDALExpressionBuilder();
            GeometryExpressionBuilder builder = dalBuilder.expression();
            FeatureType featureType = store.getDefaultFeatureType();
            String filter = builder.ST_Intersects((ExpressionBuilder.Value)builder.geometry(buffer, mapContext.getProjection()), (ExpressionBuilder.Value)builder.column(featureType.getDefaultGeometryAttributeName())).toString();
            String sortBy = builder.ST_Distance((ExpressionBuilder.Value)builder.geometry(buffer), (ExpressionBuilder.Value)builder.column(featureType.getDefaultGeometryAttributeName())).toString();
            Expression sortByExpression = ExpressionUtils.createExpression((String)sortBy);
            feature = store.findFirst(filter, sortByExpression, true);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get feature on point (" + point.getX() + "," + point.getY(), (Throwable)ex);
        }
        return feature;
    }

    public Geometry getGeometry(Point point, FeatureStore store, MapContext mapContext) {
        return this.getGeometryOfVisibleLayers(point, store, mapContext, null);
    }

    public Geometry getGeometry(Point point, FeatureStore store, MapContext mapContext, List<Feature> excludeFeatures) {
        Geometry geometry = null;
        try {
            List geometries;
            double tolerance = mapContext.getViewPort().toMapDistance(mapContext.getLayers().getDefaultTolerance());
            Geometry buffer = point.buffer(tolerance);
            FLyrVect layer = (FLyrVect)mapContext.getLayers().getLayer((DataStore)store);
            SpatialCache sc = layer.getSpatialCache();
            if (sc.isOverflown()) {
                LOGGER.warn("Spatial Cache overflown. Limit = " + sc.getMaxFeatures() + ". You must increase limit or zoom in.");
            }
            if ((geometries = sc.query(buffer.getEnvelope())) != null) {
                double minDistance = Double.POSITIVE_INFINITY;
                for (Geometry geom : geometries) {
                    double distance;
                    boolean found = false;
                    if (excludeFeatures != null) {
                        for (Feature excludeFeature : excludeFeatures) {
                            if (excludeFeature.getStore() != store || !excludeFeature.getDefaultGeometry().equals((Object)geom)) continue;
                            found = true;
                        }
                    }
                    if (found || !geom.intersects(buffer) || !((distance = geom.distance((Geometry)point)) < minDistance)) continue;
                    minDistance = distance;
                    geometry = geom;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get geometry on point (" + point.getX() + "," + point.getY(), (Throwable)ex);
        }
        return geometry;
    }

    public Geometry getGeometryOfVisibleLayers(Point point, FeatureStore store, MapContext mapContext) {
        return this.getGeometryOfVisibleLayers(point, store, mapContext, null);
    }

    public Geometry getGeometryOfVisibleLayers(Point point, FeatureStore store, MapContext mapContext, List<Feature> excludeFeatures) {
        Geometry geometry = this.getGeometry(point, store, mapContext, excludeFeatures);
        if (geometry == null) {
            FLyrVect vectLayer;
            FLayer layer;
            Iterator iterator = mapContext.getLayers().deepiterator();
            while (!(!iterator.hasNext() || (layer = (FLayer)iterator.next()) instanceof FLyrVect && (vectLayer = (FLyrVect)layer).getFeatureStore() != store && vectLayer.isEditing() && (geometry = this.getGeometry(point, vectLayer.getFeatureStore(), mapContext, excludeFeatures)) != null)) {
            }
        }
        if (geometry == null) {
            FLayer[] activeLayers;
            for (FLayer activeLayer : activeLayers = mapContext.getLayers().getActives()) {
                FLyrVect activeVectLayer;
                if (activeLayer instanceof FLyrVect && (activeVectLayer = (FLyrVect)activeLayer).getFeatureStore() != store && !activeVectLayer.isEditing() && (geometry = this.getGeometry(point, activeVectLayer.getFeatureStore(), mapContext, excludeFeatures)) != null) break;
            }
        }
        return geometry;
    }

    public void addAngleToDrawingStatus(DefaultDrawingStatus drawingStatus, ISymbol textSymbol, Point vertex, Point ray1, Point ray2, int subtype) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        double angleRay1 = GeometryUtils.calculateAngle((Point)vertex, (Point)ray1);
        double angle = GeometryUtils.calculateAngle((Point)vertex, (Point)ray1, (Point)ray2);
        double radius = vertex.distance((Geometry)ray1) / 4.0;
        Arc auxArc = GeometryUtils.createArc((Point)vertex, (double)radius, (double)GeometryUtils.calculateAngle((Point)vertex, (Point)ray1), (double)angle, (int)subtype);
        drawingStatus.addStatus((Geometry)auxArc, auxiliaryLineSymbolEditing, "");
        Point measurePoint = GeometryUtils.createPoint((Point)vertex, (double)radius, (double)(angleRay1 + angle / 2.0));
        drawingStatus.addStatus((Geometry)measurePoint, textSymbol, GeometryUtils.formatAngle((String)"%5.3D\u00b0", (double)Math.toDegrees(angle)));
    }

    public void setDefaultFeatureValues(EditableFeature feature) {
        this.defaultFeatureValues = feature;
    }

    public EditableFeature getDefaultFeatureValues() {
        if (this.defaultFeatureValues == null) {
            try {
                FeatureStore store = this.getService().getStore();
                this.defaultFeatureValues = store.createNewFeature(true);
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't create default feature values.", ex);
            }
        }
        return this.defaultFeatureValues;
    }

    public ISymbol getPreviewSymbol() {
        try {
            IVectorLegend legend = this.getService().getLegend();
            ISymbol symbol = legend.getSymbolByFeature((Feature)this.getDefaultFeatureValues());
            if (!(symbol instanceof TransparencySupport)) {
                return null;
            }
            symbol = (ISymbol)CloneableUtils.cloneQuietly((Cloneable)symbol);
            ((TransparencySupport)symbol).setTransparency(0.5);
            return symbol;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ISymbol getPreviewSymbol(Feature feature) {
        try {
            IVectorLegend legend = this.getService().getLegend();
            ISymbol symbol = legend.getSymbolByFeature(feature);
            if (!(symbol instanceof TransparencySupport)) {
                return null;
            }
            symbol = (ISymbol)CloneableUtils.cloneQuietly((Cloneable)symbol);
            ((TransparencySupport)symbol).setTransparency(0.5);
            return symbol;
        }
        catch (Exception e) {
            return null;
        }
    }

    public EditingService getService() {
        return (EditingService)super.getService();
    }
}

