/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.saveraster;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.tools.algorithm.saveraster.ExternalCancellable;
import org.gvsig.raster.tools.algorithm.saveraster.RasterizeFLayers;

public class SaveRasterProcess
extends DataProcess {
    public static String VIEWPORT = "ViewPort";
    public static String PATH = "Path";
    public static String DIMENSION = "Dimension";
    public static String BLOCKSIZE = "Blocksize";
    public static String FILENAME = "FileName";
    public static String PARAMS = "WriterParams";
    public static String FLYRS = "FLyrs";
    public static String TIME = "Time";
    public static String PROJECTION = "Projection";
    private IProjection projection = null;
    private ViewPort viewPort = null;
    private Dimension dimension = null;
    private RasterizeFLayers rasterizerLayer = null;
    private String fileName = "";
    private Params writerParams = null;
    private boolean supportImage = false;
    private RasterManager rManager = RasterLocator.getManager();

    public static void registerParameters() {
        SaveRasterProcess.registerInputParameter((String)VIEWPORT, ViewPort.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerInputParameter((String)PATH, String.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerInputParameter((String)DIMENSION, Dimension.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerInputParameter((String)FLYRS, FLayers.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerInputParameter((String)PARAMS, Params.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerOutputParameter((String)PROJECTION, IProjection.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerOutputParameter((String)FILENAME, String.class, (String)"SaveRasterProcess");
        SaveRasterProcess.registerOutputParameter((String)TIME, Long.class, (String)"SaveRasterProcess");
    }

    public void init() {
        this.viewPort = this.getParam(VIEWPORT) != null ? (ViewPort)this.getParam(VIEWPORT) : null;
        this.dimension = this.getParam(DIMENSION) != null ? (Dimension)this.getParam(DIMENSION) : null;
        FLayers flyrs = this.getParam(FLYRS) != null ? (FLayers)this.getParam(FLYRS) : null;
        int blockSize = this.getIntParam(BLOCKSIZE);
        this.rasterizerLayer = new RasterizeFLayers(flyrs, this.viewPort, blockSize);
        this.fileName = this.getStringParam(FILENAME);
        this.writerParams = this.getParam(PARAMS) != null ? (Params)this.getParam(PARAMS) : null;
        this.projection = this.getParam(PROJECTION) != null ? (IProjection)this.getParam(PROJECTION) : null;
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        TaskEventManager task = this.rManager.getRasterTask();
        long t1 = new Date().getTime();
        Envelope env = this.viewPort.getAdjustedEnvelope();
        Extent ex = this.rManager.getDataStructFactory().createExtent(env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1));
        Dimension imgSz = this.viewPort.getImageSize();
        ViewPortData vpData = this.rManager.getDataStructFactory().createViewPortData(this.viewPort.getProjection(), ex, (Dimension2D)imgSz);
        vpData.setDPI((int)this.viewPort.getDPI());
        AffineTransform at = new AffineTransform(vpData.getExtent().width() / (double)imgSz.width, 0.0, 0.0, -(vpData.getExtent().height() / (double)imgSz.height), vpData.getExtent().getULX(), vpData.getExtent().getULY());
        String oldFileName = this.fileName;
        if (this.supportImage) {
            this.fileName = this.fileName.substring(0, Math.min(this.fileName.lastIndexOf(File.separator) + 1, this.fileName.length() - 1));
            this.fileName = this.fileName + this.rManager.getFileUtils().usesOnlyLayerName() + ".tif";
            this.writerParams = this.getWriterParams(this.fileName);
        }
        try {
            this.write(this.fileName, at, this.writerParams, this.rasterizerLayer);
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            long t2 = new Date().getTime();
            try {
                this.saveRasterFinalize(oldFileName, t2 - t1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        catch (IOException ev) {
            throw new ProcessException("error_processing", (Throwable)ev);
        }
        catch (OutOfMemoryError ev) {
            throw new ProcessException("memoria_excedida", (Throwable)ev);
        }
        finally {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
                this.incrementableTask = null;
            }
        }
    }

    private void write(String name, AffineTransform at, Params writerParams, DataServerWriter rasterizerLayer) throws IOException, ProcessInterruptedException, ProcessException {
        TaskEventManager task = this.rManager.getRasterTask();
        RasterWriter geoRasterWriter = null;
        try {
            geoRasterWriter = this.rManager.createWriter(rasterizerLayer, name, 3, at, this.dimension.width, this.dimension.height, -1, writerParams, null);
            CRSUtils crsUtil = RasterLocator.getManager().getCRSUtils();
            geoRasterWriter.setWkt(crsUtil.convertIProjectionToWkt(this.projection));
        }
        catch (NotSupportedExtensionException e) {
            throw new ProcessException("extension_no_soportada", (Throwable)e);
        }
        catch (RasterDriverException e) {
            throw new ProcessException("no_driver_escritura", (Throwable)e);
        }
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
        geoRasterWriter.setCancellableRasterDriver((org.gvsig.fmap.dal.coverage.store.ExternalCancellable)new ExternalCancellable(this.incrementableTask));
        geoRasterWriter.dataWrite();
        geoRasterWriter.writeClose();
    }

    private Params getWriterParams(String name) throws ProcessException {
        RasterWriter writer = null;
        String ext = this.rManager.getFileUtils().getExtensionFromFileName(name);
        try {
            if (writer == null) {
                writer = this.rManager.createWriter(name);
            } else {
                String oldType;
                String newType = this.rManager.getProviderServices().getWriteDriverType(ext);
                if (!newType.equals(oldType = writer.getDriverName())) {
                    writer = this.rManager.createWriter(name);
                }
            }
            if (writer == null) {
                throw new ProcessException("no_driver_escritura");
            }
            return writer.getParams();
        }
        catch (NotSupportedExtensionException e1) {
            throw new ProcessException("no_driver_escritura", (Throwable)e1);
        }
        catch (RasterDriverException e1) {
            throw new ProcessException("no_driver_escritura", (Throwable)e1);
        }
    }

    private void saveRasterFinalize(String fileName, long milis) {
        if (this.incrementableTask != null) {
            this.incrementableTask.hideWindow();
        }
        this.externalActions.end((Object)new Object[]{fileName, new Long(milis)});
    }

    public int getPercent() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getPercent();
        }
        return 0;
    }

    public String getTitle() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getTitle();
        }
        return null;
    }

    public String getLog() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getLog();
        }
        return null;
    }

    public String getLabel() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getLabel();
        }
        return null;
    }
}

