/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.csv.swing.panels;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.csv.service.ExportCSVParameters;
import org.gvsig.export.csv.swing.panels.CSVExportParametersPanelView;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExportParametersPanel
extends CSVExportParametersPanelView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(CSVExportParametersPanel.class);
    private final ExportCSVParameters parameters;
    private final JExportProcessPanel processPanel;

    public CSVExportParametersPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportCSVParameters)parameters;
        this.initComponents();
    }

    private DefaultComboBoxModel createComboBoxModelFromAvaiblesValues(String dynFieldValue) {
        DynObjectValueItem[] availableValues;
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("CSVNewStoreParameters");
        DynField dynField = parametersDefinition.getDynField(dynFieldValue);
        DefaultComboBoxModel<ComboItem> dcm = new DefaultComboBoxModel<ComboItem>();
        for (DynObjectValueItem availableValue : availableValues = dynField.getAvailableValues()) {
            ComboItem item = new ComboItem(availableValue.getLabel(), (String)availableValue.getValue());
            dcm.addElement(item);
        }
        return dcm;
    }

    private void initComponents() {
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("CSVNewStoreParameters");
        this.cmbProfile.setModel(this.createComboBoxModelFromAvaiblesValues("profile"));
        this.cmbProfile.setSelectedIndex(0);
        this.cmbQuotePolicy.setModel(this.createComboBoxModelFromAvaiblesValues("quotePolicy"));
        this.cmbQuotePolicy.setSelectedIndex(0);
        this.cmbLocale.setModel(this.createComboBoxModelFromAvaiblesValues("locale"));
        this.cmbLocale.setSelectedIndex(0);
        this.cboGeometryFormat.setModel(this.createComboBoxModelFromAvaiblesValues("geometryFormat"));
        this.cboGeometryFormat.setSelectedIndex(0);
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblProfile);
        i18nc.translate(this.lblQuotePolicy);
        i18nc.translate(this.lblLocale);
        i18nc.translate(this.lblRecordSeparator);
        i18nc.translate(this.lblDelimiter);
        i18nc.translate(this.lblQuoteCharacter);
        i18nc.translate(this.lblCommentStartMarker);
        i18nc.translate(this.lblIncludeMetadataInHeader);
        i18nc.translate(this.lblGeometryFormat);
    }

    public String getParameterLocale() {
        ComboItem item = (ComboItem)this.cmbLocale.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public String getParameterQuotePolicy() {
        ComboItem item = (ComboItem)this.cmbQuotePolicy.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public String getParameterProfile() {
        ComboItem item = (ComboItem)this.cmbProfile.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public String getGeometryFormat() {
        ComboItem item = (ComboItem)this.cboGeometryFormat.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public String getParameterRecordSeparator() {
        return this.txtRecordSeparator.getText();
    }

    public String getParameterDelimiter() {
        return this.txtDelimiter.getText();
    }

    public String getParameterQuoteCharacter() {
        return this.txtQuoteCharacter.getText();
    }

    public String getParameterCommentStartMarker() {
        return this.txtCommentStartMarker.getText();
    }

    public boolean getParameterIncludeMetadataInHeader() {
        return this.chkIncludeMetadataInHeader.isSelected();
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getIdPanel() {
        return this.getClass().getSimpleName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Select_encoding");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        this.setSelectedStringValue(this.cmbProfile, this.parameters.getProfile());
        this.setSelectedStringValue(this.cmbLocale, this.parameters.getLocale());
        this.setSelectedStringValue(this.cmbQuotePolicy, this.parameters.getQuotePolicy());
        this.setSelectedStringValue(this.cboGeometryFormat, this.parameters.getGeometryFormat());
        this.txtRecordSeparator.setText(this.parameters.getRecordSeparator());
        this.txtDelimiter.setText(this.parameters.getDelimiter());
        this.txtQuoteCharacter.setText(this.parameters.getQuoteCharacter());
        this.txtCommentStartMarker.setText(this.parameters.getCommentStartMarker());
        this.chkIncludeMetadataInHeader.setSelected(this.parameters.getIncludeMetadataInHeader());
    }

    public void previousPanel() {
    }

    private void setSelectedStringValue(JComboBox comboBox, String value) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ComboItem item = (ComboItem)comboBox.getItemAt(i);
            if (!StringUtils.equals((CharSequence)item.getValue(), (CharSequence)value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public void nextPanel() {
        this.parameters.setProfile(this.getParameterProfile());
        this.parameters.setQuotePolicy(this.getParameterQuotePolicy());
        this.parameters.setLocale(this.getParameterLocale());
        if (this.getParameterRecordSeparator() != null) {
            this.parameters.setRecordSeparator(this.getParameterRecordSeparator());
        }
        if (this.getParameterDelimiter() != null) {
            this.parameters.setDelimiter(this.getParameterDelimiter());
        }
        if (this.getParameterCommentStartMarker() != null) {
            this.parameters.setCommentStartMarker(this.getParameterCommentStartMarker());
        }
        if (this.getParameterQuoteCharacter() != null) {
            this.parameters.setQuoteCharacter(this.getParameterQuoteCharacter());
        }
        this.parameters.setIncludeMetadataInHeader(this.getParameterIncludeMetadataInHeader());
        this.parameters.setGeometryFormat(this.getGeometryFormat());
    }

    class ComboItem {
        private final String key;
        private final String value;

        public ComboItem(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

