/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.XMath;
import org.geotools.resources.cts.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrKrovak
extends MapProjection {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-11;
    protected final double azimuth;
    protected final double pseudoStandardParallel;
    private final double sinAzim;
    private final double cosAzim;
    private final double n;
    private final double tanS2;
    private final double alfa;
    private final double hae;
    private final double k1;
    private final double ka;
    private final double ro0;
    private final double rop;
    private static final double s45 = 0.785398163397448;

    protected IdrKrovak(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        this.latitudeOfOrigin = IdrKrovak.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)parameters);
        this.centralMeridian = IdrKrovak.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)parameters);
        this.azimuth = IdrKrovak.doubleValue((Collection)expected, (ParameterDescriptor)Provider.AZIMUTH, (ParameterValueGroup)parameters);
        this.pseudoStandardParallel = IdrKrovak.doubleValue((Collection)expected, (ParameterDescriptor)Provider.PSEUDO_STANDARD_PARALLEL, (ParameterValueGroup)parameters);
        this.scaleFactor = IdrKrovak.doubleValue((Collection)expected, (ParameterDescriptor)Provider.SCALE_FACTOR, (ParameterValueGroup)parameters);
        IdrKrovak.ensureLatitudeInRange((ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (double)this.latitudeOfOrigin, (boolean)false);
        IdrKrovak.ensureLongitudeInRange((ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (double)this.centralMeridian, (boolean)false);
        this.sinAzim = Math.sin(this.azimuth);
        this.cosAzim = Math.cos(this.azimuth);
        this.n = Math.sin(this.pseudoStandardParallel);
        this.tanS2 = Math.tan(this.pseudoStandardParallel / 2.0 + 0.785398163397448);
        double sinLat = Math.sin(this.latitudeOfOrigin);
        double cosLat = Math.cos(this.latitudeOfOrigin);
        double cosL2 = cosLat * cosLat;
        this.alfa = Math.sqrt(1.0 + this.excentricitySquared * (cosL2 * cosL2) / (1.0 - this.excentricitySquared));
        this.hae = this.alfa * this.excentricity / 2.0;
        double u0 = Math.asin(sinLat / this.alfa);
        double esl = this.excentricity * sinLat;
        double g = Math.pow((1.0 - esl) / (1.0 + esl), this.alfa * this.excentricity / 2.0);
        this.k1 = Math.pow(Math.tan(this.latitudeOfOrigin / 2.0 + 0.785398163397448), this.alfa) * g / Math.tan(u0 / 2.0 + 0.785398163397448);
        this.ka = Math.pow(1.0 / this.k1, -1.0 / this.alfa);
        double radius = Math.sqrt(1.0 - this.excentricitySquared) / (1.0 - this.excentricitySquared * (sinLat * sinLat));
        this.ro0 = this.scaleFactor * radius / Math.tan(this.pseudoStandardParallel);
        this.rop = this.ro0 * Math.pow(this.tanS2, this.n);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        List expected = this.getParameterDescriptors().descriptors();
        ParameterValueGroup values = super.getParameterValues();
        IdrKrovak.set((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.latitudeOfOrigin);
        IdrKrovak.set((Collection)expected, (ParameterDescriptor)Provider.LONGITUDE_OF_CENTER, (ParameterValueGroup)values, (double)this.centralMeridian);
        IdrKrovak.set((Collection)expected, (ParameterDescriptor)Provider.AZIMUTH, (ParameterValueGroup)values, (double)this.azimuth);
        IdrKrovak.set((Collection)expected, (ParameterDescriptor)Provider.PSEUDO_STANDARD_PARALLEL, (ParameterValueGroup)values, (double)this.pseudoStandardParallel);
        IdrKrovak.set((Collection)expected, (ParameterDescriptor)Provider.SCALE_FACTOR, (ParameterValueGroup)values, (double)this.scaleFactor);
        return values;
    }

    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double esp = this.excentricity * Math.sin(phi);
        double gfi = Math.pow((1.0 - esp) / (1.0 + esp), this.hae);
        double u = 2.0 * (Math.atan(Math.pow(Math.tan(phi / 2.0 + 0.785398163397448), this.alfa) / this.k1 * gfi) - 0.785398163397448);
        double deltav = -lambda * this.alfa;
        double cosU = Math.cos(u);
        double s = Math.asin(this.cosAzim * Math.sin(u) + this.sinAzim * cosU * Math.cos(deltav));
        double d = Math.asin(cosU * Math.sin(deltav) / Math.cos(s));
        double eps = this.n * d;
        double ro = this.rop / Math.pow(Math.tan(s / 2.0 + 0.785398163397448), this.n);
        double y = -(ro * Math.cos(eps));
        double x = -(ro * Math.sin(eps));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double esf;
        double ro = XMath.hypot((double)x, (double)y);
        double eps = Math.atan2(-x, -y);
        double d = eps / this.n;
        double s = 2.0 * (Math.atan(Math.pow(this.ro0 / ro, 1.0 / this.n) * this.tanS2) - 0.785398163397448);
        double cs = Math.cos(s);
        double u = Math.asin(this.cosAzim * Math.sin(s) - this.sinAzim * cs * Math.cos(d));
        double kau = this.ka * Math.pow(Math.tan(u / 2.0 + 0.785398163397448), 1.0 / this.alfa);
        double deltav = Math.asin(cs * Math.sin(d) / Math.cos(u));
        double lambda = -deltav / this.alfa;
        double phi = 0.0;
        double fi1 = u;
        int i = 15;
        while (!(Math.abs((fi1 = phi) - (phi = 2.0 * (Math.atan(kau * Math.pow((1.0 + (esf = this.excentricity * Math.sin(fi1))) / (1.0 - esf), this.excentricity / 2.0)) - 0.785398163397448))) <= 1.0E-11)) {
            if (--i >= 0) continue;
            throw new ProjectionException(Resources.format((int)109));
        }
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.azimuth) ^ Double.doubleToLongBits(this.pseudoStandardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdrKrovak that = (IdrKrovak)((Object)object);
            return IdrKrovak.equals((double)this.azimuth, (double)that.azimuth) && IdrKrovak.equals((double)this.pseudoStandardParallel, (double)that.pseudoStandardParallel);
        }
        return false;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLat")}, (double)49.5, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONGITUDE_OF_CENTER = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "longitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLong")}, (double)24.83333333333333, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor AZIMUTH = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "azimuth"), new NamedIdentifier(CitationImpl.EPSG, "Azimuth of the center line"), new NamedIdentifier(CitationImpl.EPSG, "Azimuth of initial line"), new NamedIdentifier(CitationImpl.GEOTIFF, "AzimuthAngle")}, (double)30.28813972222222, (double)0.0, (double)360.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor PSEUDO_STANDARD_PARALLEL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "pseudo_standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of Pseudo Standard Parallel")}, (double)78.5, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor SCALE_FACTOR = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "scale_factor"), new NamedIdentifier(CitationImpl.EPSG, "Scale factor on the pseudo standard line"), new NamedIdentifier(CitationImpl.EPSG, "Scale factor on pseudo standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "ScaleAtCenter")}, (double)0.9999, (double)0.0, (double)Double.POSITIVE_INFINITY, (Unit)Unit.ONE);
        public static final ParameterDescriptor FALSEEASTING = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.EPSG, "Easting at projection centre")}, (double)0.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (Unit)SI.METER);
        public static final ParameterDescriptor FALSENORTHING = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.EPSG, "Northing at projection centre")}, (double)0.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (Unit)SI.METER);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Krovak"), new NamedIdentifier(CitationImpl.GEOTIFF, "Krovak"), new NamedIdentifier(CitationImpl.EPSG, "Krovak Oblique Conformal Conic"), new NamedIdentifier(CitationImpl.EPSG, "Krovak Oblique Conic Conformal"), new NamedIdentifier(CitationImpl.EPSG, "9819"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_CENTER, LONGITUDE_OF_CENTER, AZIMUTH, PSEUDO_STANDARD_PARALLEL, SCALE_FACTOR, FALSEEASTING, FALSENORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return ConicProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrKrovak(parameters);
        }
    }
}

