/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrObliqueMercator
extends MapProjection {
    private final double scaleFactorLocal;
    private final double falseEastingLocal;
    private final double falseNorthingLocal;
    private final double latitudeOfCentre;
    private final double longitudeOfCentre;
    private double alpha_c;
    private double rectGridAngle;
    private final double latitudeOf1stPoint;
    private final double longitudeOf1stPoint;
    private final double latitudeOf2ndPoint;
    private double longitudeOf2ndPoint;
    private double B;
    private double A;
    private double E;
    private final double ArB;
    private final double AB;
    private final double BrA;
    private final double v_pole_n;
    private final double v_pole_s;
    private final double singamma0;
    private final double cosgamma0;
    private final double sinrot;
    private final double cosrot;
    private double u_c;
    private final boolean twoPoint;
    private final boolean hotine;

    IdrObliqueMercator(ParameterValueGroup parameters, Collection expected, boolean hotine, boolean twoPoint) throws ParameterNotFoundException {
        super(parameters, expected);
        this.hotine = hotine;
        this.twoPoint = twoPoint;
        this.latitudeOfOrigin = Double.NaN;
        this.centralMeridian = Double.NaN;
        List miExpected = this.getParameterDescriptors().descriptors();
        this.scaleFactorLocal = miExpected.contains(Provider.SCALE_FACTOR_LOCAL) ? Math.abs(IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.SCALE_FACTOR_LOCAL, (ParameterValueGroup)parameters)) : 1.0;
        this.falseEastingLocal = miExpected.contains(Provider.FALSE_EASTING_LOCAL) ? Math.abs(IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.FALSE_EASTING_LOCAL, (ParameterValueGroup)parameters)) : 0.0;
        this.falseNorthingLocal = miExpected.contains(Provider.FALSE_NORTHING_LOCAL) ? Math.abs(IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.FALSE_NORTHING_LOCAL, (ParameterValueGroup)parameters)) : 0.0;
        this.latitudeOfCentre = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LAT_OF_CENTRE, (ParameterValueGroup)parameters);
        IdrObliqueMercator.ensureLatitudeInRange((ParameterDescriptor)Provider.LAT_OF_CENTRE, (double)this.latitudeOfCentre, (boolean)false);
        if (twoPoint) {
            this.longitudeOfCentre = Double.NaN;
            this.latitudeOf1stPoint = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LAT_OF_1ST_POINT, (ParameterValueGroup)parameters);
            IdrObliqueMercator.ensureLatitudeInRange((ParameterDescriptor)Provider_TwoPoint.LAT_OF_1ST_POINT, (double)this.latitudeOf1stPoint, (boolean)false);
            this.longitudeOf1stPoint = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LONG_OF_1ST_POINT, (ParameterValueGroup)parameters);
            IdrObliqueMercator.ensureLongitudeInRange((ParameterDescriptor)Provider_TwoPoint.LONG_OF_1ST_POINT, (double)this.longitudeOf1stPoint, (boolean)true);
            this.latitudeOf2ndPoint = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LAT_OF_2ND_POINT, (ParameterValueGroup)parameters);
            IdrObliqueMercator.ensureLatitudeInRange((ParameterDescriptor)Provider_TwoPoint.LAT_OF_2ND_POINT, (double)this.latitudeOf2ndPoint, (boolean)true);
            this.longitudeOf2ndPoint = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LONG_OF_2ND_POINT, (ParameterValueGroup)parameters);
            IdrObliqueMercator.ensureLongitudeInRange((ParameterDescriptor)Provider_TwoPoint.LONG_OF_2ND_POINT, (double)this.longitudeOf2ndPoint, (boolean)true);
        } else {
            this.latitudeOf1stPoint = Double.NaN;
            this.longitudeOf1stPoint = Double.NaN;
            this.latitudeOf2ndPoint = Double.NaN;
            this.longitudeOf2ndPoint = Double.NaN;
            this.longitudeOfCentre = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LONG_OF_CENTRE, (ParameterValueGroup)parameters);
            IdrObliqueMercator.ensureLongitudeInRange((ParameterDescriptor)Provider.LONG_OF_CENTRE, (double)this.longitudeOfCentre, (boolean)true);
            this.alpha_c = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.AZIMUTH, (ParameterValueGroup)parameters);
            if (this.alpha_c > -4.71238898038469 && this.alpha_c < -1.5707963267948966 || this.alpha_c > 1.5707963267948966 && this.alpha_c < 4.71238898038469) {
                throw new IllegalArgumentException(Resources.format((int)126, (Object)new Double(Math.toDegrees(this.alpha_c)), (Object)new Double(-90.0), (Object)new Double(90.0)));
            }
            this.rectGridAngle = IdrObliqueMercator.doubleValue((Collection)expected, (ParameterDescriptor)Provider.RECTIFIED_GRID_ANGLE, (ParameterValueGroup)parameters);
            if (Double.isNaN(this.rectGridAngle)) {
                this.rectGridAngle = this.alpha_c;
            }
        }
        this.singamma0 = 0.0;
        this.cosgamma0 = 0.0;
        this.sinrot = 0.0;
        this.cosrot = 0.0;
        this.ArB = 0.0;
        this.AB = 0.0;
        this.BrA = 0.0;
        this.v_pole_n = 0.0;
        this.v_pole_s = 0.0;
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        if (this.hotine) {
            return this.twoPoint ? Provider_Hotine_TwoPoint.PARAMETERS : Provider_Hotine.PARAMETERS;
        }
        return this.twoPoint ? Provider_TwoPoint.PARAMETERS : Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        if (this.twoPoint) {
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LAT_OF_CENTRE, (ParameterValueGroup)values, (double)this.latitudeOfCentre);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LAT_OF_1ST_POINT, (ParameterValueGroup)values, (double)this.latitudeOf1stPoint);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LONG_OF_1ST_POINT, (ParameterValueGroup)values, (double)this.longitudeOf1stPoint);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LAT_OF_2ND_POINT, (ParameterValueGroup)values, (double)this.latitudeOf2ndPoint);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider_TwoPoint.LONG_OF_2ND_POINT, (ParameterValueGroup)values, (double)this.longitudeOf2ndPoint);
        } else {
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.LAT_OF_CENTRE, (ParameterValueGroup)values, (double)this.latitudeOfCentre);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.LONG_OF_CENTRE, (ParameterValueGroup)values, (double)this.longitudeOfCentre);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.AZIMUTH, (ParameterValueGroup)values, (double)this.alpha_c);
            IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.RECTIFIED_GRID_ANGLE, (ParameterValueGroup)values, (double)this.rectGridAngle);
        }
        IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.SCALE_FACTOR_LOCAL, (ParameterValueGroup)values, (double)this.scaleFactorLocal);
        IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.FALSE_NORTHING_LOCAL, (ParameterValueGroup)values, (double)this.falseNorthingLocal);
        IdrObliqueMercator.set((Collection)expected, (ParameterDescriptor)Provider.FALSE_EASTING_LOCAL, (ParameterValueGroup)values, (double)this.falseEastingLocal);
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double u;
        double v;
        if (Math.abs(Math.abs(y) - 1.5707963267948966) > 1.0E-6) {
            double V;
            double temp;
            double Q = this.E / Math.pow(this.tsfn(y, Math.sin(y)), this.B);
            double S = 0.5 * (Q - (temp = 1.0 / Q));
            double U = (S * this.singamma0 - (V = Math.sin(this.B * x)) * this.cosgamma0) / (0.5 * (Q + temp));
            if (Math.abs(Math.abs(U) - 1.0) < 1.0E-6) {
                throw new ProjectionException(Resources.format((int)139));
            }
            v = 0.5 * this.ArB * Math.log((1.0 - U) / (1.0 + U));
            temp = Math.cos(this.B * x);
            u = Math.abs(temp) < 1.0E-10 ? this.AB * x : this.ArB * Math.atan2(S * this.cosgamma0 + V * this.singamma0, temp);
        } else {
            v = y > 0.0 ? this.v_pole_n : this.v_pole_s;
            u = this.ArB * y;
        }
        x = v * this.cosrot + (u -= this.u_c) * this.sinrot;
        y = u * this.cosrot - v * this.sinrot;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double v = x * this.cosrot - y * this.sinrot;
        double u = y * this.cosrot + x * this.sinrot + this.u_c;
        double Qp = Math.exp(-this.BrA * v);
        double temp = 1.0 / Qp;
        double Sp = 0.5 * (Qp - temp);
        double Vp = Math.sin(this.BrA * u);
        double Up = (Vp * this.cosgamma0 + Sp * this.singamma0) / (0.5 * (Qp + temp));
        if (Math.abs(Math.abs(Up) - 1.0) < 1.0E-6) {
            x = 0.0;
            y = Up < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            y = Math.pow(this.E / Math.sqrt((1.0 + Up) / (1.0 - Up)), 1.0 / this.B);
            y = this.cphi2(y);
            x = -Math.atan2(Sp * this.cosgamma0 - Vp * this.singamma0, Math.cos(this.BrA * u)) / this.B;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected double getToleranceForAssertions(double longitude, double latitude) {
        if (Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfCentre) > 10.0) {
            return 1.0;
        }
        return super.getToleranceForAssertions(longitude, latitude);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.latitudeOfCentre);
        code = code * 37L + Double.doubleToLongBits(this.longitudeOfCentre);
        code = code * 37L + Double.doubleToLongBits(this.alpha_c);
        code = code * 37L + Double.doubleToLongBits(this.rectGridAngle);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOf1stPoint);
        code = code * 37L + Double.doubleToLongBits(this.latitudeOf2ndPoint);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            IdrObliqueMercator that = (IdrObliqueMercator)((Object)object);
            return IdrObliqueMercator.equals((double)this.latitudeOfCentre, (double)that.latitudeOfCentre) && IdrObliqueMercator.equals((double)this.longitudeOfCentre, (double)that.longitudeOfCentre) && IdrObliqueMercator.equals((double)this.alpha_c, (double)that.alpha_c) && IdrObliqueMercator.equals((double)this.rectGridAngle, (double)that.rectGridAngle) && IdrObliqueMercator.equals((double)this.u_c, (double)that.u_c) && IdrObliqueMercator.equals((double)this.latitudeOf1stPoint, (double)that.latitudeOf1stPoint) && IdrObliqueMercator.equals((double)this.longitudeOf1stPoint, (double)that.longitudeOf1stPoint) && IdrObliqueMercator.equals((double)this.latitudeOf2ndPoint, (double)that.latitudeOf2ndPoint) && IdrObliqueMercator.equals((double)this.longitudeOf2ndPoint, (double)that.longitudeOf2ndPoint) && this.twoPoint == that.twoPoint && this.hotine == that.hotine;
        }
        return false;
    }

    public static final class Provider_Hotine_TwoPoint
    extends Provider_TwoPoint {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Hotine_TwoPoint.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Hotine_Oblique_Mercator_Two_Point_Natural_Origin"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)135)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LAT_OF_CENTRE, SCALE_FACTOR_LOCAL, FALSE_EASTING_LOCAL, FALSE_NORTHING_LOCAL});

        public Provider_Hotine_TwoPoint() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new IdrObliqueMercator(parameters, descriptors, true, true);
        }
    }

    public static class Provider_TwoPoint
    extends Provider {
        public static final ParameterDescriptor LAT_OF_CENTRE = Provider_TwoPoint.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.ESRI, "Latitude_Of_Center"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LAT_OF_1ST_POINT = Provider_TwoPoint.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Latitude_Of_1st_Point")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_1ST_POINT = Provider_TwoPoint.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Longitude_Of_1st_Point")}, (double)0.0, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LAT_OF_2ND_POINT = Provider_TwoPoint.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Latitude_Of_2nd_Point")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_2ND_POINT = Provider_TwoPoint.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Longitude_Of_2nd_Point")}, (double)0.0, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider_TwoPoint.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.ESRI, "Hotine_Oblique_Mercator_Two_Point_Center"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)135)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LAT_OF_CENTRE, SCALE_FACTOR_LOCAL, FALSE_EASTING_LOCAL, FALSE_NORTHING_LOCAL});

        public Provider_TwoPoint() {
            super(PARAMETERS);
        }

        protected Provider_TwoPoint(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new IdrObliqueMercator(parameters, descriptors, false, true);
        }
    }

    public static final class Provider_Hotine
    extends Provider {
        static final ParameterDescriptorGroup PARAMETERS = Provider_Hotine.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Hotine_Oblique_Mercator"), new NamedIdentifier(CitationImpl.EPSG, "Hotine Oblique Mercator"), new NamedIdentifier(CitationImpl.EPSG, "9812"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_ObliqueMercator_Hotine"), new NamedIdentifier(CitationImpl.ESRI, "Hotine_Oblique_Mercator_Azimuth_Natural_Origin"), new NamedIdentifier(CitationImpl.ESRI, "Rectified_Skew_Orthomorphic_Natural_Origin"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)135)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONG_OF_CENTRE, LAT_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR_LOCAL, FALSE_EASTING_LOCAL, FALSE_NORTHING_LOCAL});

        public Provider_Hotine() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new IdrObliqueMercator(parameters, descriptors, true, false);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor SCALE_FACTOR_LOCAL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "scale_factor"), new NamedIdentifier(CitationImpl.EPSG, "Scale factor on initial line"), new NamedIdentifier(CitationImpl.EPSG, "Scale factor at natural origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "ScaleAtNatOrigin"), new NamedIdentifier(CitationImpl.GEOTIFF, "ScaleAtCenter")}, (double)1.0, (double)0.0, (double)Double.POSITIVE_INFINITY, (Unit)Unit.ONE);
        public static final ParameterDescriptor FALSE_EASTING_LOCAL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "false_easting"), new NamedIdentifier(CitationImpl.EPSG, "False easting"), new NamedIdentifier(CitationImpl.EPSG, "Easting at projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Easting at false origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "FalseEasting")}, (double)0.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (Unit)SI.METER);
        public static final ParameterDescriptor FALSE_NORTHING_LOCAL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "false_northing"), new NamedIdentifier(CitationImpl.EPSG, "False northing"), new NamedIdentifier(CitationImpl.EPSG, "Northing at projection centre"), new NamedIdentifier(CitationImpl.EPSG, "Northing at false origin"), new NamedIdentifier(CitationImpl.GEOTIFF, "FalseNorthing")}, (double)0.0, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (Unit)SI.METER);
        public static final ParameterDescriptor LAT_OF_CENTRE = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.ESRI, "Latitude_Of_Center"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor LONG_OF_CENTRE = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "longitude_of_center"), new NamedIdentifier(CitationImpl.EPSG, "Longitude of projection centre"), new NamedIdentifier(CitationImpl.ESRI, "Longitude_Of_Center"), new NamedIdentifier(CitationImpl.GEOTIFF, "CenterLong")}, (double)0.0, (double)-180.0, (double)180.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor AZIMUTH = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "azimuth"), new NamedIdentifier(CitationImpl.ESRI, "Azimuth"), new NamedIdentifier(CitationImpl.EPSG, "Azimuth of initial line"), new NamedIdentifier(CitationImpl.GEOTIFF, "AzimuthAngle")}, (double)0.0, (double)-360.0, (double)360.0, (Unit)NonSI.DEGREE_ANGLE);
        public static final ParameterDescriptor RECTIFIED_GRID_ANGLE = Provider.createOptionalDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "rectified_grid_angle"), new NamedIdentifier(CitationImpl.EPSG, "Angle from Rectified to Skew Grid"), new NamedIdentifier(CitationImpl.ESRI, "XY_Plane_Rotation"), new NamedIdentifier(CitationImpl.GEOTIFF, "RectifiedGridAngle")}, (double)-360.0, (double)360.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Oblique_Mercator"), new NamedIdentifier(CitationImpl.EPSG, "Oblique Mercator"), new NamedIdentifier(CitationImpl.EPSG, "9815"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_ObliqueMercator"), new NamedIdentifier(CitationImpl.ESRI, "Hotine_Oblique_Mercator_Azimuth_Center"), new NamedIdentifier(CitationImpl.ESRI, "Rectified_Skew_Orthomorphic_Center"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational((int)135)), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LONG_OF_CENTRE, LAT_OF_CENTRE, AZIMUTH, RECTIFIED_GRID_ANGLE, SCALE_FACTOR_LOCAL, FALSE_EASTING_LOCAL, FALSE_NORTHING_LOCAL});

        public Provider() {
            super(PARAMETERS);
        }

        protected Provider(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            return new IdrObliqueMercator(parameters, descriptors, false, false);
        }
    }
}

