/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.ogr.Esri2wkt;
import org.gvsig.crs.repository.ICrsRepository;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsriRepository
implements ICrsRepository,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(EsriRepository.class);
    EpsgConnection connection = new EpsgConnection();

    public EsriRepository() {
        this.connection.setConnectionEsri();
    }

    public ICrs getCrs(String code) {
        String cadWKT = "";
        Crs crs = null;
        String sentence = "SELECT esri_code, esri_wkt, esri_proj, esri_geog, esri_datum FROM ESRI WHERE esri_code = " + code;
        ResultSet result = Query.select(sentence, this.connection.getConnection());
        try {
            if (!result.next()) {
                return null;
            }
            cadWKT = result.getString("esri_wkt");
        }
        catch (SQLException e1) {
            logger.info("Error executing the SQL", (Throwable)e1);
            return null;
        }
        cadWKT = cadWKT.substring(0, cadWKT.length() - 1) + ", AUTHORITY[\"ESRI\"," + Integer.parseInt(code) + "]]";
        if (cadWKT.charAt(0) == 'P') {
            Esri2wkt wk = new Esri2wkt(cadWKT);
            cadWKT = wk.getWkt();
        }
        try {
            crs = new Crs(Integer.parseInt(code), cadWKT);
        }
        catch (CrsException e) {
            logger.info("Impossible to parse the CRS", (Throwable)e);
            return null;
        }
        return crs;
    }

    public void dispose() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            logger.warn("Con't shutdown the connection.", (Throwable)ex);
        }
    }
}

