/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.ogr.Iau2wkt;
import org.gvsig.crs.repository.ICrsRepository;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iau2000Repository
implements ICrsRepository,
Disposable {
    private static final Logger LOG = LoggerFactory.getLogger(Iau2000Repository.class);
    EpsgConnection connection = new EpsgConnection();

    public ICrs getCrs(String code) {
        String cadWKT = "";
        Crs crs = null;
        String sentence = "SELECT iau_code, iau_wkt, iau_proj, iau_geog, iau_datum FROM IAU2000 WHERE iau_code = " + code;
        this.connection.setConnectionIAU2000();
        ResultSet result = Query.select(sentence, this.connection.getConnection());
        try {
            this.connection.shutdown();
        }
        catch (SQLException e) {
            LOG.info("Error while shutting down the connection", (Throwable)e);
        }
        try {
            if (!result.next()) {
                return null;
            }
            cadWKT = result.getString("iau_wkt");
        }
        catch (SQLException e1) {
            LOG.info("Error executing the SQL", (Throwable)e1);
            return null;
        }
        cadWKT = cadWKT.substring(0, cadWKT.length() - 1) + ", AUTHORITY[\"IAU2000\"," + Integer.parseInt(code) + "]]";
        if (cadWKT.charAt(0) == 'P') {
            Iau2wkt wk = new Iau2wkt(cadWKT);
            cadWKT = wk.getWkt();
        }
        try {
            crs = new Crs(Integer.parseInt(code), cadWKT);
        }
        catch (CrsException e) {
            LOG.info("Impossible to parse the CRS", (Throwable)e);
        }
        return crs;
    }

    public void dispose() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            LOG.warn("Con't shutdown the connection.", (Throwable)ex);
        }
    }
}

