/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import org.geotools.referencing.CRS;
import org.gvsig.crs.CrsGT;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.repository.ICrsRepository;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsrRepositoryGT
implements ICrsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(UsrRepositoryGT.class);

    public ICrs getCrs(String code) {
        CrsGT crsGT = null;
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)("USR:" + code));
            crsGT = new CrsGT(crs);
        }
        catch (NoSuchAuthorityCodeException e) {
            LOG.debug("Can't get the CRS '" + code + "' authority 'USR' in GT repository. No such authority code");
            return null;
        }
        catch (FactoryException e) {
            LOG.debug("Can't get the CRS '" + code + "' authority 'USR' in GT repository", (Throwable)e);
            return null;
        }
        return crsGT;
    }
}

