/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.AbstractIdentifyStrategy;

public class IdentifyEsriUsingProj4IterateAll
extends AbstractIdentifyStrategy {
    private int accuracy;
    private int best_dist = 1000;
    private int best_code = 0;

    public IdentifyEsriUsingProj4IterateAll() {
        this(5);
    }

    public IdentifyEsriUsingProj4IterateAll(int accuracy) {
        this.accuracy = accuracy;
    }

    public IdentifyEsriUsingProj4IterateAll setAccuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public int getBestAccuracy() {
        return this.best_dist;
    }

    public SpatialReference getBest() {
        SpatialReference sr = this.createSpatialReferenceFromEPSGCode(this.best_code);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpatialReference identify(SpatialReference sr) {
        block26: {
            String source_sr_name;
            String attr;
            String kind;
            if (this.autoIdentifyEPSG(sr)) {
                return sr;
            }
            String source_proj4 = this.getProj4String(sr);
            logger.debug("Source proj4: " + source_proj4);
            this.best_code = 0;
            this.best_dist = 1000;
            if (sr.IsGeographic() == 1) {
                kind = "geographic 2D";
                attr = "GEOGCS";
                source_sr_name = sr.GetAttrValue(attr);
                if (source_sr_name == null) {
                    return null;
                }
                StringUtils.replace((String)source_sr_name.toLowerCase(), (String)"_", (String)" ");
                if (StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 1989")) {
                    source_sr_name = "etrs89";
                }
            } else {
                if (sr.IsProjected() != 1) return null;
                kind = "projected";
                attr = "PROJCS";
                source_sr_name = sr.GetAttrValue(attr);
            }
            String sql = "SELECT DISTINCT coord_ref_sys_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_kind = '" + StringUtils.replace((String)kind, (String)"'", (String)"''") + "' AND deprecated = 0";
            EpsgConnection conn = null;
            try {
                conn = new EpsgConnection();
                conn.setConnectionEPSG();
                ResultSet result2 = Query.select(sql, conn.getConnection());
                while (result2.next()) {
                    SpatialReference target_sr;
                    int code = result2.getInt("coord_ref_sys_code");
                    try {
                        target_sr = new SpatialReference();
                        target_sr.ImportFromEPSG(code);
                        if (source_proj4 != null) {
                            sr.MorphFromESRI();
                            target_sr.MorphToESRI();
                            String target_proj4 = this.getProj4String(target_sr);
                            logger.debug("Target proj4: " + target_proj4);
                            if (StringUtils.equals((CharSequence)source_proj4, (CharSequence)target_proj4)) {
                                SpatialReference spatialReference = this.createSpatialReferenceFromEPSGCode(code);
                                return spatialReference;
                            }
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    {
                        String target_sr_name = StringUtils.lowerCase((String)target_sr.GetAttrValue(attr));
                        int dist = StringUtils.getLevenshteinDistance((CharSequence)source_sr_name, (CharSequence)(target_sr_name = StringUtils.replace((String)target_sr_name, (String)"_", (String)" ")));
                        if (dist >= this.best_dist) continue;
                        this.best_dist = dist;
                        this.best_code = code;
                        if (dist != 0) continue;
                    }
                }
                break block26;
            }
            catch (Exception result2) {
                try {
                    conn.close();
                }
                catch (Exception result2) {}
            }
            break block26;
            finally {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.best_code <= 0) return null;
        if (this.best_dist > this.accuracy) return null;
        logger.debug("EPSG:{} is the best match (Levenshtein Distance = {}).", (Object)this.best_code, (Object)this.best_dist);
        SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(this.best_code);
        if (sr2 == null) return null;
        return sr2;
    }
}

