/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.proj.lib.jcrs;

import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.gvsig.crs.Crs;
import org.gvsig.proj.CoordinateReferenceSystem;
import org.gvsig.proj.CoordinateTransformation;
import org.gvsig.proj.lib.jcrs.JCRSCoordinateReferenceSystem;

public class JCRSCoordinateTransformation
implements CoordinateTransformation {
    ICoordTrans ct = null;
    private JCRSCoordinateReferenceSystem source = null;
    private JCRSCoordinateReferenceSystem target = null;

    JCRSCoordinateTransformation(ICoordTrans ct) {
        this.ct = ct;
        this.source = new JCRSCoordinateReferenceSystem((Crs)this.ct.getPOrig());
        this.target = new JCRSCoordinateReferenceSystem((Crs)this.ct.getPDest());
    }

    public CoordinateReferenceSystem getSourceProjection() {
        return this.source;
    }

    public CoordinateReferenceSystem getTargetProjection() {
        return this.target;
    }

    public void convert(double[] pointxy) {
        Point2D.Double p = new Point2D.Double(pointxy[0], pointxy[1]);
        this.ct.convert((Point2D)p, (Point2D)p);
        pointxy[0] = ((Point2D)p).getX();
        pointxy[1] = ((Point2D)p).getY();
    }

    public CoordinateTransformation getReverse() {
        return new JCRSCoordinateTransformation(this.ct.getInverted());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

