/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.components.colors.ColorDefinitionView;
import com.jeta.forms.components.colors.ColorSelectorUtils;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.open.gui.framework.JETADialog;
import com.jeta.open.gui.utils.JETAToolbox;
import com.jeta.open.i18n.I18N;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ColorSelector
extends JComponent {
    private ColorProperty m_color_prop = new ColorProperty();
    private LinkedList m_listeners;
    private JTextField m_key_field;
    private Component m_color_well;
    private JButton m_definition_btn;
    private LinkedHashMap m_prepended_colors;
    private ColorSelectorController m_controller;

    public ColorSelector() {
        try {
            JButton btn;
            FormLayout layout = new FormLayout("center:pref,2dlu,pref,70dlu,24px,10px", "fill:pref");
            this.setLayout(layout);
            CellConstraints cc = new CellConstraints();
            Class<?> color_well_class = Class.forName("com.jeta.forms.components.colors.JETAColorWell");
            this.m_color_well = (Component)color_well_class.newInstance();
            this.m_color_well.setName("color.inkwell");
            this.add(this.m_color_well, cc.xy(1, 1, CellConstraints.CENTER, CellConstraints.CENTER));
            this.add((Component)new JLabel("L&F"), cc.xy(3, 1));
            this.m_key_field = new JTextField();
            this.m_key_field.setEnabled(false);
            this.m_key_field.setName("color.field");
            this.m_key_field.setText("constant");
            this.add((Component)this.m_key_field, cc.xy(4, 1));
            this.m_definition_btn = btn = new JButton();
            try {
                btn.setIcon(new ImageIcon(ColorSelector.class.getClassLoader().getResource("jeta.resources/images/forms/16x16/palette.png")));
                btn.setPreferredSize(new Dimension(24, 10));
            }
            catch (Exception e) {
                btn.setText("...");
            }
            this.add((Component)btn, cc.xy(5, 1));
            this.m_controller = new ColorSelectorController();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        this.m_listeners.add(listener);
    }

    public ColorProperty getColorProperty() {
        try {
            ColorProperty cprop = new ColorProperty();
            cprop.setValue(this.m_color_prop);
            cprop.setConstantColor(ColorSelectorUtils.getColor(this.m_color_well));
            cprop.setColorKey(this.getSelectedColorKey());
            return cprop;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.m_color_prop;
        }
    }

    public String getSelectedColorKey() {
        return this.m_key_field.getText();
    }

    public void notifyListeners() {
        if (this.m_listeners != null) {
            ActionEvent evt = new ActionEvent(this, 1001, this.getName());
            Iterator iter = this.m_listeners.iterator();
            while (iter.hasNext()) {
                ActionListener listener = (ActionListener)iter.next();
                listener.actionPerformed(evt);
            }
        }
    }

    public void prependColor(String key, Color c) {
        if (key == null) {
            return;
        }
        if (this.m_prepended_colors == null) {
            this.m_prepended_colors = new LinkedHashMap();
        }
        this.m_prepended_colors.put(key, c);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    public void setColorProperty(ColorProperty cprop) {
        try {
            this.m_color_prop.setValue(cprop);
            String color_name = cprop.getColorKey();
            this.setSelectedColor(color_name);
            ColorSelectorUtils.setColor(this.m_color_well, cprop.getColor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelectedColor(String cname) {
        if (cname == null) {
            this.m_key_field.setText("constant");
        } else {
            this.m_key_field.setText(cname);
        }
    }

    private class ColorSelectorController {
        private boolean m_silent = false;

        public ColorSelectorController() {
            ColorSelectorUtils.addActionListener(ColorSelector.this.m_color_well, new ColorWellClicked());
            ColorSelector.this.m_definition_btn.addActionListener(new DefinitionListener());
        }

        public void setSilent(boolean silent) {
            this.m_silent = silent;
        }

        public class DefinitionListener
        implements ActionListener {
            public void actionPerformed(ActionEvent evt) {
                ColorDefinitionView view = new ColorDefinitionView();
                if (ColorSelector.this.m_prepended_colors != null) {
                    Iterator iter = ColorSelector.this.m_prepended_colors.keySet().iterator();
                    while (iter.hasNext()) {
                        String cname = (String)iter.next();
                        Color c = (Color)ColorSelector.this.m_prepended_colors.get(cname);
                        view.prependColor(cname, c);
                    }
                }
                view.setColorProperty(ColorSelector.this.getColorProperty());
                JETADialog dlg = JETAToolbox.invokeDialog(view, ColorSelector.this, I18N.getLocalizedMessage("Color Definition"));
                if (dlg.isOk()) {
                    ColorSelector.this.setColorProperty(view.getColorProperty());
                    ColorSelector.this.notifyListeners();
                }
            }
        }

        public class ColorWellClicked
        implements ActionListener {
            public void actionPerformed(ActionEvent evt) {
                boolean silent = ColorSelectorController.this.m_silent;
                if (!silent) {
                    ColorSelectorController.this.setSilent(true);
                    ColorSelector.this.m_key_field.setText("constant");
                    ColorSelector.this.m_color_prop.setBrightness(0);
                    ColorSelector.this.m_color_prop.setBrightnessFactor(0.7f);
                    ColorSelectorController.this.setSilent(silent);
                    ColorSelector.this.notifyListeners();
                }
            }
        }
    }
}

