/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.separator;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class TitledSeparator
extends JPanel {
    private Font m_title_font;
    private Color m_title_color;
    private JLabel m_label;

    public TitledSeparator() {
        this("Title", 2);
    }

    public TitledSeparator(String text) {
        this(text, 2);
    }

    public TitledSeparator(String text, int alignment) {
        this.setLayout(new TitledSeparatorLayout());
        this.m_label = text == null ? new TitleLabel() : new TitleLabel(text);
        this.m_label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.m_label.setFont(UIManager.getFont("TitledBorder.font"));
        this.m_label.setVerticalAlignment(0);
        this.m_label.setHorizontalAlignment(alignment);
        this.createSeparator(this.m_label);
    }

    private void createSeparator(JLabel label) {
        this.removeAll();
        this.setOpaque(false);
        this.add(label);
        this.add(new JSeparator());
        if (label != null && label.getHorizontalAlignment() == 0) {
            this.add(new JSeparator());
        }
    }

    public int getAlignment() {
        return this.m_label.getHorizontalAlignment();
    }

    public Color getTitleColor() {
        return this.m_title_color == null ? UIManager.getColor("TitledBorder.titleColor") : this.m_title_color;
    }

    public Font getTitleFont() {
        return this.m_title_font == null ? UIManager.getFont("TitledBorder.font") : this.m_title_font;
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void setAlignment(int alignment) {
        if (this.m_label.getHorizontalAlignment() == alignment) {
            return;
        }
        this.m_label.setHorizontalAlignment(alignment);
        this.createSeparator(this.m_label);
    }

    public void setTitleColor(Color c) {
        this.m_title_color = c;
        if (this.m_label != null) {
            this.m_label.setForeground(c);
        }
    }

    public void setTitleFont(Font font) {
        this.m_title_font = font;
        if (this.m_label != null) {
            this.m_label.setFont(font);
        }
    }

    public void setText(String title) {
        this.m_label.setText(title);
    }

    private class TitledSeparatorLayout
    implements LayoutManager {
        private TitledSeparatorLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            JLabel label = this.getLabel(parent);
            Dimension labelSize = ((Component)label).getPreferredSize();
            Insets insets = parent.getInsets();
            int width = Math.max(1, labelSize.width + insets.left + insets.right);
            int height = Math.max(1, labelSize.height + insets.top + insets.bottom);
            return new Dimension(width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension size = parent.getSize();
                Insets insets = parent.getInsets();
                int width = size.width - insets.left - insets.right;
                JLabel label = this.getLabel(parent);
                Dimension labelSize = label.getPreferredSize();
                int labelWidth = labelSize.width;
                int labelHeight = labelSize.height;
                Component separator1 = parent.getComponent(1);
                int separatorHeight = separator1.getPreferredSize().height;
                FontMetrics metrics = label.getFontMetrics(label.getFont());
                int ascent = metrics.getMaxAscent();
                int hGapDlu = 3;
                int hGap = Sizes.dialogUnitXAsPixel(hGapDlu, label);
                int vOffset = 1 + (labelHeight - separatorHeight) / 2;
                int alignment = label.getHorizontalAlignment();
                int y = insets.top;
                if (alignment == 2) {
                    int x = insets.left;
                    label.setBounds(x, y, labelWidth, labelHeight);
                    x += labelWidth;
                    int separatorWidth = size.width - insets.right - (x += hGap);
                    separator1.setBounds(x, y + vOffset, separatorWidth, separatorHeight);
                } else if (alignment == 4) {
                    int x = insets.left + width - labelWidth;
                    label.setBounds(x, y, labelWidth, labelHeight);
                    x -= hGap;
                    int separatorWidth = --x - insets.left;
                    separator1.setBounds(insets.left, y + vOffset, separatorWidth, separatorHeight);
                } else {
                    int xOffset = (width - labelWidth - 2 * hGap) / 2;
                    int x = insets.left;
                    separator1.setBounds(x, y + vOffset, xOffset - 1, separatorHeight);
                    x += xOffset;
                    label.setBounds(x += hGap, y, labelWidth, labelHeight);
                    x += labelWidth;
                    Component separator2 = parent.getComponent(2);
                    int separatorWidth = size.width - insets.right - (x += hGap);
                    separator2.setBounds(x, y + vOffset, separatorWidth, separatorHeight);
                }
            }
        }

        private JLabel getLabel(Container parent) {
            return TitledSeparator.this.m_label;
        }
    }

    private class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        private TitleLabel(String text) {
            super(text);
        }

        public void updateUI() {
            super.updateUI();
            if (TitledSeparator.this.m_label != null) {
                TitledSeparator.this.m_label.setForeground(TitledSeparator.this.getTitleColor());
                TitledSeparator.this.m_label.setFont(TitledSeparator.this.getTitleFont());
            }
        }
    }
}

