/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.TextureProperty;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class TexturePainter
implements Painter {
    private TextureProperty m_texture_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect;

    public TexturePainter() {
    }

    public TexturePainter(TextureProperty prop) {
        this.m_texture_prop = prop;
    }

    private Paint createPaint(Rectangle rect, TextureProperty tp) {
        BufferedImage bi = tp.getBufferedImage();
        rect = new Rectangle(0, 0, bi.getWidth(), bi.getHeight());
        return new TexturePaint(bi, rect);
    }

    public void paint(Component c, Graphics g, Rectangle rect) {
        if (rect == null || this.m_texture_prop == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint old_paint = g2.getPaint();
        if (this.m_cached_paint == null || !rect.equals(this.m_last_rect)) {
            this.m_last_rect = rect;
            this.m_cached_paint = this.createPaint(rect, this.m_texture_prop);
        }
        g2.setPaint(this.m_cached_paint);
        g2.translate(rect.x, rect.y);
        g.fillRect(0, 0, rect.width, rect.height);
        g2.translate(-rect.x, -rect.y);
        g2.setPaint(old_paint);
    }

    public void setTextureProperty(TextureProperty prop) {
        this.m_cached_paint = null;
        this.m_texture_prop = prop;
    }
}

