/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.focus;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormContainerComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.store.memento.CompositeFocusKey;
import com.jeta.forms.store.memento.ContainerFocusKey;
import com.jeta.forms.store.memento.FocusKey;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormCellFocusKey;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;

public class FormFocusManager {
    private FormComponent m_form;
    private ArrayList m_focus_list;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FormFocusManager(FormComponent fc) {
        this.disableChildFocusCycleRoots(fc);
        fc.setFocusCycleRoot(true);
        this.m_form = fc;
        ArrayList stored_focus_set = this.buildStoredFocusList(fc);
        LinkedHashSet default_focus_set = FormFocusManager.buildDefaultFocusPolicy(fc);
        Iterator iter = stored_focus_set.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (default_focus_set.contains(comp)) continue;
            iter.remove();
        }
        HashSet<Component> stored_lookup = new HashSet<Component>();
        stored_lookup.addAll(stored_focus_set);
        Component prev_comp = null;
        iter = default_focus_set.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (!stored_lookup.contains(comp)) {
                stored_lookup.add(comp);
                if (prev_comp == null) {
                    stored_focus_set.add(0, comp);
                } else {
                    int pos = stored_focus_set.indexOf(prev_comp);
                    if (!$assertionsDisabled && pos < 0) {
                        throw new AssertionError();
                    }
                    if (pos >= 0) {
                        stored_focus_set.add(pos + 1, comp);
                    }
                }
            }
            prev_comp = comp;
        }
        this.m_focus_list = stored_focus_set;
    }

    public FormFocusManager(FormComponent rootForm, Collection focusList) {
        this.m_form = rootForm;
        this.m_focus_list = new ArrayList(focusList);
    }

    public static LinkedHashSet buildDefaultFocusPolicy(FormComponent fc) {
        System.out.println("buildDefaultFocusPolicy  form: " + fc.getId());
        final FormComponent theform = fc;
        LinkedHashSet<Component> default_policy = new LinkedHashSet<Component>();
        LayoutFocusTraversalPolicy policy = new LayoutFocusTraversalPolicy(){

            protected boolean accept(Component aComponent) {
                if (aComponent instanceof StandardComponent && ((StandardComponent)aComponent).getBeanDelegate() == null) {
                    return false;
                }
                if (aComponent == theform) {
                    return super.accept(aComponent);
                }
                if (aComponent instanceof FormComponent && ((FormComponent)aComponent).isTopLevelForm()) {
                    return false;
                }
                if (aComponent instanceof JTabbedPane) {
                    return true;
                }
                if (aComponent != null) {
                    for (Container cc = aComponent.getParent(); cc != null && cc != theform; cc = cc.getParent()) {
                        if (!(cc instanceof FormContainerComponent)) continue;
                        return false;
                    }
                }
                return super.accept(aComponent);
            }
        };
        Component comp = policy.getFirstComponent(fc);
        Component last_comp = policy.getLastComponent(fc);
        while (true) {
            if (FormUtils.isDesignMode()) {
                if (!(comp instanceof JScrollPane) && !(comp instanceof JScrollBar)) {
                    default_policy.add(comp);
                }
            } else {
                default_policy.add(comp);
            }
            if (comp == last_comp) break;
            System.out.println("FormFocusManager.getComponentAfter: " + comp.getClass());
            comp = policy.getComponentAfter(fc, comp);
        }
        return default_policy;
    }

    ArrayList buildStoredFocusList(FormComponent form) {
        ArrayList<Component> focus_list = new ArrayList<Component>();
        FocusPolicyMemento memento = form.getFocusPolicy();
        if (memento != null) {
            Collection fkeys = memento.getFocusPolicyKeys();
            Iterator iter = fkeys.iterator();
            while (iter.hasNext()) {
                FocusKey fkey = (FocusKey)iter.next();
                Component comp = fkey.getComponent(form);
                if (comp == null) continue;
                focus_list.add(comp);
            }
        }
        return focus_list;
    }

    public void buildFocusKeys(HashSet currentFocusSet, HashMap focus_key_map, FormComponent form, CompositeFocusKey compositeKey) {
        for (int row = 1; row <= form.getRowCount(); ++row) {
            for (int col = 1; col <= form.getColumnCount(); ++col) {
                CompositeFocusKey ckey;
                GridComponent gc = form.getGridComponent(col, row);
                if (gc instanceof StandardComponent) {
                    Component comp = gc.getBeanDelegate();
                    if (comp == null) continue;
                    if (currentFocusSet.contains(comp)) {
                        ckey = (CompositeFocusKey)compositeKey.clone();
                        ckey.add(new FormCellFocusKey(row, col, comp));
                        focus_key_map.put(comp, ckey);
                        continue;
                    }
                    if (!(comp instanceof Container)) continue;
                    ckey = (CompositeFocusKey)compositeKey.clone();
                    ckey.add(new FormCellFocusKey(row, col, comp));
                    this.buildContainerFocusKeys(currentFocusSet, focus_key_map, (Container)comp, ckey);
                    continue;
                }
                if (gc instanceof FormComponent) {
                    FormComponent childform = (FormComponent)gc;
                    ckey = (CompositeFocusKey)compositeKey.clone();
                    ckey.add(new FormCellFocusKey(row, col, gc));
                    this.buildFocusKeys(currentFocusSet, focus_key_map, childform, ckey);
                    continue;
                }
                if (gc == null) continue;
                System.out.println("FormFocusManager.buildDefaultPolicyFailed  found unknown comp: " + gc.getClass());
            }
        }
    }

    public void buildContainerFocusKeys(HashSet currentFocusSet, HashMap focus_key_map, Container container, CompositeFocusKey compositeKey) {
        for (int index = 0; index < container.getComponentCount(); ++index) {
            CompositeFocusKey ckey;
            Component comp = container.getComponent(index);
            if (currentFocusSet.contains(comp)) {
                ckey = (CompositeFocusKey)compositeKey.clone();
                ckey.add(new ContainerFocusKey(index, comp));
                focus_key_map.put(comp, ckey);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            ckey = (CompositeFocusKey)compositeKey.clone();
            ckey.add(new ContainerFocusKey(index, comp));
            this.buildContainerFocusKeys(currentFocusSet, focus_key_map, (Container)comp, ckey);
        }
    }

    public boolean contains(Component comp) {
        return this.m_focus_list.contains(comp);
    }

    private void disableChildFocusCycleRoots(Container cc) {
        if (cc == null) {
            return;
        }
        for (int index = 0; index < cc.getComponentCount(); ++index) {
            Component comp = cc.getComponent(index);
            if (comp instanceof StandardComponent || comp instanceof FormPanel) {
                ((Container)comp).setFocusCycleRoot(false);
                this.disableChildFocusCycleRoots((Container)comp);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.disableChildFocusCycleRoots((Container)comp);
        }
    }

    public FocusPolicyMemento getFocusPolicyMemento() {
        HashSet current_focus_set = new HashSet();
        current_focus_set.addAll(this.m_focus_list);
        HashMap focus_key_map = new HashMap();
        CompositeFocusKey cfk = new CompositeFocusKey();
        this.buildFocusKeys(current_focus_set, focus_key_map, this.m_form, cfk);
        FocusPolicyMemento memento = new FocusPolicyMemento();
        Iterator iter = this.m_focus_list.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            FocusKey fkey = (FocusKey)focus_key_map.get(comp);
            if (fkey == null) continue;
            memento.addFocusKey(fkey);
        }
        return memento;
    }

    public Component getComponent(int index) {
        if (index < 0 || index >= this.m_focus_list.size()) {
            return null;
        }
        return (Component)this.m_focus_list.get(index);
    }

    public int getComponentCount() {
        return this.m_focus_list.size();
    }

    public Collection getFocusList() {
        if (this.m_focus_list == null) {
            return EmptyCollection.getInstance();
        }
        return this.m_focus_list;
    }

    public void validateFocusKeys(FormComponent root, FocusPolicyMemento memento) {
        Iterator iter = memento.getFocusPolicyKeys().iterator();
        while (iter.hasNext()) {
            FocusKey fkey = (FocusKey)iter.next();
            Component comp = fkey.getComponent(root);
            if (!$assertionsDisabled && comp == null) {
                throw new AssertionError();
            }
            System.out.print("Focuskey validated: ");
            fkey.print();
            System.out.println("   comp: " + comp.getClass());
        }
    }

    static {
        $assertionsDisabled = !FormFocusManager.class.desiredAssertionStatus();
    }
}

