/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;

public class GridViewEvent {
    private int m_id;
    private GridView m_source;
    private GridCellEvent m_comp_event;
    public static final int ROW_ADDED = 1;
    public static final int ROW_DELETED = 2;
    public static final int ROW_SPEC_CHANGED = 3;
    public static final int COLUMN_ADDED = 4;
    public static final int COLUMN_DELETED = 5;
    public static final int COLUMN_SPEC_CHANGED = 7;
    public static final int CELL_CHANGED = 8;
    public static final int EDIT_COMPONENT = 9;
    public static final int CELL_SELECTED = 10;
    public static final int ROW_GROUPS_CHANGED = 11;
    public static final int COLUMN_GROUPS_CHANGED = 12;

    public GridViewEvent(GridView src, int id) {
        this.m_id = id;
        this.m_source = src;
    }

    public GridViewEvent(GridView src, int id, GridComponent gc) {
        this.m_id = id;
        this.m_source = src;
        this.m_comp_event = new GridCellEvent(id, gc, null);
    }

    public GridViewEvent(GridView src, int id, GridCellEvent srcEvent) {
        this.m_id = id;
        this.m_source = src;
        this.m_comp_event = srcEvent;
    }

    public int getId() {
        return this.m_id;
    }

    public String getCommand() {
        if (this.m_comp_event != null) {
            return this.m_comp_event.getCommand();
        }
        return null;
    }

    public GridComponent getComponent() {
        if (this.m_comp_event != null) {
            return this.m_comp_event.getSource();
        }
        return null;
    }

    public GridCellEvent getComponentEvent() {
        return this.m_comp_event;
    }

    public GridView getSource() {
        return this.m_source;
    }

    public void print() {
        String sid = "UNKNOWN";
        if (this.m_id == 1) {
            sid = "ROW_ADDED";
        } else if (this.m_id == 2) {
            sid = "ROW_DELETED";
        } else if (this.m_id == 3) {
            sid = "ROW_SPEC_CHANGED";
        } else if (this.m_id == 4) {
            sid = "COLUMN_ADDED";
        } else if (this.m_id == 5) {
            sid = "COLUMN_DELETED";
        } else if (this.m_id == 7) {
            sid = "COLUMN_SPEC_CHANGED";
        } else if (this.m_id == 8) {
            sid = "CELL_CHANGED";
        } else if (this.m_id == 9) {
            sid = "EDIT_COMPONENT";
        } else if (this.m_id == 10) {
            sid = "CELL_SELECTED";
        } else if (this.m_id == 11) {
            sid = "ROW_GROUPS_CHANGED";
        } else if (this.m_id == 12) {
            sid = "COLUMN_GROUPS_CHANGED";
        }
        System.out.println("GridViewEvent:  id = " + sid + "  component: " + this.getComponent());
    }
}

