/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.StateRequest;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class StandardComponent
extends GridComponent {
    private static Border m_design_border = BorderFactory.createEmptyBorder(2, 2, 2, 2);

    public StandardComponent() {
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public StandardComponent(GridView parentView) {
        super(parentView);
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public StandardComponent(JETABean jbean, GridView parentView) {
        super(jbean, parentView);
        this.setBean(jbean);
        if (FormUtils.isDesignMode()) {
            this.setBorder(m_design_border);
        }
    }

    public ComponentMemento getState(StateRequest sr) throws FormException {
        BeanMemento bm = new BeanMemento();
        bm.setCellConstraints(this.getConstraints().createCellConstraints());
        bm.setComponentClass(this.getClass().getName());
        JETABean jbean = this.getBean();
        if (jbean != null) {
            jbean.getState(bm, sr);
        }
        return bm;
    }

    public void print() {
        JETABean jbean = this.getBean();
        if (jbean == null) {
            System.out.println("StandardComponent  name = " + this.getName() + "   hash: " + this.hashCode() + "   bean:  null");
        } else {
            System.out.println("StandardComponent  name = " + this.getName() + "   hash: " + this.hashCode() + "   bean: " + jbean.getDelegate());
        }
    }

    public void postInitialize(FormPanel panel) {
        JETABean jbean = this.getBean();
        if (jbean != null) {
            jbean.postInitialize(panel);
        }
    }

    protected void setBean(JETABean jetabean) {
        FormUtils.safeAssert(this.getComponentCount() == 0);
        super.setBean(jetabean);
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (jetabean != null) {
            this.add((Component)jetabean, "Center");
        }
    }

    public void setState(ComponentMemento state) throws FormException {
        try {
            JETABean jbean;
            BeanMemento bm = (BeanMemento)state;
            if (FormUtils.isRuntime()) {
                JETABeanFactory.tryRegisterCustomFactory(bm.getBeanClass(), true);
            }
            if ((jbean = JETABeanFactory.createBean(bm.getBeanClass(), null, false, true)) == null) {
                jbean = new JETABean();
            }
            if (jbean != null) {
                this.setBean(jbean);
                jbean.setState(bm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

