/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.components.border.JETALineBorder;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ColorProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import javax.swing.border.Border;

public class LineBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -2679973957505795245L;
    private static final int VERSION = 3;
    private int m_line_thickness = 1;
    private ColorProperty m_line_color = new ColorProperty(Color.black);
    private boolean m_curved = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Border createBorder(Component comp) {
        JETALineBorder b = new JETALineBorder(new ColorProxy(this.m_line_color), this.getLineThickness(), this.isCurved(), this.isTopPainted(), this.isLeftPainted(), this.isBottomPainted(), this.isRightPainted());
        return this.createTitle(b);
    }

    public int getLineThickness() {
        return this.m_line_thickness;
    }

    public Color getLineColor() {
        return this.m_line_color.getColor();
    }

    public ColorProperty getLineColorProperty() {
        return this.m_line_color;
    }

    public boolean isCurved() {
        return this.m_curved;
    }

    public void setCurved(boolean bcurve) {
        this.m_curved = bcurve;
    }

    public void setLineThickness(int thickness) {
        this.m_line_thickness = thickness;
    }

    public void setLineColorProperty(ColorProperty c) {
        this.m_line_color = c;
    }

    public void setValue(Object prop) {
        super.setValue(prop);
        if (prop instanceof LineBorderProperty) {
            LineBorderProperty bp = (LineBorderProperty)prop;
            this.m_line_color.setValue(bp.m_line_color);
            this.m_line_thickness = bp.m_line_thickness;
            this.m_curved = bp.m_curved;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_line_thickness = in.readInt("thickness");
        Object color = in.readObject("color");
        if (version > 1) {
            this.m_curved = in.readBoolean("curved");
        }
        this.m_line_color = color instanceof Color ? new ColorProperty((Color)color) : (ColorProperty)color;
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(BorderProperty.class));
        out.writeVersion(3);
        out.writeInt("thickness", this.m_line_thickness);
        out.writeObject("color", this.m_line_color);
        out.writeBoolean("curved", this.m_curved);
    }

    public String toString() {
        return "LINE";
    }

    static {
        $assertionsDisabled = !LineBorderProperty.class.desiredAssertionStatus();
    }
}

