/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.arc;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDouble;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcByCenterEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final String CCW = "CCW";
    private static final String CW = "CW";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcByCenterEditingProvider.class);
    private final EditingServiceParameter radius;
    private final EditingServiceParameter startAngle;
    private final EditingServiceParameter sweepAngle;
    private final EditingServiceParameter direction;
    private final EditingServiceParameter centerPoint;
    private final EditingServiceParameter startPoint;
    private final EditingServiceParameter endPoint;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;

    public ArcByCenterEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.centerPoint = new DefaultEditingServiceParameter("center_point", "center_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.startPoint = new DefaultEditingServiceParameter("start_point", "start_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.endPoint = new DefaultEditingServiceParameter("end_point", "end_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.radius = new DefaultEditingServiceParameter("radius", "radius", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.startAngle = new DefaultEditingServiceParameter("start_angle", "start_angle", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.sweepAngle = new DefaultEditingServiceParameter("sweep_angle", "sweep_angle", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions directionOptions = new DefaultEditingServiceParameterOptions().add(CCW, (Object)CCW, CCW).add(CW, (Object)CW, CW);
        String consoleMsg = editingProviderServices.makeConsoleMessage("_Direction", (EditingServiceParameterOptions)directionOptions);
        this.direction = new DefaultEditingServiceParameter(i18nManager.getTranslation("_Direction"), consoleMsg, (EditingServiceParameterOptions)directionOptions, null, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(8);
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.centerPoint) == null) {
            return this.centerPoint;
        }
        if (this.values.get(this.startPoint) == null && (this.values.get(this.radius) == null || this.values.get(this.startAngle) == null)) {
            return this.startPoint;
        }
        if (this.values.get(this.endPoint) == null) {
            return this.endPoint;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        block37: {
            Point centerPointValue = (Point)this.values.get(this.centerPoint);
            Point startPointValue = (Point)this.values.get(this.startPoint);
            Point endPointValue = (Point)this.values.get(this.endPoint);
            Double radiusValue = (Double)this.values.get(this.radius);
            Double startAngleValue = (Double)this.values.get(this.startAngle);
            Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
            String directionValue = (String)this.values.get(this.direction);
            DefaultDrawingStatus geometries = new DefaultDrawingStatus();
            ISymbol previewSymbol = this.getPreviewSymbol();
            geometries.setPreviewSymbol(previewSymbol);
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
            if (this.values != null) {
                if (centerPointValue == null) {
                    if (radiusValue != null && startAngleValue != null) {
                        try {
                            startPointValue = GeometryUtils.createPoint((Point)mousePosition, (double)radiusValue, (double)startAngleValue);
                            geometries.addStatus((Geometry)startPointValue, auxiliaryPointSymbolEditing, "");
                            Line auxLine = GeometryUtils.createLine((Point)mousePosition, (Point)startPointValue, (int)2);
                            geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                            if (sweepAngleValue != null && directionValue != null) {
                                this.addArcAndEndPointToDrawingStatus(geometries, mousePosition, radiusValue, startAngleValue, startPointValue, sweepAngleValue, directionValue);
                            }
                            return geometries;
                        }
                        catch (CreateGeometryException | GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new DrawServiceException(ex);
                        }
                    }
                } else {
                    geometries.addStatus((Geometry)centerPointValue, auxiliaryPointSymbolEditing, "");
                    if (startPointValue == null) {
                        try {
                            if (radiusValue != null && startAngleValue != null) {
                                startPointValue = GeometryUtils.createPoint((Point)centerPointValue, (double)radiusValue, (double)startAngleValue);
                                this.addArcAndEndPointToDrawingStatus(geometries, centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue, directionValue);
                            } else if (radiusValue != null) {
                                double distance = centerPointValue.distance((Geometry)mousePosition);
                                Point auxStartPoint = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * ((mousePosition.getX() - centerPointValue.getX()) / distance)), (double)(centerPointValue.getY() + radiusValue * ((mousePosition.getY() - centerPointValue.getY()) / distance)));
                                geometries.addStatus((Geometry)auxStartPoint, auxiliaryPointSymbolEditing, "");
                                Line auxLine = GeometryUtils.createLine((Point)centerPointValue, (Point)auxStartPoint, (int)2);
                                geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                                this.addArcAndEndPointToDrawingStatus(geometries, centerPointValue, radiusValue, GeometryUtils.calculateAngle((Point)centerPointValue, (Point)auxStartPoint), auxStartPoint, sweepAngleValue, directionValue);
                            } else if (startAngleValue != null) {
                                EuclideanLine2D auxLine;
                                Point auxStartPoint;
                                double m = Math.tan(startAngleValue);
                                if (Double.isInfinite(m)) {
                                    auxStartPoint = GeometryUtils.createPoint((double)centerPointValue.getX(), (double)mousePosition.getY());
                                } else {
                                    auxLine = euclideanManager.createLine2D(m, euclideanManager.getYIntercept(m, centerPointValue.getX(), centerPointValue.getY()));
                                    double anglePointValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)mousePosition);
                                    double x = centerPointValue.getX();
                                    double y = centerPointValue.getY();
                                    if (Double.isInfinite(m)) {
                                        auxStartPoint = GeometryUtils.createPoint((double)centerPointValue.getX(), (double)mousePosition.getY());
                                    } else if (m == 0.0) {
                                        auxStartPoint = GeometryUtils.createPoint((double)mousePosition.getX(), (double)centerPointValue.getY());
                                    } else {
                                        if (Math.signum(Math.cos(startAngleValue)) == Math.signum(Math.cos(anglePointValue))) {
                                            x = mousePosition.getX();
                                        }
                                        if (Math.signum(Math.sin(startAngleValue)) == Math.signum(Math.sin(anglePointValue))) {
                                            y = mousePosition.getY();
                                        }
                                        Point2D proyected = auxLine.getNearestPoint(x, y);
                                        auxStartPoint = GeometryUtils.createPoint((double)proyected.getX(), (double)proyected.getY());
                                    }
                                }
                                geometries.addStatus((Geometry)auxStartPoint, auxiliaryPointSymbolEditing, "");
                                auxLine = GeometryUtils.createLine((Point)centerPointValue, (Point)auxStartPoint, (int)2);
                                geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                                this.addArcAndEndPointToDrawingStatus(geometries, centerPointValue, centerPointValue.distance((Geometry)auxStartPoint), startAngleValue, auxStartPoint, sweepAngleValue, directionValue);
                            } else {
                                geometries.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                                Line auxLine = GeometryUtils.createLine((Point)centerPointValue, (Point)mousePosition, (int)2);
                                geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                                this.addArcAndEndPointToDrawingStatus(geometries, centerPointValue, centerPointValue.distance((Geometry)mousePosition), GeometryUtils.calculateAngle((Point)centerPointValue, (Point)mousePosition), mousePosition, sweepAngleValue, directionValue);
                            }
                        }
                        catch (CreateGeometryException | GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new DrawServiceException(ex);
                        }
                        return geometries;
                    }
                    if (endPointValue == null) {
                        try {
                            Line startLine = GeometryUtils.createLine((double)centerPointValue.getX(), (double)centerPointValue.getY(), (double)startPointValue.getX(), (double)startPointValue.getY(), (int)2);
                            geometries.addStatus((Geometry)startPointValue, auxiliaryPointSymbolEditing, "");
                            geometries.addStatus((Geometry)startLine, auxiliaryLineSymbolEditing, "");
                            if (radiusValue == null) {
                                radiusValue = centerPointValue.distance((Geometry)startPointValue);
                            }
                            if (startAngleValue == null) {
                                startAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue);
                            }
                            double coefDirection = GeometryUtils.getCoefDirection((Point)centerPointValue, (Point)startPointValue, (Point)mousePosition);
                            if (sweepAngleValue != null) {
                                if (directionValue == null) {
                                    Point auxPoint = this.calculateEndPoint(centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                                    geometries.addStatus((Geometry)auxPoint, auxiliaryPointSymbolEditing, "");
                                    if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                                        sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                                    }
                                    Arc auxArc = GeometryUtils.createArc((Point)centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                                    geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
                                    geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                                    return geometries;
                                }
                                break block37;
                            }
                            double distance = centerPointValue.distance((Geometry)mousePosition);
                            Point point = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * ((mousePosition.getX() - centerPointValue.getX()) / distance)), (double)(centerPointValue.getY() + radiusValue * ((mousePosition.getY() - centerPointValue.getY()) / distance)));
                            geometries.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
                            Line auxLine = GeometryUtils.createLine((Point)centerPointValue, (Point)point, (int)2);
                            geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                            sweepAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue, (Point)mousePosition);
                            if (directionValue != null) {
                                if (directionValue.equalsIgnoreCase(CW)) {
                                    sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                                }
                            } else if (coefDirection < 0.0) {
                                sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                            }
                            if (Math.abs(sweepAngleValue) > 0.0) {
                                Arc auxArc = GeometryUtils.createArc((Point)centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                                geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
                                geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                            }
                            return geometries;
                        }
                        catch (CreateGeometryException | GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new DrawServiceException(ex);
                        }
                    }
                }
            }
        }
        return null;
    }

    private void addArcAndEndPointToDrawingStatus(DefaultDrawingStatus geometries, Point centerValue, Double radiusValue, Double startAngleValue, Point startPointValue, Double sweepAngleValue, String directionValue) throws GeometryOperationException, GeometryOperationNotSupportedException, CreateGeometryException {
        if (sweepAngleValue != null && directionValue != null) {
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            Point auxEndPoint = this.calculateEndPoint(centerValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
            geometries.addStatus((Geometry)auxEndPoint, auxiliaryPointSymbolEditing, "");
            double coefDirection = GeometryUtils.getCoefDirection((Point)centerValue, (Point)startPointValue, (Point)auxEndPoint);
            if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
            }
            if (directionValue.equalsIgnoreCase(CW)) {
                sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
            }
            Arc auxArc = GeometryUtils.createArc((Point)centerValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
            geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
            geometries.addStatus((Geometry)auxArc, geometries.getPreviewSymbol(), "");
        }
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.centerPoint);
        parameters.add(this.startPoint);
        parameters.add(this.endPoint);
        parameters.add(this.radius);
        parameters.add(this.startAngle);
        parameters.add(this.sweepAngle);
        parameters.add(this.direction);
        return parameters;
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.setValue(param, value);
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
        this.removeRelatedParams(parameter);
        this.fillEmptyParams();
    }

    private void removeRelatedParams(EditingServiceParameter parameter) {
        if (parameter == this.startAngle) {
            this.values.remove(this.startPoint);
            return;
        }
        if (parameter == this.radius) {
            this.values.remove(this.startPoint);
            return;
        }
        if (parameter == this.sweepAngle) {
            this.values.remove(this.endPoint);
        }
        if (parameter == this.direction) {
            this.values.remove(this.endPoint);
        }
    }

    private void fillEmptyParams() throws InvalidEntryException {
        Point centerPointValue = (Point)this.values.get(this.centerPoint);
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        Double radiusValue = (Double)this.values.get(this.radius);
        Double startAngleValue = (Double)this.values.get(this.startAngle);
        Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
        String directionValue = (String)this.values.get(this.direction);
        if (startPointValue == null && centerPointValue != null && radiusValue != null && startAngleValue != null) {
            startPointValue = GeometryUtils.createPoint((Point)centerPointValue, (double)radiusValue, (double)startAngleValue);
            this.values.put(this.startPoint, startPointValue);
        }
        if (radiusValue == null && centerPointValue != null && startPointValue != null) {
            try {
                radiusValue = centerPointValue.distance((Geometry)startPointValue);
                this.values.put(this.radius, radiusValue);
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                throw new InvalidEntryException(ex);
            }
        }
        if (startAngleValue == null && centerPointValue != null && startPointValue != null) {
            startAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue);
            this.values.put(this.startAngle, startAngleValue);
        }
        if (sweepAngleValue == null && startPointValue != null && endPointValue != null) {
            sweepAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue, (Point)endPointValue);
            this.values.put(this.sweepAngle, sweepAngleValue);
        }
        if (endPointValue == null && centerPointValue != null && startPointValue != null && sweepAngleValue != null && directionValue != null) {
            try {
                endPointValue = this.calculateEndPoint(centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                this.values.put(this.endPoint, endPointValue);
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                throw new InvalidEntryException(ex);
            }
        }
        if (sweepAngleValue == null && centerPointValue != null && startPointValue != null && endPointValue != null) {
            sweepAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue, (Point)endPointValue);
            this.values.put(this.sweepAngle, sweepAngleValue);
        }
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        block46: {
            EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
            CoerceToDouble coerceToDouble = new CoerceToDouble();
            if (param == this.centerPoint) {
                if (value instanceof Point) {
                    this.values.put(param, value);
                    return;
                }
            } else if (param == this.startPoint) {
                if (value instanceof Point) {
                    Point pointValue = (Point)value;
                    Point centerPointValue = (Point)this.values.get(this.centerPoint);
                    Double radiusValue = (Double)this.values.get(this.radius);
                    Double startAngleValue = (Double)this.values.get(this.startAngle);
                    if (radiusValue != null) {
                        try {
                            double distance = centerPointValue.distance((Geometry)pointValue);
                            Point point = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * ((pointValue.getX() - centerPointValue.getX()) / distance)), (double)(centerPointValue.getY() + radiusValue * ((pointValue.getY() - centerPointValue.getY()) / distance)));
                            this.values.put(param, point);
                            return;
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new InvalidEntryException(ex);
                        }
                    }
                    if (startAngleValue != null) {
                        Point point;
                        double m = Math.tan(startAngleValue);
                        double anglePointValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)pointValue);
                        double x = centerPointValue.getX();
                        double y = centerPointValue.getY();
                        if (Double.isInfinite(m)) {
                            point = GeometryUtils.createPoint((double)centerPointValue.getX(), (double)pointValue.getY());
                        } else if (m == 0.0) {
                            point = GeometryUtils.createPoint((double)pointValue.getX(), (double)centerPointValue.getY());
                        } else {
                            if (Math.signum(Math.cos(startAngleValue)) == Math.signum(Math.cos(anglePointValue))) {
                                x = pointValue.getX();
                            }
                            if (Math.signum(Math.sin(startAngleValue)) == Math.signum(Math.sin(anglePointValue))) {
                                y = pointValue.getY();
                            }
                            EuclideanLine2D auxLine = euclideanManager.createLine2D(m, euclideanManager.getYIntercept(m, centerPointValue.getX(), centerPointValue.getY()));
                            Point2D proyected = auxLine.getNearestPoint(x, y);
                            point = GeometryUtils.createPoint((double)proyected.getX(), (double)proyected.getY());
                        }
                        this.values.put(param, point);
                        return;
                    }
                    this.values.put(param, pointValue);
                    this.values.put(param, value);
                    return;
                }
            } else if (param == this.endPoint) {
                if (value instanceof Point) {
                    double module;
                    Point endPointValue;
                    Point pointValue = (Point)value;
                    Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
                    String directionValue = (String)this.values.get(this.direction);
                    Point centerPointValue = (Point)this.values.get(this.centerPoint);
                    Point startPointValue = (Point)this.values.get(this.startPoint);
                    Double radiusValue = (Double)this.values.get(this.radius);
                    Double startAngleValue = (Double)this.values.get(this.startAngle);
                    if (startPointValue == null && radiusValue != null && startAngleValue != null) {
                        startPointValue = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * Math.cos(startAngleValue)), (double)(centerPointValue.getY() + radiusValue * Math.sin(startAngleValue)));
                    }
                    if (sweepAngleValue != null) {
                        if (directionValue == null) {
                            double coefDirection = GeometryUtils.getCoefDirection((Point)centerPointValue, (Point)startPointValue, (Point)pointValue);
                            if (coefDirection >= 0.0) {
                                this.values.put(this.direction, CCW);
                            } else {
                                this.values.put(this.direction, CW);
                            }
                        }
                        try {
                            endPointValue = this.calculateEndPoint(centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new InvalidEntryException(ex);
                        }
                    }
                    if (radiusValue == null) {
                        try {
                            radiusValue = centerPointValue.distance((Geometry)startPointValue);
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new InvalidEntryException(ex);
                        }
                    }
                    try {
                        module = centerPointValue.distance((Geometry)pointValue);
                    }
                    catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                        throw new InvalidEntryException(ex);
                    }
                    endPointValue = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * (pointValue.getX() - centerPointValue.getX()) / module), (double)(centerPointValue.getY() + radiusValue * (pointValue.getY() - centerPointValue.getY()) / module));
                    this.values.put(this.endPoint, endPointValue);
                    return;
                }
            } else {
                if (param == this.radius) {
                    try {
                        Double doubleValue = (Double)coerceToDouble.coerce(value);
                        if (doubleValue != null && Double.isFinite(doubleValue) && doubleValue - 0.01 > 0.0) {
                            this.values.put(param, doubleValue);
                            return;
                        }
                        break block46;
                    }
                    catch (CoercionException ex) {
                        throw new InvalidEntryException(null);
                    }
                }
                if (param == this.startAngle) {
                    try {
                        Double doubleValue = (Double)coerceToDouble.coerce(value);
                        if (doubleValue != null && Double.isFinite(doubleValue)) {
                            this.values.put(param, Math.toRadians(doubleValue));
                            return;
                        }
                        break block46;
                    }
                    catch (CoercionException ex) {
                        throw new InvalidEntryException((Throwable)ex);
                    }
                }
                if (param == this.sweepAngle) {
                    try {
                        Double doubleValue = (Double)coerceToDouble.coerce(value);
                        if (doubleValue != null && Double.isFinite(doubleValue)) {
                            this.values.put(param, Math.toRadians(doubleValue));
                            return;
                        }
                        break block46;
                    }
                    catch (CoercionException ex) {
                        throw new InvalidEntryException(null);
                    }
                }
                if (param == this.direction && value instanceof String) {
                    if (((String)value).trim().equalsIgnoreCase(CCW)) {
                        this.values.put(param, CCW);
                        return;
                    }
                    if (((String)value).trim().equalsIgnoreCase(CW)) {
                        this.values.put(param, CW);
                        return;
                    }
                }
            }
        }
        throw new InvalidEntryException(null);
    }

    private Point calculateEndPoint(Point centerPointValue, Double radiusValue, Double startAngleValue, Point startPointValue, Double sweepAngleValue) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point endPointValue = (Point)this.values.get(this.endPoint);
        if (endPointValue != null) {
            return endPointValue;
        }
        if (startPointValue == null || centerPointValue == null || sweepAngleValue == null) {
            return null;
        }
        if (startAngleValue == null) {
            startAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue);
        }
        if (radiusValue == null) {
            radiusValue = centerPointValue.distance((Geometry)startPointValue);
        }
        double endAngle = startAngleValue + sweepAngleValue;
        endPointValue = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * Math.cos(endAngle)), (double)(centerPointValue.getY() + radiusValue * Math.sin(endAngle)));
        return endPointValue;
    }

    public Geometry finish() throws FinishServiceException {
        Point centerPointValue = (Point)this.values.get(this.centerPoint);
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        Double radiusValue = (Double)this.values.get(this.radius);
        Double startAngleValue = (Double)this.values.get(this.startAngle);
        Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
        String directionValue = (String)this.values.get(this.direction);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (radiusValue == null) {
                radiusValue = centerPointValue.distance((Geometry)startPointValue);
            }
            Arc arc = null;
            double coefDirection = GeometryUtils.getCoefDirection((Point)centerPointValue, (Point)startPointValue, (Point)endPointValue);
            if (sweepAngleValue != null) {
                if (directionValue != null) {
                    if (directionValue.equalsIgnoreCase(CCW)) {
                        if (!(sweepAngleValue >= 0.0)) {
                            sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                        }
                    } else if (!(sweepAngleValue <= 0.0)) {
                        sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                    }
                } else if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                    sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                }
                arc = GeometryUtils.createArc((Point)centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
            } else {
                double distance = centerPointValue.distance((Geometry)endPointValue);
                Point point = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * ((endPointValue.getX() - centerPointValue.getX()) / distance)), (double)(centerPointValue.getY() + radiusValue * ((endPointValue.getY() - centerPointValue.getY()) / distance)));
                sweepAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue, (Point)endPointValue);
                if (directionValue != null) {
                    if (directionValue.equalsIgnoreCase(CW)) {
                        sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                    }
                } else if (coefDirection < 0.0) {
                    sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                }
                if (Math.abs(sweepAngleValue) > 0.0) {
                    arc = GeometryUtils.createArc((Point)centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                }
            }
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)arc);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-arc-by-center";
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return !(parameter == this.radius ? this.values.get(this.startPoint) != null : (parameter == this.startAngle ? this.values.get(this.startPoint) != null : (parameter == this.sweepAngle ? this.values.get(this.endPoint) != null : parameter == this.direction && this.values.get(this.endPoint) != null)));
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

