/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.arc;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToDouble;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcThreePointsEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final String CCW = "CCW";
    private static final String CW = "CW";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcThreePointsEditingProvider.class);
    private final EditingServiceParameter radius;
    private final EditingServiceParameter startAngle;
    private final EditingServiceParameter sweepAngle;
    private final EditingServiceParameter direction;
    private final EditingServiceParameter startPoint;
    private final EditingServiceParameter middlePoint;
    private final EditingServiceParameter endPoint;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private Point centerPointValue;

    public ArcThreePointsEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.startPoint = new DefaultEditingServiceParameter("start_point", "start_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.middlePoint = new DefaultEditingServiceParameter("middle_point", "middle_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.endPoint = new DefaultEditingServiceParameter("end_point", "end_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.radius = new DefaultEditingServiceParameter("radius", "radius", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.startAngle = new DefaultEditingServiceParameter("start_angle", "start_angle", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.sweepAngle = new DefaultEditingServiceParameter("sweep_angle", "sweep_angle", true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions directionOptions = new DefaultEditingServiceParameterOptions().add(CCW, (Object)CCW, CCW).add(CW, (Object)CW, CW);
        String consoleMsg = editingProviderServices.makeConsoleMessage("_Direction", (EditingServiceParameterOptions)directionOptions);
        this.direction = new DefaultEditingServiceParameter(i18nManager.getTranslation("_Direction"), consoleMsg, (EditingServiceParameterOptions)directionOptions, null, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(8);
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.startPoint) == null) {
            return this.startPoint;
        }
        if (this.values.get(this.middlePoint) == null && this.centerPointValue == null && this.values.get(this.startAngle) == null && this.values.get(this.sweepAngle) == null) {
            return this.middlePoint;
        }
        if (this.values.get(this.endPoint) == null) {
            return this.endPoint;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point middlePointValue = (Point)this.values.get(this.middlePoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        Double radiusValue = (Double)this.values.get(this.radius);
        Double startAngleValue = (Double)this.values.get(this.startAngle);
        Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
        String directionValue = (String)this.values.get(this.direction);
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        geometries.setPreviewSymbol(previewSymbol);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            boolean isValidPoint;
            Point auxCenter;
            int subtype;
            block25: {
                block26: {
                    Line chord1;
                    Point auxPoint;
                    subtype = editingProviderServices.getSubType(this.featureStore);
                    if (this.values == null) return null;
                    if (startPointValue == null) {
                        if (radiusValue == null) return null;
                        if (startAngleValue == null) return null;
                        Point auxCenterPointValue = GeometryUtils.createPoint((double)(mousePosition.getX() - radiusValue * Math.cos(startAngleValue)), (double)(mousePosition.getY() - radiusValue * Math.sin(startAngleValue)));
                        geometries.addStatus((Geometry)auxCenterPointValue, auxiliaryPointSymbolEditing, "");
                        Line auxLine = GeometryUtils.createLine((Point)auxCenterPointValue, (Point)mousePosition, (int)subtype);
                        geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                        Line horizontal = GeometryUtils.createLine((double)auxCenterPointValue.getX(), (double)auxCenterPointValue.getY(), (double)mousePosition.getX(), (double)auxCenterPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)horizontal, auxiliaryLineSymbolEditing, "");
                        Line vertical = GeometryUtils.createLine((double)mousePosition.getX(), (double)mousePosition.getY(), (double)mousePosition.getX(), (double)auxCenterPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)vertical, auxiliaryLineSymbolEditing, "");
                        editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), auxCenterPointValue, GeometryUtils.createPoint((double)(auxCenterPointValue.getX() + radiusValue), (double)auxCenterPointValue.getY()), mousePosition, subtype);
                        if (sweepAngleValue == null) return geometries;
                        this.addArcAndEndPointToDrawingStatus(geometries, auxCenterPointValue, radiusValue, startAngleValue, mousePosition, sweepAngleValue, directionValue, subtype);
                        return geometries;
                    }
                    geometries.addStatus((Geometry)startPointValue, auxiliaryPointSymbolEditing, "");
                    if (this.centerPointValue != null) {
                        Line auxCenterLine = GeometryUtils.createLine((double)this.centerPointValue.getX(), (double)this.centerPointValue.getY(), (double)startPointValue.getX(), (double)startPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxCenterLine, auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)this.centerPointValue, auxiliaryPointSymbolEditing, "");
                        Double auxRadiusValue = radiusValue;
                        if (auxRadiusValue == null) {
                            auxRadiusValue = this.centerPointValue.distance((Geometry)startPointValue);
                        }
                        Line horizontal = GeometryUtils.createLine((double)this.centerPointValue.getX(), (double)this.centerPointValue.getY(), (double)(this.centerPointValue.getX() + auxRadiusValue), (double)this.centerPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)horizontal, auxiliaryLineSymbolEditing, "");
                        Line vertical = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)(this.centerPointValue.getX() + auxRadiusValue), (double)this.centerPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)vertical, auxiliaryLineSymbolEditing, "");
                        editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), this.centerPointValue, GeometryUtils.createPoint((double)(this.centerPointValue.getX() + auxRadiusValue), (double)this.centerPointValue.getY()), startPointValue, subtype);
                    }
                    if (startAngleValue != null && radiusValue == null) {
                        double m = Math.tan(startAngleValue);
                        double b = euclideanManager.getYIntercept(m, startPointValue.getX(), startPointValue.getY());
                        EuclideanLine2D startLine = euclideanManager.createLine2D(m, b);
                        if (sweepAngleValue != null) {
                            double endLineB;
                            double endAngle = startAngleValue + sweepAngleValue;
                            double endLineM = Math.tan(startAngleValue + sweepAngleValue);
                            EuclideanLine2D endLine = euclideanManager.createLine2D(endLineM, endLineB = euclideanManager.getYIntercept(endLineM, mousePosition.getX(), mousePosition.getY()));
                            Point2D auxCenter2D = startLine.getIntersection(endLine);
                            Point auxCenter2 = GeometryUtils.createPoint((double)auxCenter2D.getX(), (double)auxCenter2D.getY());
                            if (!(Math.abs(GeometryUtils.calculateAngle((Point)auxCenter2, (Point)startPointValue) - startAngleValue) <= 0.001)) return geometries;
                            Point horizontalPoint = GeometryUtils.createPoint((double)startPointValue.getX(), (double)auxCenter2.getY());
                            editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), auxCenter2, horizontalPoint, startPointValue, subtype);
                            Line horizontal = GeometryUtils.createLine((double)auxCenter2.getX(), (double)auxCenter2.getY(), (double)startPointValue.getX(), (double)auxCenter2.getY(), (int)subtype);
                            geometries.addStatus((Geometry)horizontal, auxiliaryLineSymbolEditing, "");
                            Line vertical = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)startPointValue.getX(), (double)auxCenter2.getY(), (int)subtype);
                            geometries.addStatus((Geometry)vertical, auxiliaryLineSymbolEditing, "");
                            Line auxStartLine = GeometryUtils.createLine((double)auxCenter2.getX(), (double)auxCenter2.getY(), (double)startPointValue.getX(), (double)startPointValue.getY(), (int)subtype);
                            geometries.addStatus((Geometry)auxStartLine, auxiliaryLineSymbolEditing, "");
                            double auxRadiusValue = startPointValue.distance((Geometry)auxCenter2);
                            Point auxEndPoint = GeometryUtils.createPoint((Point)auxCenter2, (double)auxRadiusValue, (double)endAngle);
                            Line auxEndLine = GeometryUtils.createLine((double)auxCenter2.getX(), (double)auxCenter2.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
                            geometries.addStatus((Geometry)auxEndLine, auxiliaryLineSymbolEditing, "");
                            Double auxSweepAngleValue = this.directedAngle(sweepAngleValue, directionValue);
                            geometries.addStatus((Geometry)auxCenter2, auxiliaryPointSymbolEditing, "");
                            this.addArcAndEndPointToDrawingStatus(geometries, auxCenter2, auxCenter2.distance((Geometry)startPointValue), startAngleValue, startPointValue, sweepAngleValue, directionValue, subtype);
                            return geometries;
                        }
                        Point auxEndPoint = mousePosition.cloneGeometry();
                        double endAngle = GeometryUtils.calculateAngle((Point)startPointValue, (Point)auxEndPoint);
                        double auxSweepAngle = editingProviderServices.angleDistance(startAngleValue.doubleValue(), endAngle);
                        if (!(auxSweepAngle > 1.5707963267948966)) return geometries;
                        if (!(auxSweepAngle < 4.71238898038469)) return geometries;
                        EuclideanLine2D startEndLine = euclideanManager.createLine2D(startPointValue.getX(), startPointValue.getY(), auxEndPoint.getX(), auxEndPoint.getY());
                        Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + auxEndPoint.getX()) / 2.0), (double)((startPointValue.getY() + auxEndPoint.getY()) / 2.0));
                        Point2D auxCenter2D = startLine.getIntersection(startEndLine.getPerpendicular(averagePoint.getX(), averagePoint.getY()));
                        Point auxCenter3 = GeometryUtils.createPoint((double)auxCenter2D.getX(), (double)auxCenter2D.getY());
                        editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), auxCenter3, GeometryUtils.createPoint((double)(auxCenter3.getX() + auxCenter3.distance((Geometry)startPointValue)), (double)auxCenter3.getY()), startPointValue, subtype);
                        Line horizontal = GeometryUtils.createLine((double)auxCenter3.getX(), (double)auxCenter3.getY(), (double)startPointValue.getX(), (double)auxCenter3.getY(), (int)subtype);
                        geometries.addStatus((Geometry)horizontal, auxiliaryLineSymbolEditing, "");
                        Line vertical = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)startPointValue.getX(), (double)auxCenter3.getY(), (int)subtype);
                        geometries.addStatus((Geometry)vertical, auxiliaryLineSymbolEditing, "");
                        Line auxStartLine = GeometryUtils.createLine((double)auxCenter3.getX(), (double)auxCenter3.getY(), (double)startPointValue.getX(), (double)startPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxStartLine, auxiliaryLineSymbolEditing, "");
                        Line auxStartEndLine = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxStartEndLine, auxiliaryLineSymbolEditing, "");
                        Line auxEndLine = GeometryUtils.createLine((double)auxCenter3.getX(), (double)auxCenter3.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxEndLine, auxiliaryLineSymbolEditing, "");
                        Point2D perp = startEndLine.getNearestPoint(auxCenter2D);
                        Line perpLine = GeometryUtils.createLine((double)perp.getX(), (double)perp.getY(), (double)auxCenter3.getX(), (double)auxCenter3.getY(), (int)subtype);
                        geometries.addStatus((Geometry)perpLine, auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxCenter3, auxiliaryPointSymbolEditing, "");
                        double auxSweepAngleValue = GeometryUtils.calculateAngle((Point)auxCenter3, (Point)startPointValue, (Point)auxEndPoint);
                        if (Math.abs(auxSweepAngleValue) > 0.0) {
                            this.addArcAndEndPointToDrawingStatus(geometries, auxCenter3, auxCenter3.distance((Geometry)startPointValue), startAngleValue, startPointValue, auxSweepAngleValue, directionValue, subtype);
                        }
                        geometries.addStatus((Geometry)auxCenter3, auxiliaryPointSymbolEditing, "");
                        return geometries;
                    }
                    if (radiusValue != null && startAngleValue == null && sweepAngleValue == null && middlePointValue == null) {
                        double distance = startPointValue.distance((Geometry)mousePosition);
                        if (startPointValue.distance((Geometry)mousePosition) >= 2.0 * radiusValue) {
                            auxPoint = GeometryUtils.createPoint((double)(startPointValue.getX() + 2.0 * radiusValue * (mousePosition.getX() - startPointValue.getX()) / distance), (double)(startPointValue.getY() + 2.0 * radiusValue * (mousePosition.getY() - startPointValue.getY()) / distance));
                            Line auxLine = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)auxPoint.getX(), (double)auxPoint.getY(), (int)subtype);
                            geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                            geometries.addStatus((Geometry)auxPoint, auxiliaryPointSymbolEditing, "");
                            return geometries;
                        }
                        Line auxLine = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxLine, auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                        return geometries;
                    }
                    if (radiusValue != null && startAngleValue != null && endPointValue == null) {
                        double coefDirection = this.getCoefDirection(this.centerPointValue, startPointValue, mousePosition);
                        if (sweepAngleValue == null) {
                            double auxSweepAngleValue = GeometryUtils.calculateAngle((Point)this.centerPointValue, (Point)startPointValue, (Point)mousePosition);
                            this.addArcAndEndPointToDrawingStatus(geometries, this.centerPointValue, radiusValue, startAngleValue, startPointValue, auxSweepAngleValue, directionValue, subtype);
                            return geometries;
                        }
                        if (directionValue != null) return null;
                        auxPoint = this.calculateEndPoint(this.centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                        geometries.addStatus((Geometry)auxPoint, auxiliaryPointSymbolEditing, "");
                        if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                            sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                        }
                        Arc auxArc = GeometryUtils.createArc((Point)this.centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                        geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                        return geometries;
                    }
                    if (radiusValue != null && startPointValue != null && sweepAngleValue != null && endPointValue == null) {
                        chord1 = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                        geometries.addStatus((Geometry)chord1, auxiliaryLineSymbolEditing, "");
                        auxCenter = null;
                        double auxSweepAngleValue = sweepAngleValue;
                        double lenChord1 = startPointValue.distance((Geometry)mousePosition);
                        if (lenChord1 >= 2.0 * radiusValue) {
                            auxCenter = GeometryUtils.createPoint((double)(startPointValue.getX() + radiusValue * (mousePosition.getX() - startPointValue.getX()) / lenChord1), (double)(startPointValue.getY() + radiusValue * (mousePosition.getY() - startPointValue.getY()) / lenChord1));
                        } else {
                            Point medium = GeometryUtils.createPoint((double)((startPointValue.getX() + mousePosition.getX()) / 2.0), (double)((startPointValue.getY() + mousePosition.getY()) / 2.0));
                            Point dir = GeometryUtils.createPoint((double)((mousePosition.getX() - startPointValue.getX()) / lenChord1), (double)((mousePosition.getY() - startPointValue.getY()) / lenChord1));
                            Point perpDir = GeometryUtils.createPoint((double)(-dir.getY()), (double)dir.getX());
                            double sagitta = Math.sqrt(Math.pow(radiusValue, 2.0) - Math.pow(lenChord1 / 2.0, 2.0));
                            Point auxCenter1 = GeometryUtils.createPoint((double)(medium.getX() + sagitta * perpDir.getX()), (double)(medium.getY() + sagitta * perpDir.getY()));
                            Point auxCenter2 = GeometryUtils.createPoint((double)(medium.getX() - sagitta * perpDir.getX()), (double)(medium.getY() - sagitta * perpDir.getY()));
                            auxCenter = sweepAngleValue >= 0.0 ? auxCenter1 : auxCenter2;
                            Line perpChord1 = GeometryUtils.createLine((double)medium.getX(), (double)medium.getY(), (double)auxCenter.getX(), (double)auxCenter.getY(), (int)subtype);
                            geometries.addStatus((Geometry)perpChord1, auxiliaryLineSymbolEditing, "");
                        }
                        Line startLine = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)auxCenter.getX(), (double)auxCenter.getY(), (int)subtype);
                        geometries.addStatus((Geometry)startLine, auxiliaryLineSymbolEditing, "");
                        auxSweepAngleValue = this.directedAngle(sweepAngleValue, directionValue);
                        geometries.addStatus((Geometry)auxCenter, auxiliaryPointSymbolEditing, "");
                        Point auxEndPoint = this.calculateEndPoint(auxCenter, radiusValue, null, startPointValue, sweepAngleValue);
                        geometries.addStatus((Geometry)auxEndPoint, auxiliaryPointSymbolEditing, "");
                        Line chord2 = GeometryUtils.createLine((double)auxCenter.getX(), (double)auxCenter.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
                        geometries.addStatus((Geometry)chord2, auxiliaryLineSymbolEditing, "");
                        Arc auxArc = GeometryUtils.createArc((Point)auxCenter, (double)radiusValue, (double)GeometryUtils.calculateAngle((Point)auxCenter, (Point)startPointValue), (double)auxSweepAngleValue, (int)subtype);
                        geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                        return geometries;
                    }
                    if (middlePointValue == null) {
                        if (sweepAngleValue == null) {
                            Line middleLine = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                            geometries.addStatus((Geometry)middleLine, auxiliaryLineSymbolEditing, "");
                            return geometries;
                        }
                        Line endLine2D = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                        geometries.addStatus((Geometry)endLine2D, auxiliaryLineSymbolEditing, "");
                        EuclideanLine2D endLine = euclideanManager.createLine2D(startPointValue.getX(), startPointValue.getY(), mousePosition.getX(), mousePosition.getY());
                        Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + mousePosition.getX()) / 2.0), (double)((startPointValue.getY() + mousePosition.getY()) / 2.0));
                        geometries.addStatus((Geometry)averagePoint, auxiliaryPointSymbolEditing, "");
                        EuclideanLine2D perp = endLine.getPerpendicular(averagePoint.getX(), averagePoint.getY());
                        double lenEndLine = startPointValue.distance((Geometry)mousePosition);
                        double auxRadiusValue = Math.abs(lenEndLine / (2.0 * Math.sin(sweepAngleValue / 2.0)));
                        double sagitta = auxRadiusValue * Math.cos(sweepAngleValue / 2.0);
                        Point dir = GeometryUtils.createPoint((double)((mousePosition.getX() - startPointValue.getX()) / lenEndLine), (double)((mousePosition.getY() - startPointValue.getY()) / lenEndLine));
                        Point perpDir = GeometryUtils.createPoint((double)(-dir.getY()), (double)dir.getX());
                        Point auxCenter1 = GeometryUtils.createPoint((double)(averagePoint.getX() + sagitta * perpDir.getX()), (double)(averagePoint.getY() + sagitta * perpDir.getY()));
                        Point auxCenter2 = GeometryUtils.createPoint((double)(averagePoint.getX() - sagitta * perpDir.getX()), (double)(averagePoint.getY() - sagitta * perpDir.getY()));
                        Point auxCenter4 = auxCenter1;
                        auxCenter4 = sweepAngleValue >= 0.0 ? auxCenter1 : auxCenter2;
                        Point horizontalPoint = GeometryUtils.createPoint((double)startPointValue.getX(), (double)auxCenter4.getY());
                        editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), auxCenter4, horizontalPoint, startPointValue, subtype);
                        Line horizontal = GeometryUtils.createLine((double)auxCenter4.getX(), (double)auxCenter4.getY(), (double)startPointValue.getX(), (double)auxCenter4.getY(), (int)subtype);
                        geometries.addStatus((Geometry)horizontal, auxiliaryLineSymbolEditing, "");
                        Line vertical = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)startPointValue.getX(), (double)auxCenter4.getY(), (int)subtype);
                        geometries.addStatus((Geometry)vertical, auxiliaryLineSymbolEditing, "");
                        Line auxStartLine = GeometryUtils.createLine((double)auxCenter4.getX(), (double)auxCenter4.getY(), (double)startPointValue.getX(), (double)startPointValue.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxStartLine, auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxCenter4, auxiliaryPointSymbolEditing, "");
                        Arc auxArc = GeometryUtils.createArc((Point)auxCenter4, (double)auxRadiusValue, (double)GeometryUtils.calculateAngle((Point)auxCenter4, (Point)startPointValue), (double)this.directedAngle(sweepAngleValue, directionValue), (int)subtype);
                        geometries.addStatus((Geometry)auxArc, auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                        editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), auxCenter4, startPointValue, mousePosition, subtype);
                        Line auxEndLine = GeometryUtils.createLine((double)auxCenter4.getX(), (double)auxCenter4.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                        geometries.addStatus((Geometry)auxEndLine, auxiliaryLineSymbolEditing, "");
                        return geometries;
                    }
                    if (endPointValue != null) return null;
                    chord1 = GeometryUtils.createLine((double)startPointValue.getX(), (double)startPointValue.getY(), (double)middlePointValue.getX(), (double)middlePointValue.getY(), (int)subtype);
                    geometries.addStatus((Geometry)chord1, auxiliaryLineSymbolEditing, "");
                    auxCenter = null;
                    if (radiusValue != null) {
                        double lenChord1 = startPointValue.distance((Geometry)middlePointValue);
                        if (lenChord1 >= 2.0 * radiusValue) {
                            auxCenter = GeometryUtils.createPoint((double)((startPointValue.getX() + middlePointValue.getX()) / 2.0), (double)((startPointValue.getY() + middlePointValue.getY()) / 2.0));
                        } else {
                            Point medium = GeometryUtils.createPoint((double)((startPointValue.getX() + middlePointValue.getX()) / 2.0), (double)((startPointValue.getY() + middlePointValue.getY()) / 2.0));
                            Point dir = GeometryUtils.createPoint((double)((middlePointValue.getX() - startPointValue.getX()) / lenChord1), (double)((middlePointValue.getY() - startPointValue.getY()) / lenChord1));
                            Point perpDir = GeometryUtils.createPoint((double)dir.getY(), (double)(-dir.getX()));
                            double sagitta = Math.sqrt(Math.pow(radiusValue, 2.0) - Math.pow(lenChord1 / 2.0, 2.0));
                            Point auxCenter1 = GeometryUtils.createPoint((double)(medium.getX() + sagitta * perpDir.getX()), (double)(medium.getY() + sagitta * perpDir.getY()));
                            Point auxCenter2 = GeometryUtils.createPoint((double)(medium.getX() - sagitta * perpDir.getX()), (double)(medium.getY() - sagitta * perpDir.getY()));
                            auxCenter = directionValue != null ? (StringUtils.equals((String)directionValue, (String)CCW) ? auxCenter2 : auxCenter1) : (mousePosition.distance((Geometry)auxCenter1) <= mousePosition.distance((Geometry)auxCenter2) ? auxCenter1 : auxCenter2);
                            Line perpChord1 = GeometryUtils.createLine((double)medium.getX(), (double)medium.getY(), (double)auxCenter.getX(), (double)auxCenter.getY(), (int)subtype);
                            geometries.addStatus((Geometry)perpChord1, auxiliaryLineSymbolEditing, "");
                        }
                        geometries.addStatus((Geometry)auxCenter, auxiliaryPointSymbolEditing, "");
                        double distance = auxCenter.distance((Geometry)mousePosition);
                        Point auxEndPoint = GeometryUtils.createPoint((double)(auxCenter.getX() + radiusValue * (mousePosition.getX() - auxCenter.getX()) / distance), (double)(auxCenter.getY() + radiusValue * (mousePosition.getY() - auxCenter.getY()) / distance));
                        Line chord2 = GeometryUtils.createLine((double)middlePointValue.getX(), (double)middlePointValue.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
                        geometries.addStatus((Geometry)chord2, auxiliaryLineSymbolEditing, "");
                        Arc auxArc = GeometryUtils.createArc((Point)startPointValue, (Point)middlePointValue, (Point)auxEndPoint, (int)subtype);
                        geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
                        geometries.addStatus((Geometry)auxArc, previewSymbol, "");
                        return geometries;
                    }
                    auxCenter = GeometryUtils.getCenter((Point)startPointValue, (Point)middlePointValue, (Point)mousePosition, (int)1);
                    geometries.addStatus((Geometry)middlePointValue, auxiliaryPointSymbolEditing, "");
                    Line endLine = GeometryUtils.createLine((double)middlePointValue.getX(), (double)middlePointValue.getY(), (double)mousePosition.getX(), (double)mousePosition.getY(), (int)subtype);
                    geometries.addStatus((Geometry)endLine, auxiliaryLineSymbolEditing, "");
                    isValidPoint = false;
                    if (GeometryUtils.areThreePointsInLine((Point)startPointValue, (Point)middlePointValue, (Point)mousePosition)) break block25;
                    if (directionValue == null) break block26;
                    double coefDirection = this.getCoefDirection(startPointValue, middlePointValue, mousePosition);
                    if (StringUtils.equalsIgnoreCase((String)directionValue, (String)CCW)) {
                        if (coefDirection >= 0.0) {
                            isValidPoint = true;
                        }
                        break block25;
                    } else if (coefDirection < 0.0) {
                        isValidPoint = true;
                    }
                    break block25;
                }
                isValidPoint = true;
            }
            if (!isValidPoint) return geometries;
            Line middle2CenterLine = GeometryUtils.createLine((double)((startPointValue.getX() + middlePointValue.getX()) / 2.0), (double)((startPointValue.getY() + middlePointValue.getY()) / 2.0), (double)auxCenter.getX(), (double)auxCenter.getY(), (int)subtype);
            geometries.addStatus((Geometry)middle2CenterLine, auxiliaryLineSymbolEditing, "");
            Line end2CenterLine = GeometryUtils.createLine((double)((middlePointValue.getX() + mousePosition.getX()) / 2.0), (double)((middlePointValue.getY() + mousePosition.getY()) / 2.0), (double)auxCenter.getX(), (double)auxCenter.getY(), (int)subtype);
            geometries.addStatus((Geometry)end2CenterLine, auxiliaryLineSymbolEditing, "");
            geometries.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
            Arc auxArc = GeometryUtils.createArc((Point)startPointValue, (Point)middlePointValue, (Point)mousePosition, (int)subtype);
            geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
            geometries.addStatus((Geometry)auxArc, previewSymbol, "");
            return geometries;
        }
        catch (BaseException ex) {
            throw new DrawServiceException((Throwable)ex);
        }
    }

    private Double directedAngle(Double sweepAngleValue, String directionValue) {
        Double auxSweepAngleValue = sweepAngleValue;
        if (directionValue != null) {
            if (StringUtils.equalsIgnoreCase((String)directionValue, (String)CCW)) {
                if (sweepAngleValue < 0.0) {
                    auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                }
            } else if (sweepAngleValue > 0.0) {
                auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
            }
        }
        return auxSweepAngleValue;
    }

    private void addArcAndEndPointToDrawingStatus(DefaultDrawingStatus geometries, Point centerValue, Double radiusValue, Double startAngleValue, Point startPointValue, Double sweepAngleValue, String directionValue, int subtype) throws GeometryOperationException, GeometryOperationNotSupportedException, CreateGeometryException {
        if (sweepAngleValue != null) {
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            Point auxEndPoint = this.calculateEndPoint(centerValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
            geometries.addStatus((Geometry)auxEndPoint, auxiliaryPointSymbolEditing, "");
            double auxSweepAngleValue = sweepAngleValue;
            if (directionValue != null) {
                if (StringUtils.equalsIgnoreCase((String)directionValue, (String)CCW)) {
                    if (sweepAngleValue < 0.0) {
                        auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                    }
                } else if (sweepAngleValue > 0.0) {
                    auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                }
            }
            Arc auxArc = GeometryUtils.createArc((Point)centerValue, (double)radiusValue, (double)startAngleValue, (double)auxSweepAngleValue, (int)subtype);
            geometries.addStatus((Geometry)auxArc, lineSymbolEditing, "");
            geometries.addStatus((Geometry)auxArc, geometries.getPreviewSymbol(), "");
            EditingProviderServices editingProviderServices = this.getProviderServices();
            editingProviderServices.addAngleToDrawingStatus(geometries, (ISymbol)this.getTextSymbol(), centerValue, startPointValue, auxEndPoint, subtype);
            Line auxEndLine = GeometryUtils.createLine((double)centerValue.getX(), (double)centerValue.getY(), (double)auxEndPoint.getX(), (double)auxEndPoint.getY(), (int)subtype);
            geometries.addStatus((Geometry)auxEndLine, auxiliaryLineSymbolEditing, "");
        }
    }

    private double getCoefDirection(Point a, Point b, Point c) {
        return Math.signum((b.getX() - a.getX()) * (c.getY() - a.getY()) - (b.getY() - a.getY()) * (c.getX() - a.getX()));
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.radius);
        parameters.add(this.startAngle);
        parameters.add(this.sweepAngle);
        parameters.add(this.direction);
        parameters.add(this.startPoint);
        parameters.add(this.middlePoint);
        parameters.add(this.endPoint);
        return parameters;
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.setValue(param, value);
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
        this.removeRelatedParams(parameter);
        this.fillEmptyParams();
    }

    private void removeRelatedParams(EditingServiceParameter parameter) {
        if (parameter == this.startAngle) {
            this.centerPointValue = null;
        }
        if (parameter == this.radius) {
            this.centerPointValue = null;
        }
        if (parameter == this.sweepAngle) {
            this.values.remove(this.endPoint);
        }
        if (parameter == this.direction) {
            this.values.remove(this.endPoint);
        }
    }

    private void fillEmptyParams() throws InvalidEntryException {
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point middlePointValue = (Point)this.values.get(this.middlePoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        Double radiusValue = (Double)this.values.get(this.radius);
        Double startAngleValue = (Double)this.values.get(this.startAngle);
        Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
        String directionValue = (String)this.values.get(this.direction);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        if (this.centerPointValue == null && startPointValue != null && radiusValue != null && startAngleValue != null) {
            this.centerPointValue = GeometryUtils.createPoint((double)(startPointValue.getX() - radiusValue * Math.cos(startAngleValue)), (double)(startPointValue.getY() - radiusValue * Math.sin(startAngleValue)));
        }
        if (this.centerPointValue == null && startPointValue != null && startAngleValue != null && endPointValue != null) {
            double m = Math.tan(startAngleValue);
            double b = euclideanManager.getYIntercept(m, startPointValue.getX(), startPointValue.getY());
            EuclideanLine2D startLine = euclideanManager.createLine2D(m, b);
            EuclideanLine2D midLine = euclideanManager.createLine2D(startPointValue.getX(), startPointValue.getY(), endPointValue.getX(), endPointValue.getY());
            Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + endPointValue.getX()) / 2.0), (double)((startPointValue.getY() + endPointValue.getY()) / 2.0));
            Point2D center2D = startLine.getIntersection(midLine.getPerpendicular(averagePoint.getX(), averagePoint.getY()));
            this.centerPointValue = GeometryUtils.createPoint((double)center2D.getX(), (double)center2D.getY());
        }
        if (this.centerPointValue == null && startPointValue != null && middlePointValue != null && endPointValue != null) {
            try {
                this.centerPointValue = GeometryUtils.getCenter((Point)startPointValue, (Point)middlePointValue, (Point)endPointValue, (int)0);
            }
            catch (CreateGeometryException ex) {
                throw new InvalidEntryException((Throwable)ex);
            }
        }
        if (radiusValue == null && this.centerPointValue != null && startPointValue != null) {
            try {
                radiusValue = this.centerPointValue.distance((Geometry)startPointValue);
                this.values.put(this.radius, radiusValue);
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                throw new InvalidEntryException(ex);
            }
        }
        if (endPointValue == null && this.centerPointValue != null && radiusValue != null && startAngleValue != null && sweepAngleValue != null) {
            endPointValue = GeometryUtils.createPoint((Point)this.centerPointValue, (double)radiusValue, (double)(startAngleValue + sweepAngleValue));
            this.values.put(this.endPoint, endPointValue);
        }
        if (endPointValue == null && this.centerPointValue != null && startPointValue != null && sweepAngleValue != null) {
            try {
                endPointValue = this.calculateEndPoint(this.centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                this.values.put(this.endPoint, endPointValue);
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                throw new InvalidEntryException(ex);
            }
        }
        if (sweepAngleValue == null && this.centerPointValue != null && startPointValue != null && endPointValue != null) {
            sweepAngleValue = GeometryUtils.calculateAngle((Point)this.centerPointValue, (Point)startPointValue, (Point)endPointValue);
            this.values.put(this.sweepAngle, sweepAngleValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        try {
            EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subtype = editingProviderServices.getSubType(this.featureStore);
            Double radiusValue = (Double)this.values.get(this.radius);
            Double startAngleValue = (Double)this.values.get(this.startAngle);
            Point startPointValue = (Point)this.values.get(this.startPoint);
            Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
            String directionValue = (String)this.values.get(this.direction);
            Point middlePointValue = (Point)this.values.get(this.middlePoint);
            CoerceToDouble coerceToDouble = new CoerceToDouble();
            if (param == this.startPoint) {
                if (!(value instanceof Point)) throw new InvalidEntryException(null);
                this.values.put(param, value);
                return;
            }
            if (param == this.middlePoint) {
                if (!(value instanceof Point)) throw new InvalidEntryException(null);
                Point pointValue = (Point)value;
                if (this.centerPointValue != null) {
                    if (startPointValue != null) {
                        if (radiusValue != null) {
                            double midAngle = GeometryUtils.calculateAngle((Point)this.centerPointValue, (Point)pointValue);
                            Point auxMiddlePointValue = GeometryUtils.createPoint((double)(this.centerPointValue.getX() + radiusValue * Math.cos(midAngle)), (double)(this.centerPointValue.getY() + radiusValue * Math.sin(midAngle)));
                            this.values.put(param, auxMiddlePointValue);
                        } else if (startAngleValue != null) {
                            throw new InvalidEntryException(null);
                        }
                    }
                } else if (startPointValue != null && radiusValue != null) {
                    double distance = startPointValue.distance((Geometry)pointValue);
                    if (distance >= 2.0 * radiusValue) {
                        Point auxPoint = GeometryUtils.createPoint((double)(startPointValue.getX() + 2.0 * radiusValue * (pointValue.getX() - startPointValue.getX()) / distance), (double)(startPointValue.getY() + 2.0 * radiusValue * (pointValue.getY() - startPointValue.getY()) / distance));
                        this.values.put(this.middlePoint, auxPoint);
                    } else {
                        this.values.put(this.middlePoint, pointValue);
                    }
                }
                this.values.put(param, value);
                return;
            }
            if (param == this.endPoint) {
                if (!(value instanceof Point)) throw new InvalidEntryException(null);
                Point pointValue = (Point)value;
                Point auxCenter = null;
                if (radiusValue != null && startPointValue != null && sweepAngleValue != null) {
                    double auxSweepAngleValue = sweepAngleValue;
                    double lenChord = startPointValue.distance((Geometry)pointValue);
                    if (lenChord >= 2.0 * radiusValue) {
                        auxCenter = GeometryUtils.createPoint((double)(startPointValue.getX() + radiusValue * (pointValue.getX() - startPointValue.getX()) / lenChord), (double)(startPointValue.getY() + radiusValue * (pointValue.getY() - startPointValue.getY()) / lenChord));
                    } else {
                        Point medium = GeometryUtils.createPoint((double)((startPointValue.getX() + pointValue.getX()) / 2.0), (double)((startPointValue.getY() + pointValue.getY()) / 2.0));
                        Point dir = GeometryUtils.createPoint((double)((pointValue.getX() - startPointValue.getX()) / lenChord), (double)((pointValue.getY() - startPointValue.getY()) / lenChord));
                        Point perpDir = GeometryUtils.createPoint((double)(-dir.getY()), (double)dir.getX());
                        double sagitta = Math.sqrt(Math.pow(radiusValue, 2.0) - Math.pow(lenChord / 2.0, 2.0));
                        Point auxCenter1 = GeometryUtils.createPoint((double)(medium.getX() + sagitta * perpDir.getX()), (double)(medium.getY() + sagitta * perpDir.getY()));
                        Point auxCenter2 = GeometryUtils.createPoint((double)(medium.getX() - sagitta * perpDir.getX()), (double)(medium.getY() - sagitta * perpDir.getY()));
                        auxCenter = sweepAngleValue >= 0.0 ? auxCenter1 : auxCenter2;
                    }
                    this.centerPointValue = auxCenter;
                    auxSweepAngleValue = this.directedAngle(sweepAngleValue, directionValue);
                    Point auxEndPoint = this.calculateEndPoint(auxCenter, radiusValue, null, startPointValue, sweepAngleValue);
                    this.values.put(param, auxEndPoint);
                    return;
                }
                if (middlePointValue == null) {
                    double module;
                    Point endPointValue;
                    if (startAngleValue != null) {
                        double m = Math.tan(startAngleValue);
                        double b = euclideanManager.getYIntercept(m, startPointValue.getX(), startPointValue.getY());
                        EuclideanLine2D startLine = euclideanManager.createLine2D(m, b);
                        if (sweepAngleValue != null) {
                            double endLineB;
                            double endAngle = startAngleValue + sweepAngleValue;
                            double endLineM = Math.tan(startAngleValue + sweepAngleValue);
                            EuclideanLine2D endLine = euclideanManager.createLine2D(endLineM, endLineB = euclideanManager.getYIntercept(endLineM, pointValue.getX(), pointValue.getY()));
                            Point2D auxCenter2D = startLine.getIntersection(endLine);
                            auxCenter = GeometryUtils.createPoint((double)auxCenter2D.getX(), (double)auxCenter2D.getY());
                            if (!(Math.abs(GeometryUtils.calculateAngle((Point)auxCenter, (Point)startPointValue) - startAngleValue) <= 0.001)) throw new InvalidEntryException(null);
                            double auxRadiusValue = startPointValue.distance((Geometry)auxCenter);
                            Point auxEndPoint = GeometryUtils.createPoint((Point)auxCenter, (double)auxRadiusValue, (double)endAngle);
                            this.centerPointValue = auxCenter;
                            this.values.put(this.endPoint, auxEndPoint);
                            return;
                        }
                        endPointValue = pointValue.cloneGeometry();
                        double endAngle = GeometryUtils.calculateAngle((Point)startPointValue, (Point)endPointValue);
                        double angleDistance = editingProviderServices.angleDistance(startAngleValue.doubleValue(), endAngle);
                        if (angleDistance > 1.5707963267948966 && angleDistance < 4.71238898038469) {
                            EuclideanLine2D endLine = euclideanManager.createLine2D(startPointValue.getX(), startPointValue.getY(), endPointValue.getX(), endPointValue.getY());
                            Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + endPointValue.getX()) / 2.0), (double)((startPointValue.getY() + endPointValue.getY()) / 2.0));
                            Point2D auxCenter2D = startLine.getIntersection(endLine.getPerpendicular(averagePoint.getX(), averagePoint.getY()));
                            auxCenter = GeometryUtils.createPoint((double)auxCenter2D.getX(), (double)auxCenter2D.getY());
                            Point2D perp = endLine.getNearestPoint(auxCenter2D);
                            double auxSweepAngleValue = GeometryUtils.calculateAngle((Point)auxCenter, (Point)startPointValue, (Point)endPointValue);
                            endPointValue = this.calculateEndPoint(auxCenter, radiusValue, startAngleValue, startPointValue, auxSweepAngleValue);
                            this.values.put(param, endPointValue);
                            return;
                        }
                    } else if (sweepAngleValue != null) {
                        EuclideanLine2D endLine = euclideanManager.createLine2D(startPointValue.getX(), startPointValue.getY(), pointValue.getX(), pointValue.getY());
                        Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + pointValue.getX()) / 2.0), (double)((startPointValue.getY() + pointValue.getY()) / 2.0));
                        EuclideanLine2D perp = endLine.getPerpendicular(averagePoint.getX(), averagePoint.getY());
                        double lenEndLine = startPointValue.distance((Geometry)pointValue);
                        double auxRadiusValue = Math.abs(lenEndLine / (2.0 * Math.sin(sweepAngleValue / 2.0)));
                        double sagitta = auxRadiusValue * Math.cos(sweepAngleValue / 2.0);
                        Point dir = GeometryUtils.createPoint((double)((pointValue.getX() - startPointValue.getX()) / lenEndLine), (double)((pointValue.getY() - startPointValue.getY()) / lenEndLine));
                        Point perpDir = GeometryUtils.createPoint((double)(-dir.getY()), (double)dir.getX());
                        Point auxCenter1 = GeometryUtils.createPoint((double)(averagePoint.getX() + sagitta * perpDir.getX()), (double)(averagePoint.getY() + sagitta * perpDir.getY()));
                        Point auxCenter2 = GeometryUtils.createPoint((double)(averagePoint.getX() - sagitta * perpDir.getX()), (double)(averagePoint.getY() - sagitta * perpDir.getY()));
                        auxCenter = sweepAngleValue >= 0.0 ? auxCenter1 : auxCenter2;
                        this.values.put(this.radius, auxRadiusValue);
                        this.centerPointValue = auxCenter;
                        this.values.put(param, pointValue);
                        return;
                    }
                    if (sweepAngleValue != null) {
                        if (directionValue == null) {
                            double coefDirection = this.getCoefDirection(this.centerPointValue, startPointValue, pointValue);
                            if (coefDirection >= 0.0) {
                                this.values.put(this.direction, CCW);
                            } else {
                                this.values.put(this.direction, CW);
                            }
                        }
                        try {
                            endPointValue = this.calculateEndPoint(this.centerPointValue, radiusValue, startAngleValue, startPointValue, sweepAngleValue);
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new InvalidEntryException(ex);
                        }
                    }
                    if (radiusValue == null) {
                        try {
                            radiusValue = this.centerPointValue.distance((Geometry)startPointValue);
                        }
                        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                            throw new InvalidEntryException(ex);
                        }
                    }
                    try {
                        module = this.centerPointValue.distance((Geometry)pointValue);
                    }
                    catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                        throw new InvalidEntryException(ex);
                    }
                    endPointValue = GeometryUtils.createPoint((double)(this.centerPointValue.getX() + radiusValue * (pointValue.getX() - this.centerPointValue.getX()) / module), (double)(this.centerPointValue.getY() + radiusValue * (pointValue.getY() - this.centerPointValue.getY()) / module));
                    this.values.put(this.endPoint, endPointValue);
                    return;
                }
                if (radiusValue != null) {
                    double lenChord1 = startPointValue.distance((Geometry)middlePointValue);
                    if (lenChord1 >= 2.0 * radiusValue) {
                        auxCenter = GeometryUtils.createPoint((double)(startPointValue.getX() + radiusValue * (middlePointValue.getX() - startPointValue.getX()) / lenChord1), (double)(startPointValue.getY() + radiusValue * (middlePointValue.getY() - startPointValue.getY()) / lenChord1));
                    } else {
                        Point averagePoint = GeometryUtils.createPoint((double)((startPointValue.getX() + middlePointValue.getX()) / 2.0), (double)((startPointValue.getY() + middlePointValue.getY()) / 2.0));
                        Point dir = GeometryUtils.createPoint((double)((middlePointValue.getX() - startPointValue.getX()) / lenChord1), (double)((middlePointValue.getY() - startPointValue.getY()) / lenChord1));
                        Point perpDir = GeometryUtils.createPoint((double)dir.getY(), (double)(-dir.getX()));
                        double sagitta = Math.sqrt(Math.pow(radiusValue, 2.0) - Math.pow(lenChord1 / 2.0, 2.0));
                        Point auxCenter1 = GeometryUtils.createPoint((double)(averagePoint.getX() + sagitta * perpDir.getX()), (double)(averagePoint.getY() + sagitta * perpDir.getY()));
                        Point auxCenter2 = GeometryUtils.createPoint((double)(averagePoint.getX() - sagitta * perpDir.getX()), (double)(averagePoint.getY() - sagitta * perpDir.getY()));
                        auxCenter = directionValue != null ? (StringUtils.equals((String)directionValue, (String)CCW) ? auxCenter2 : auxCenter1) : (pointValue.distance((Geometry)auxCenter1) <= pointValue.distance((Geometry)auxCenter2) ? auxCenter1 : auxCenter2);
                    }
                    double distance = auxCenter.distance((Geometry)pointValue);
                    Point auxEndPoint = GeometryUtils.createPoint((double)(auxCenter.getX() + radiusValue * (pointValue.getX() - auxCenter.getX()) / distance), (double)(auxCenter.getY() + radiusValue * (pointValue.getY() - auxCenter.getY()) / distance));
                    this.centerPointValue = auxCenter;
                    this.values.put(param, auxEndPoint);
                    return;
                }
                if (GeometryUtils.areThreePointsInLine((Point)startPointValue, (Point)middlePointValue, (Point)pointValue)) return;
                if (directionValue == null) {
                    this.values.put(param, pointValue);
                    return;
                }
                double coefDirection = this.getCoefDirection(startPointValue, middlePointValue, pointValue);
                if (StringUtils.equalsIgnoreCase((String)directionValue, (String)CCW)) {
                    if (!(coefDirection >= 0.0)) throw new InvalidEntryException(null);
                    this.values.put(param, pointValue);
                    return;
                }
                if (!(coefDirection < 0.0)) throw new InvalidEntryException(null);
                this.values.put(param, pointValue);
                return;
            }
            if (param == this.radius) {
                Double doubleValue = (Double)coerceToDouble.coerce(value);
                if (!Double.isFinite(doubleValue)) throw new InvalidEntryException(null);
                this.values.put(param, Math.abs(doubleValue));
                return;
            }
            if (param == this.startAngle) {
                Double doubleValue = (Double)coerceToDouble.coerce(value);
                this.values.put(param, this.reduceAngle(Math.toRadians(doubleValue)));
                return;
            }
            if (param == this.sweepAngle) {
                Double doubleValue = (Double)coerceToDouble.coerce(value);
                this.values.put(param, this.reduceAngle(Math.toRadians(doubleValue)));
                return;
            }
            if (param != this.direction) throw new InvalidEntryException(null);
            if (!(value instanceof String)) throw new InvalidEntryException(null);
            if (((String)value).trim().equalsIgnoreCase(CCW)) {
                this.values.put(param, CCW);
                return;
            }
            if (!((String)value).trim().equalsIgnoreCase(CW)) throw new InvalidEntryException(null);
            this.values.put(param, CW);
            return;
        }
        catch (Exception ex) {
            throw new InvalidEntryException((Throwable)ex);
        }
    }

    private double reduceAngle(double angle) {
        return Math.IEEEremainder(angle, Math.PI * 2);
    }

    private Point calculateEndPoint(Point centerPointValue, Double radiusValue, Double startAngleValue, Point startPointValue, Double sweepAngleValue) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point auxEndPointValue = (Point)this.values.get(this.endPoint);
        if (auxEndPointValue != null) {
            return auxEndPointValue;
        }
        if (startPointValue == null || centerPointValue == null || sweepAngleValue == null) {
            return null;
        }
        if (startAngleValue == null) {
            startAngleValue = GeometryUtils.calculateAngle((Point)centerPointValue, (Point)startPointValue);
        }
        if (radiusValue == null) {
            radiusValue = centerPointValue.distance((Geometry)startPointValue);
        }
        double endAngle = startAngleValue + sweepAngleValue;
        auxEndPointValue = GeometryUtils.createPoint((double)(centerPointValue.getX() + radiusValue * Math.cos(endAngle)), (double)(centerPointValue.getY() + radiusValue * Math.sin(endAngle)));
        return auxEndPointValue;
    }

    public Geometry finish() throws FinishServiceException {
        Point startPointValue = (Point)this.values.get(this.startPoint);
        Point middlePointValue = (Point)this.values.get(this.middlePoint);
        Point endPointValue = (Point)this.values.get(this.endPoint);
        Double radiusValue = (Double)this.values.get(this.radius);
        Double startAngleValue = (Double)this.values.get(this.startAngle);
        Double sweepAngleValue = (Double)this.values.get(this.sweepAngle);
        String directionValue = (String)this.values.get(this.direction);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (radiusValue == null) {
                radiusValue = this.centerPointValue.distance((Geometry)startPointValue);
            }
            Arc arc = null;
            if (startPointValue != null && middlePointValue != null && endPointValue != null) {
                arc = GeometryUtils.createArc((Point)startPointValue, (Point)middlePointValue, (Point)endPointValue, (int)subtype);
            } else if (radiusValue != null && startPointValue != null && sweepAngleValue != null && this.centerPointValue != null && endPointValue != null) {
                double auxSweepAngleValue = sweepAngleValue;
                if (directionValue != null) {
                    if (StringUtils.equalsIgnoreCase((String)directionValue, (String)CCW)) {
                        if (sweepAngleValue < 0.0) {
                            auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                        }
                    } else if (sweepAngleValue > 0.0) {
                        auxSweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                    }
                }
                arc = GeometryUtils.createArc((Point)this.centerPointValue, (double)radiusValue, (double)GeometryUtils.calculateAngle((Point)this.centerPointValue, (Point)startPointValue), (double)auxSweepAngleValue, (int)subtype);
            } else if (middlePointValue == null) {
                double coefDirection = this.getCoefDirection(this.centerPointValue, startPointValue, endPointValue);
                if (sweepAngleValue != null) {
                    if (directionValue != null) {
                        if (directionValue.equalsIgnoreCase(CCW)) {
                            if (!(sweepAngleValue >= 0.0)) {
                                sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                            }
                        } else if (!(sweepAngleValue <= 0.0)) {
                            sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                        }
                    } else if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                        sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                    }
                    arc = GeometryUtils.createArc((Point)this.centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                } else {
                    double distance = this.centerPointValue.distance((Geometry)endPointValue);
                    Point point = GeometryUtils.createPoint((double)(this.centerPointValue.getX() + radiusValue * ((endPointValue.getX() - this.centerPointValue.getX()) / distance)), (double)(this.centerPointValue.getY() + radiusValue * ((endPointValue.getY() - this.centerPointValue.getY()) / distance)));
                    sweepAngleValue = GeometryUtils.calculateAngle((Point)this.centerPointValue, (Point)startPointValue, (Point)endPointValue);
                    if (Math.abs(sweepAngleValue) > 0.0) {
                        if (directionValue != null) {
                            if (directionValue.equalsIgnoreCase(CCW)) {
                                if (!(sweepAngleValue >= 0.0)) {
                                    sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                                }
                            } else if (!(sweepAngleValue <= 0.0)) {
                                sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                            }
                        } else if (Math.signum(coefDirection) != Math.signum(sweepAngleValue)) {
                            sweepAngleValue = -(Math.PI * 2 - sweepAngleValue);
                        }
                        arc = GeometryUtils.createArc((Point)this.centerPointValue, (double)radiusValue, (double)startAngleValue, (double)sweepAngleValue, (int)0);
                    }
                }
            } else {
                arc = GeometryUtils.createArc((Point)startPointValue, (Point)middlePointValue, (Point)endPointValue, (int)subtype);
            }
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)arc);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
        this.centerPointValue = null;
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-arc-three-points";
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        if (parameter == this.radius) {
            if (this.centerPointValue != null || this.values.get(this.middlePoint) != null || this.values.get(this.endPoint) != null) {
                return false;
            }
        } else if (parameter == this.startAngle) {
            if (this.centerPointValue != null || this.values.get(this.middlePoint) != null || this.values.get(this.endPoint) != null) {
                return false;
            }
        } else if (parameter == this.sweepAngle) {
            if (this.values.get(this.endPoint) != null || this.values.get(this.middlePoint) != null) {
                return false;
            }
        } else if (parameter == this.direction) {
            if (this.values.get(this.endPoint) != null) {
                return false;
            }
            if (this.values.get(this.middlePoint) != null && this.centerPointValue != null) {
                return false;
            }
        }
        return true;
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

