/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolbarElement;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

public class SymbolButton
extends SymbolbarElement
implements ActionListener,
ItemListener {
    public static final int SYMBOLBUTTON_ACTION = 2200;
    public static final int SYMBOLBUTTON_ON = 2201;
    public static final int SYMBOLBUTTON_OFF = 2202;
    private boolean _pressed = false;
    private boolean _mousedown = false;
    private boolean _button_down = false;
    public Color pressedColor = new Color(222, 222, 222);
    public static final byte BUTTON = 1;
    public static final byte SWITCH_BUTTON = 2;
    public static final byte DONT_PAINT_BACKGROUND = 4;
    private byte _mode = 0;
    private MenuItem _menu_item = null;
    public int preferredHeight = 24;

    protected boolean buttonDown() {
        return this._button_down;
    }

    public boolean testMode(byte by) {
        return (this._mode & by) != 0;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() != this._menu_item) {
            return;
        }
        this.menuItemAction();
    }

    public boolean pressed() {
        return this._pressed;
    }

    public MenuItem generateMenuItem() {
        if (this.testMode((byte)2)) {
            this._menu_item = new CheckboxMenuItem(this.label, this._pressed);
            ((CheckboxMenuItem)this._menu_item).addItemListener(this);
        } else {
            this._menu_item = new MenuItem(this.label);
            this._menu_item.addActionListener(this);
        }
        this._menu_item.setActionCommand(this.command);
        this._menu_item.setEnabled(this.enabled());
        return this._menu_item;
    }

    public void unsetMode(byte by) {
        if ((this._mode & by) != 0) {
            this._mode = (byte)(this._mode ^ by);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._mousedown) {
            this._mousedown = false;
            if (this._pressed != this._button_down) {
                this._needs_repaint = true;
                this._pressed = this._button_down;
                this.action();
                if (this.testMode((byte)1)) {
                    this._button_down = false;
                    this._pressed = false;
                }
            }
        }
    }

    private void menuItemAction() {
        if (this._menu_item == null) {
            return;
        }
        if (this.testMode((byte)1)) {
            this._button_down = true;
            this._pressed = true;
            this.action();
            this._button_down = false;
            this._pressed = false;
        } else if (this._menu_item instanceof CheckboxMenuItem) {
            this._pressed = this._button_down = ((CheckboxMenuItem)this._menu_item).getState();
            this.action();
        } else {
            this._button_down = !this._pressed;
            this._pressed = this._button_down;
            this.action();
        }
        this.getParent().repaint();
    }

    public void onActivate() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this._menu_item) {
            return;
        }
        this.menuItemAction();
    }

    public void setCommand(String string) {
        super.setCommand(string);
        if (this._menu_item != null) {
            this._menu_item.setActionCommand(string);
        }
    }

    public void update(Graphics graphics, int n) {
        if (this._button_down) {
            if (!this.testMode((byte)4)) {
                if (!this.active()) {
                    Color color = graphics.getColor();
                    graphics.setColor(this.pressedColor);
                    graphics.fillRect(1, 1, this.width - 2, n - 2);
                    graphics.setColor(color);
                } else {
                    graphics.fillRect(1, 1, this.width - 2, n - 2);
                }
            }
            graphics.draw3DRect(0, 0, this.width - 1, n - 1, false);
            if (this.enabled()) {
                this.paintEnabled(graphics, n);
                return;
            }
            this.paintDisabled(graphics, n);
            return;
        }
        if (this.active()) {
            if (!this.testMode((byte)4)) {
                graphics.fillRect(1, 1, this.width - 2, n - 2);
            }
            graphics.draw3DRect(0, 0, this.width - 1, n - 1, true);
            this.paintEnabled(graphics, n);
            return;
        }
        if (this.enabled()) {
            this.paintEnabled(graphics, n);
            return;
        }
        this.paintDisabled(graphics, n);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._mousedown) {
            if (this.testMode((byte)1)) {
                this._button_down = true;
            } else {
                boolean bl = this._button_down = !this._pressed;
            }
        }
        if (!this.active()) {
            this.onActivate();
        }
        this.setActive(true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.active()) {
            this.onDeactivate();
        }
        if (this._mousedown) {
            this._button_down = this.testMode((byte)1) ? false : this._pressed;
        }
        this.setActive(false);
    }

    public void enable() {
        super.enable();
        if (this._menu_item != null) {
            this._menu_item.setEnabled(this.enabled());
        }
    }

    public void disable() {
        super.disable();
        if (this._menu_item != null) {
            this._menu_item.setEnabled(this.enabled());
        }
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public MenuItem menuItem() {
        return this._menu_item;
    }

    public void paintEnabled(Graphics graphics, int n) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void setMenuItem(MenuItem menuItem) {
        this._menu_item = menuItem;
        if (menuItem == null) {
            return;
        }
        this._menu_item.setActionCommand(this.command);
        this._menu_item.addActionListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._mousedown = true;
        this._button_down = this.testMode((byte)1) ? true : !this._pressed;
        this._needs_repaint = true;
    }

    public SymbolButton(String string, String string2, boolean bl) {
        this.label = string;
        this.command = string2;
        if (bl) {
            this.setMode((byte)2);
            return;
        }
        this.setMode((byte)1);
    }

    public SymbolButton(String string, boolean bl) {
        this(string, string, bl);
    }

    public SymbolButton(String string) {
        this(string, string, false);
    }

    public SymbolButton() {
        this("", "", false);
    }

    public void setMode(byte by) {
        if (by == 1 || by == 2) {
            this._mode = (byte)(this._mode ^ this._mode & 3);
        }
        this._mode = (byte)(this._mode | by);
    }

    public void paintDisabled(Graphics graphics, int n) {
    }

    public void onDeactivate() {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.setActive(true);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setButton(boolean bl) {
        this._button_down = this._pressed = bl;
        this._needs_repaint = true;
        if (this.testMode((byte)2) && this._menu_item != null && this._menu_item instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)this._menu_item).setState(bl);
        }
    }

    public void action() {
        if (this.testMode((byte)1)) {
            this.getParent().dispatchEvent(new ActionEvent(this, 2200, this.command, this.getParent().indexOf(this)));
            return;
        }
        if (this._menu_item instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)this._menu_item).setState(this._pressed);
        }
        if (this._pressed) {
            this.getParent().dispatchEvent(new ActionEvent(this, 2201, this.command, this.getParent().indexOf(this)));
            return;
        }
        this.getParent().dispatchEvent(new ActionEvent(this, 2202, this.command, this.getParent().indexOf(this)));
    }

    public void setLabel(String string) {
        super.setLabel(string);
        if (this._menu_item != null) {
            this._menu_item.setLabel(string);
        }
    }
}

